/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.security.impl;

import io.undertow.UndertowLogger;
import io.undertow.UndertowMessages;
import io.undertow.security.api.AuthenticationMechanism;
import io.undertow.security.api.AuthenticationMechanismFactory;
import io.undertow.security.api.SecurityContext;
import io.undertow.security.idm.Account;
import io.undertow.security.idm.IdentityManager;
import io.undertow.security.idm.PasswordCredential;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.form.FormParserFactory;
import io.undertow.util.FlexBase64;
import io.undertow.util.HeaderValues;
import io.undertow.util.Headers;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;

public class BasicAuthenticationMechanism
implements AuthenticationMechanism {
    public static final AuthenticationMechanismFactory FACTORY = new Factory();
    public static final String SILENT = "silent";
    public static final String CHARSET = "charset";
    public static final String USER_AGENT_CHARSETS = "user-agent-charsets";
    private final String name;
    private final String challenge;
    private static final String BASIC_PREFIX = Headers.BASIC + " ";
    private static final String LOWERCASE_BASIC_PREFIX = BASIC_PREFIX.toLowerCase(Locale.ENGLISH);
    private static final int PREFIX_LENGTH = BASIC_PREFIX.length();
    private static final String COLON = ":";
    private final boolean silent;
    private final IdentityManager identityManager;
    private final Charset charset;
    private final Map<Pattern, Charset> userAgentCharsets;

    public BasicAuthenticationMechanism(String realmName) {
        this(realmName, "BASIC");
    }

    public BasicAuthenticationMechanism(String realmName, String mechanismName) {
        this(realmName, mechanismName, false);
    }

    public BasicAuthenticationMechanism(String realmName, String mechanismName, boolean silent) {
        this(realmName, mechanismName, silent, null);
    }

    public BasicAuthenticationMechanism(String realmName, String mechanismName, boolean silent, IdentityManager identityManager) {
        this(realmName, mechanismName, silent, identityManager, StandardCharsets.UTF_8, Collections.emptyMap());
    }

    public BasicAuthenticationMechanism(String realmName, String mechanismName, boolean silent, IdentityManager identityManager, Charset charset, Map<Pattern, Charset> userAgentCharsets) {
        this.challenge = BASIC_PREFIX + "realm=\"" + realmName + "\"";
        this.name = mechanismName;
        this.silent = silent;
        this.identityManager = identityManager;
        this.charset = charset;
        this.userAgentCharsets = Collections.unmodifiableMap(new LinkedHashMap<Pattern, Charset>(userAgentCharsets));
    }

    private IdentityManager getIdentityManager(SecurityContext securityContext) {
        return this.identityManager != null ? this.identityManager : securityContext.getIdentityManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AuthenticationMechanism.AuthenticationMechanismOutcome authenticate(HttpServerExchange exchange, SecurityContext securityContext) {
        HeaderValues authHeaders = exchange.getRequestHeaders().get(Headers.AUTHORIZATION);
        if (authHeaders != null) {
            for (String current : authHeaders) {
                int colonPos;
                if (!current.toLowerCase(Locale.ENGLISH).startsWith(LOWERCASE_BASIC_PREFIX)) continue;
                String base64Challenge = current.substring(PREFIX_LENGTH);
                String plainChallenge = null;
                try {
                    String ua;
                    ByteBuffer decode = FlexBase64.decode(base64Challenge);
                    Charset charset = this.charset;
                    if (!this.userAgentCharsets.isEmpty() && (ua = exchange.getRequestHeaders().getFirst(Headers.USER_AGENT)) != null) {
                        for (Map.Entry<Pattern, Charset> entry : this.userAgentCharsets.entrySet()) {
                            if (!entry.getKey().matcher(ua).find()) continue;
                            charset = entry.getValue();
                            break;
                        }
                    }
                    plainChallenge = new String(decode.array(), decode.arrayOffset(), decode.limit(), charset);
                    UndertowLogger.SECURITY_LOGGER.debugf("Found basic auth header (decoded using charset %s) in %s", (Object)charset, (Object)exchange);
                }
                catch (IOException e2) {
                    UndertowLogger.SECURITY_LOGGER.debugf((Throwable)e2, "Failed to decode basic auth header in %s", (Object)exchange);
                }
                if (plainChallenge != null && (colonPos = plainChallenge.indexOf(COLON)) > -1) {
                    String userName = plainChallenge.substring(0, colonPos);
                    char[] password = plainChallenge.substring(colonPos + 1).toCharArray();
                    IdentityManager idm = this.getIdentityManager(securityContext);
                    PasswordCredential credential = new PasswordCredential(password);
                    try {
                        AuthenticationMechanism.AuthenticationMechanismOutcome result;
                        Account account = idm.verify(userName, credential);
                        if (account != null) {
                            securityContext.authenticationComplete(account, this.name, false);
                            result = AuthenticationMechanism.AuthenticationMechanismOutcome.AUTHENTICATED;
                        } else {
                            securityContext.authenticationFailed(UndertowMessages.MESSAGES.authenticationFailed(userName), this.name);
                            result = AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_AUTHENTICATED;
                        }
                        AuthenticationMechanism.AuthenticationMechanismOutcome authenticationMechanismOutcome = result;
                        return authenticationMechanismOutcome;
                    }
                    finally {
                        BasicAuthenticationMechanism.clear(password);
                    }
                }
                return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_AUTHENTICATED;
            }
        }
        return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_ATTEMPTED;
    }

    @Override
    public AuthenticationMechanism.ChallengeResult sendChallenge(HttpServerExchange exchange, SecurityContext securityContext) {
        String authHeader;
        if (this.silent && (authHeader = exchange.getRequestHeaders().getFirst(Headers.AUTHORIZATION)) == null) {
            return AuthenticationMechanism.ChallengeResult.NOT_SENT;
        }
        exchange.getResponseHeaders().add(Headers.WWW_AUTHENTICATE, this.challenge);
        UndertowLogger.SECURITY_LOGGER.debugf("Sending basic auth challenge %s for %s", (Object)this.challenge, (Object)exchange);
        return new AuthenticationMechanism.ChallengeResult(true, 401);
    }

    private static void clear(char[] array) {
        for (int i2 = 0; i2 < array.length; ++i2) {
            array[i2] = '\u0000';
        }
    }

    public static class Factory
    implements AuthenticationMechanismFactory {
        @Deprecated
        public Factory(IdentityManager identityManager) {
        }

        public Factory() {
        }

        @Override
        public AuthenticationMechanism create(String mechanismName, IdentityManager identityManager, FormParserFactory formParserFactory, Map<String, String> properties) {
            String realm = properties.get("realm");
            String silent = properties.get(BasicAuthenticationMechanism.SILENT);
            String charsetString = properties.get(BasicAuthenticationMechanism.CHARSET);
            Charset charset = charsetString == null ? StandardCharsets.UTF_8 : Charset.forName(charsetString);
            HashMap<Pattern, Charset> userAgentCharsets = new HashMap<Pattern, Charset>();
            String userAgentString = properties.get(BasicAuthenticationMechanism.USER_AGENT_CHARSETS);
            if (userAgentString != null) {
                String[] parts = userAgentString.split(",");
                if (parts.length % 2 != 0) {
                    throw UndertowMessages.MESSAGES.userAgentCharsetMustHaveEvenNumberOfItems(userAgentString);
                }
                for (int i2 = 0; i2 < parts.length; i2 += 2) {
                    Pattern pattern = Pattern.compile(parts[i2]);
                    Charset c2 = Charset.forName(parts[i2 + 1]);
                    userAgentCharsets.put(pattern, c2);
                }
            }
            return new BasicAuthenticationMechanism(realm, mechanismName, silent != null && silent.equals("true"), identityManager, charset, userAgentCharsets);
        }
    }
}

