/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.protocols.ssl;

import io.undertow.UndertowMessages;
import io.undertow.protocols.ssl.SNIContextMatcher;
import io.undertow.protocols.ssl.SNISSLExplorer;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.security.Principal;
import java.security.cert.Certificate;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import javax.net.ssl.SNIServerName;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSessionContext;
import javax.security.cert.X509Certificate;

class SNISSLEngine
extends SSLEngine {
    private static final SSLEngineResult UNDERFLOW_UNWRAP = new SSLEngineResult(SSLEngineResult.Status.BUFFER_UNDERFLOW, SSLEngineResult.HandshakeStatus.NEED_UNWRAP, 0, 0);
    private static final SSLEngineResult OK_UNWRAP = new SSLEngineResult(SSLEngineResult.Status.OK, SSLEngineResult.HandshakeStatus.NEED_UNWRAP, 0, 0);
    private final AtomicReference<SSLEngine> currentRef;
    private Function<SSLEngine, SSLEngine> selectionCallback = Function.identity();
    static final int FL_WANT_C_AUTH = 1;
    static final int FL_NEED_C_AUTH = 2;
    static final int FL_SESSION_CRE = 4;
    static final SSLEngine CLOSED_STATE = new SSLEngine(){

        @Override
        public SSLEngineResult wrap(ByteBuffer[] srcs, int offset, int length, ByteBuffer dst) throws SSLException {
            throw new SSLException(new ClosedChannelException());
        }

        @Override
        public SSLEngineResult unwrap(ByteBuffer src, ByteBuffer[] dsts, int offset, int length) throws SSLException {
            throw new SSLException(new ClosedChannelException());
        }

        @Override
        public Runnable getDelegatedTask() {
            return null;
        }

        @Override
        public void closeInbound() throws SSLException {
        }

        @Override
        public boolean isInboundDone() {
            return true;
        }

        @Override
        public void closeOutbound() {
        }

        @Override
        public boolean isOutboundDone() {
            return true;
        }

        @Override
        public String[] getSupportedCipherSuites() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String[] getEnabledCipherSuites() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setEnabledCipherSuites(String[] suites) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String[] getSupportedProtocols() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String[] getEnabledProtocols() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setEnabledProtocols(String[] protocols) {
            throw new UnsupportedOperationException();
        }

        @Override
        public SSLSession getSession() {
            return null;
        }

        @Override
        public void beginHandshake() throws SSLException {
            throw new SSLException(new ClosedChannelException());
        }

        @Override
        public SSLEngineResult.HandshakeStatus getHandshakeStatus() {
            return SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
        }

        @Override
        public void setUseClientMode(boolean mode) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean getUseClientMode() {
            return false;
        }

        @Override
        public void setNeedClientAuth(boolean need) {
        }

        @Override
        public boolean getNeedClientAuth() {
            return false;
        }

        @Override
        public void setWantClientAuth(boolean want) {
        }

        @Override
        public boolean getWantClientAuth() {
            return false;
        }

        @Override
        public void setEnableSessionCreation(boolean flag) {
        }

        @Override
        public boolean getEnableSessionCreation() {
            return false;
        }
    };

    SNISSLEngine(SNIContextMatcher selector) {
        this.currentRef = new AtomicReference<InitialState>(new InitialState(selector, SSLContext::createSSLEngine));
    }

    SNISSLEngine(SNIContextMatcher selector, String host, int port) {
        super(host, port);
        this.currentRef = new AtomicReference<InitialState>(new InitialState(selector, sslContext -> sslContext.createSSLEngine(host, port)));
    }

    public Function<SSLEngine, SSLEngine> getSelectionCallback() {
        return this.selectionCallback;
    }

    public void setSelectionCallback(Function<SSLEngine, SSLEngine> selectionCallback) {
        this.selectionCallback = selectionCallback;
    }

    @Override
    public SSLEngineResult wrap(ByteBuffer[] srcs, int offset, int length, ByteBuffer dst) throws SSLException {
        return this.currentRef.get().wrap(srcs, offset, length, dst);
    }

    @Override
    public SSLEngineResult wrap(ByteBuffer src, ByteBuffer dst) throws SSLException {
        return this.currentRef.get().wrap(src, dst);
    }

    @Override
    public SSLEngineResult wrap(ByteBuffer[] srcs, ByteBuffer dst) throws SSLException {
        return this.currentRef.get().wrap(srcs, dst);
    }

    @Override
    public SSLEngineResult unwrap(ByteBuffer src, ByteBuffer[] dsts, int offset, int length) throws SSLException {
        return this.currentRef.get().unwrap(src, dsts, offset, length);
    }

    @Override
    public SSLEngineResult unwrap(ByteBuffer src, ByteBuffer dst) throws SSLException {
        return this.currentRef.get().unwrap(src, dst);
    }

    @Override
    public SSLEngineResult unwrap(ByteBuffer src, ByteBuffer[] dsts) throws SSLException {
        return this.currentRef.get().unwrap(src, dsts);
    }

    @Override
    public String getPeerHost() {
        return this.currentRef.get().getPeerHost();
    }

    @Override
    public int getPeerPort() {
        return this.currentRef.get().getPeerPort();
    }

    @Override
    public SSLSession getHandshakeSession() {
        return this.currentRef.get().getHandshakeSession();
    }

    @Override
    public SSLParameters getSSLParameters() {
        return this.currentRef.get().getSSLParameters();
    }

    @Override
    public void setSSLParameters(SSLParameters params) {
        this.currentRef.get().setSSLParameters(params);
    }

    @Override
    public Runnable getDelegatedTask() {
        return this.currentRef.get().getDelegatedTask();
    }

    @Override
    public void closeInbound() throws SSLException {
        this.currentRef.get().closeInbound();
    }

    @Override
    public boolean isInboundDone() {
        return this.currentRef.get().isInboundDone();
    }

    @Override
    public void closeOutbound() {
        this.currentRef.get().closeOutbound();
    }

    @Override
    public boolean isOutboundDone() {
        return this.currentRef.get().isOutboundDone();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.currentRef.get().getSupportedCipherSuites();
    }

    @Override
    public String[] getEnabledCipherSuites() {
        return this.currentRef.get().getEnabledCipherSuites();
    }

    @Override
    public void setEnabledCipherSuites(String[] cipherSuites) {
        this.currentRef.get().setEnabledCipherSuites(cipherSuites);
    }

    @Override
    public String[] getSupportedProtocols() {
        return this.currentRef.get().getSupportedProtocols();
    }

    @Override
    public String[] getEnabledProtocols() {
        return this.currentRef.get().getEnabledProtocols();
    }

    @Override
    public void setEnabledProtocols(String[] protocols) {
        this.currentRef.get().setEnabledProtocols(protocols);
    }

    @Override
    public SSLSession getSession() {
        return this.currentRef.get().getSession();
    }

    @Override
    public void beginHandshake() throws SSLException {
        this.currentRef.get().beginHandshake();
    }

    @Override
    public SSLEngineResult.HandshakeStatus getHandshakeStatus() {
        return this.currentRef.get().getHandshakeStatus();
    }

    @Override
    public void setUseClientMode(boolean clientMode) {
        this.currentRef.get().setUseClientMode(clientMode);
    }

    @Override
    public boolean getUseClientMode() {
        return this.currentRef.get().getUseClientMode();
    }

    @Override
    public void setNeedClientAuth(boolean clientAuth) {
        this.currentRef.get().setNeedClientAuth(clientAuth);
    }

    @Override
    public boolean getNeedClientAuth() {
        return this.currentRef.get().getNeedClientAuth();
    }

    @Override
    public void setWantClientAuth(boolean want) {
        this.currentRef.get().setWantClientAuth(want);
    }

    @Override
    public boolean getWantClientAuth() {
        return this.currentRef.get().getWantClientAuth();
    }

    @Override
    public void setEnableSessionCreation(boolean flag) {
        this.currentRef.get().setEnableSessionCreation(flag);
    }

    @Override
    public boolean getEnableSessionCreation() {
        return this.currentRef.get().getEnableSessionCreation();
    }

    class InitialState
    extends SSLEngine {
        private final SNIContextMatcher selector;
        private final AtomicInteger flags = new AtomicInteger(4);
        private final Function<SSLContext, SSLEngine> engineFunction;
        private int packetBufferSize = 5;
        private String[] enabledSuites;
        private String[] enabledProtocols;
        private final SSLSession handshakeSession = new SSLSession(){

            @Override
            public byte[] getId() {
                throw new UnsupportedOperationException();
            }

            @Override
            public SSLSessionContext getSessionContext() {
                throw new UnsupportedOperationException();
            }

            @Override
            public long getCreationTime() {
                throw new UnsupportedOperationException();
            }

            @Override
            public long getLastAccessedTime() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void invalidate() {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean isValid() {
                return false;
            }

            @Override
            public void putValue(String s2, Object o2) {
                throw new UnsupportedOperationException();
            }

            @Override
            public Object getValue(String s2) {
                return null;
            }

            @Override
            public void removeValue(String s2) {
            }

            @Override
            public String[] getValueNames() {
                throw new UnsupportedOperationException();
            }

            @Override
            public Certificate[] getPeerCertificates() throws SSLPeerUnverifiedException {
                throw new UnsupportedOperationException();
            }

            @Override
            public Certificate[] getLocalCertificates() {
                return null;
            }

            @Override
            public X509Certificate[] getPeerCertificateChain() throws SSLPeerUnverifiedException {
                throw new UnsupportedOperationException();
            }

            @Override
            public Principal getPeerPrincipal() throws SSLPeerUnverifiedException {
                throw new UnsupportedOperationException();
            }

            @Override
            public Principal getLocalPrincipal() {
                throw new UnsupportedOperationException();
            }

            @Override
            public String getCipherSuite() {
                throw new UnsupportedOperationException();
            }

            @Override
            public String getProtocol() {
                throw new UnsupportedOperationException();
            }

            @Override
            public String getPeerHost() {
                return SNISSLEngine.this.getPeerHost();
            }

            @Override
            public int getPeerPort() {
                return SNISSLEngine.this.getPeerPort();
            }

            @Override
            public int getPacketBufferSize() {
                return InitialState.this.packetBufferSize;
            }

            @Override
            public int getApplicationBufferSize() {
                throw new UnsupportedOperationException();
            }
        };

        InitialState(SNIContextMatcher selector, Function<SSLContext, SSLEngine> engineFunction) {
            this.selector = selector;
            this.engineFunction = engineFunction;
        }

        @Override
        public SSLSession getHandshakeSession() {
            return this.handshakeSession;
        }

        @Override
        public SSLEngineResult wrap(ByteBuffer[] srcs, int offset, int length, ByteBuffer dst) throws SSLException {
            return OK_UNWRAP;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SSLEngineResult unwrap(ByteBuffer src, ByteBuffer[] dsts, int offset, int length) throws SSLException {
            SSLEngine next;
            int mark = src.position();
            try {
                if (src.remaining() < 5) {
                    this.packetBufferSize = 5;
                    SSLEngineResult sSLEngineResult = UNDERFLOW_UNWRAP;
                    return sSLEngineResult;
                }
                int requiredSize = SNISSLExplorer.getRequiredSize(src);
                if (src.remaining() < requiredSize) {
                    this.packetBufferSize = requiredSize;
                    SSLEngineResult sSLEngineResult = UNDERFLOW_UNWRAP;
                    return sSLEngineResult;
                }
                List<SNIServerName> names = SNISSLExplorer.explore(src);
                SSLContext sslContext = this.selector.getContext(names);
                if (sslContext == null) {
                    throw UndertowMessages.MESSAGES.noContextForSslConnection();
                }
                next = this.engineFunction.apply(sslContext);
                if (this.enabledSuites != null) {
                    next.setEnabledCipherSuites(this.enabledSuites);
                }
                if (this.enabledProtocols != null) {
                    next.setEnabledProtocols(this.enabledProtocols);
                }
                next.setUseClientMode(false);
                int flagsVal = this.flags.get();
                if ((flagsVal & 1) != 0) {
                    next.setWantClientAuth(true);
                } else if ((flagsVal & 2) != 0) {
                    next.setNeedClientAuth(true);
                }
                if ((flagsVal & 4) != 0) {
                    next.setEnableSessionCreation(true);
                }
                next = SNISSLEngine.this.selectionCallback.apply(next);
                SNISSLEngine.this.currentRef.set(next);
            }
            finally {
                src.position(mark);
            }
            return next.unwrap(src, dsts, offset, length);
        }

        @Override
        public Runnable getDelegatedTask() {
            return null;
        }

        @Override
        public void closeInbound() throws SSLException {
            SNISSLEngine.this.currentRef.set(CLOSED_STATE);
        }

        @Override
        public boolean isInboundDone() {
            return false;
        }

        @Override
        public void closeOutbound() {
            SNISSLEngine.this.currentRef.set(CLOSED_STATE);
        }

        @Override
        public boolean isOutboundDone() {
            return false;
        }

        @Override
        public String[] getSupportedCipherSuites() {
            if (this.enabledSuites == null) {
                return new String[0];
            }
            return this.enabledSuites;
        }

        @Override
        public String[] getEnabledCipherSuites() {
            return this.enabledSuites;
        }

        @Override
        public void setEnabledCipherSuites(String[] suites) {
            this.enabledSuites = suites;
        }

        @Override
        public String[] getSupportedProtocols() {
            if (this.enabledProtocols == null) {
                return new String[0];
            }
            return this.enabledProtocols;
        }

        @Override
        public String[] getEnabledProtocols() {
            return this.enabledProtocols;
        }

        @Override
        public void setEnabledProtocols(String[] protocols) {
            this.enabledProtocols = protocols;
        }

        @Override
        public SSLSession getSession() {
            return null;
        }

        @Override
        public void beginHandshake() throws SSLException {
        }

        @Override
        public SSLEngineResult.HandshakeStatus getHandshakeStatus() {
            return SSLEngineResult.HandshakeStatus.NEED_UNWRAP;
        }

        @Override
        public void setUseClientMode(boolean mode) {
            if (mode) {
                throw new UnsupportedOperationException();
            }
        }

        @Override
        public boolean getUseClientMode() {
            return false;
        }

        @Override
        public void setNeedClientAuth(boolean need) {
            int newVal;
            int oldVal;
            AtomicInteger flags = this.flags;
            do {
                if (((oldVal = flags.get()) & 2) != 0 != need) continue;
                return;
            } while (!flags.compareAndSet(oldVal, newVal = oldVal & 4 | 2));
        }

        @Override
        public boolean getNeedClientAuth() {
            return (this.flags.get() & 2) != 0;
        }

        @Override
        public void setWantClientAuth(boolean want) {
            int newVal;
            int oldVal;
            AtomicInteger flags = this.flags;
            do {
                if (((oldVal = flags.get()) & 1) != 0 != want) continue;
                return;
            } while (!flags.compareAndSet(oldVal, newVal = oldVal & 4 | 1));
        }

        @Override
        public boolean getWantClientAuth() {
            return (this.flags.get() & 1) != 0;
        }

        @Override
        public void setEnableSessionCreation(boolean flag) {
            int newVal;
            int oldVal;
            AtomicInteger flags = this.flags;
            do {
                if (((oldVal = flags.get()) & 4) != 0 != flag) continue;
                return;
            } while (!flags.compareAndSet(oldVal, newVal = oldVal ^ 4));
        }

        @Override
        public boolean getEnableSessionCreation() {
            return (this.flags.get() & 4) != 0;
        }
    }
}

