/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.protocols.ajp;

import io.undertow.UndertowMessages;
import io.undertow.UndertowOptions;
import io.undertow.client.ProxiedRequestAttachments;
import io.undertow.connector.PooledByteBuffer;
import io.undertow.protocols.ajp.AbstractAjpClientStreamSinkChannel;
import io.undertow.protocols.ajp.AjpClientChannel;
import io.undertow.protocols.ajp.AjpConstants;
import io.undertow.protocols.ajp.AjpUtils;
import io.undertow.server.protocol.framed.SendFrameHeader;
import io.undertow.util.Attachable;
import io.undertow.util.HeaderMap;
import io.undertow.util.Headers;
import io.undertow.util.HexConverter;
import io.undertow.util.HttpString;
import io.undertow.util.ImmediatePooledByteBuffer;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import org.xnio.ChannelListener;

public class AjpClientRequestClientStreamSinkChannel
extends AbstractAjpClientStreamSinkChannel {
    private final ChannelListener<AjpClientRequestClientStreamSinkChannel> finishListener;
    public static final int DEFAULT_MAX_DATA_SIZE = 8192;
    private final HeaderMap headers;
    private final String path;
    private final HttpString method;
    private final HttpString protocol;
    private final Attachable attachable;
    private boolean firstFrameWritten = false;
    private long dataSize;
    private int requestedChunkSize = -1;
    private SendFrameHeader header;
    private boolean discardMode = false;

    AjpClientRequestClientStreamSinkChannel(AjpClientChannel channel, ChannelListener<AjpClientRequestClientStreamSinkChannel> finishListener, HeaderMap headers, String path, HttpString method, HttpString protocol, Attachable attachable) {
        super(channel);
        this.finishListener = finishListener;
        this.headers = headers;
        this.path = path;
        this.method = method;
        this.protocol = protocol;
        this.attachable = attachable;
    }

    private SendFrameHeader createFrameHeaderImpl() {
        if (this.discardMode) {
            this.getBuffer().clear();
            this.getBuffer().flip();
            return new SendFrameHeader(new ImmediatePooledByteBuffer(ByteBuffer.wrap(new byte[0])));
        }
        PooledByteBuffer pooledHeaderBuffer = ((AjpClientChannel)this.getChannel()).getBufferPool().allocate();
        try {
            ByteBuffer buffer = pooledHeaderBuffer.getBuffer();
            ByteBuffer dataBuffer = this.getBuffer();
            int dataInBuffer = dataBuffer.remaining();
            if (!this.firstFrameWritten && this.requestedChunkSize == 0) {
                return new SendFrameHeader(dataInBuffer, null);
            }
            int maxData = ((AjpClientChannel)this.getChannel()).getSettings().get(UndertowOptions.MAX_AJP_PACKET_SIZE, 8192) - 6;
            if (!this.firstFrameWritten) {
                String secret;
                Integer sslKeySize;
                byte[] sslSession;
                String sslCypher;
                String sslCert;
                String route;
                String authType;
                String remoteUser;
                String queryString;
                String path;
                String contentLength = this.headers.getFirst(Headers.CONTENT_LENGTH);
                if (contentLength != null) {
                    this.dataSize = Long.parseLong(contentLength);
                    this.requestedChunkSize = maxData;
                    if ((long)dataInBuffer > this.dataSize) {
                        throw UndertowMessages.MESSAGES.fixedLengthOverflow();
                    }
                } else if (this.isWritesShutdown() && !this.headers.contains(Headers.TRANSFER_ENCODING)) {
                    this.headers.put(Headers.CONTENT_LENGTH, dataInBuffer);
                    this.dataSize = dataInBuffer;
                    this.requestedChunkSize = maxData;
                } else {
                    this.headers.put(Headers.TRANSFER_ENCODING, Headers.CHUNKED.toString());
                    this.dataSize = -1L;
                    this.requestedChunkSize = 0;
                }
                this.firstFrameWritten = true;
                int qsIndex = this.path.indexOf(63);
                if (qsIndex == -1) {
                    path = this.path;
                    queryString = null;
                } else {
                    path = this.path.substring(0, qsIndex);
                    queryString = this.path.substring(qsIndex + 1);
                }
                buffer.put((byte)18);
                buffer.put((byte)52);
                buffer.put((byte)0);
                buffer.put((byte)0);
                buffer.put((byte)2);
                boolean storeMethod = false;
                Integer methodNp = AjpConstants.HTTP_METHODS_MAP.get(this.method);
                if (methodNp == null) {
                    methodNp = 255;
                    storeMethod = true;
                }
                buffer.put((byte)methodNp.intValue());
                AjpUtils.putHttpString(buffer, this.protocol);
                AjpUtils.putString(buffer, path);
                AjpUtils.putString(buffer, AjpUtils.notNull(this.attachable.getAttachment(ProxiedRequestAttachments.REMOTE_ADDRESS)));
                AjpUtils.putString(buffer, AjpUtils.notNull(this.attachable.getAttachment(ProxiedRequestAttachments.REMOTE_HOST)));
                AjpUtils.putString(buffer, AjpUtils.notNull(this.attachable.getAttachment(ProxiedRequestAttachments.SERVER_NAME)));
                AjpUtils.putInt(buffer, AjpUtils.notNull(this.attachable.getAttachment(ProxiedRequestAttachments.SERVER_PORT)));
                buffer.put((byte)(AjpUtils.notNull(this.attachable.getAttachment(ProxiedRequestAttachments.IS_SSL)) ? 1 : 0));
                int headers = 0;
                HeaderMap responseHeaders = this.headers;
                for (HttpString name : responseHeaders.getHeaderNames()) {
                    headers += responseHeaders.get(name).size();
                }
                AjpUtils.putInt(buffer, headers);
                for (HttpString header : responseHeaders.getHeaderNames()) {
                    for (String headerValue : responseHeaders.get(header)) {
                        Integer headerCode = AjpConstants.HEADER_MAP.get(header);
                        if (headerCode != null) {
                            AjpUtils.putInt(buffer, headerCode);
                        } else {
                            AjpUtils.putHttpString(buffer, header);
                        }
                        AjpUtils.putString(buffer, headerValue);
                    }
                }
                if (queryString != null) {
                    buffer.put((byte)5);
                    AjpUtils.putString(buffer, queryString);
                }
                if ((remoteUser = this.attachable.getAttachment(ProxiedRequestAttachments.REMOTE_USER)) != null) {
                    buffer.put((byte)3);
                    AjpUtils.putString(buffer, remoteUser);
                }
                if ((authType = this.attachable.getAttachment(ProxiedRequestAttachments.AUTH_TYPE)) != null) {
                    buffer.put((byte)4);
                    AjpUtils.putString(buffer, authType);
                }
                if ((route = this.attachable.getAttachment(ProxiedRequestAttachments.ROUTE)) != null) {
                    buffer.put((byte)6);
                    AjpUtils.putString(buffer, route);
                }
                if ((sslCert = this.attachable.getAttachment(ProxiedRequestAttachments.SSL_CERT)) != null) {
                    buffer.put((byte)7);
                    AjpUtils.putString(buffer, sslCert);
                }
                if ((sslCypher = this.attachable.getAttachment(ProxiedRequestAttachments.SSL_CYPHER)) != null) {
                    buffer.put((byte)8);
                    AjpUtils.putString(buffer, sslCypher);
                }
                if ((sslSession = this.attachable.getAttachment(ProxiedRequestAttachments.SSL_SESSION_ID)) != null) {
                    buffer.put((byte)9);
                    AjpUtils.putString(buffer, HexConverter.convertToHexString(sslSession));
                }
                if ((sslKeySize = this.attachable.getAttachment(ProxiedRequestAttachments.SSL_KEY_SIZE)) != null) {
                    buffer.put((byte)11);
                    AjpUtils.putString(buffer, sslKeySize.toString());
                }
                if ((secret = this.attachable.getAttachment(ProxiedRequestAttachments.SECRET)) != null) {
                    buffer.put((byte)12);
                    AjpUtils.putString(buffer, secret);
                }
                if (storeMethod) {
                    buffer.put((byte)13);
                    AjpUtils.putString(buffer, this.method.toString());
                }
                buffer.put((byte)-1);
                int dataLength = buffer.position() - 4;
                buffer.put(2, (byte)(dataLength >> 8 & 0xFF));
                buffer.put(3, (byte)(dataLength & 0xFF));
            }
            if (this.dataSize == 0L) {
                buffer.flip();
                return new SendFrameHeader(pooledHeaderBuffer);
            }
            if (this.requestedChunkSize > 0) {
                if (this.isWritesShutdown() && dataInBuffer == 0) {
                    buffer.put((byte)18);
                    buffer.put((byte)52);
                    buffer.put((byte)0);
                    buffer.put((byte)2);
                    buffer.put((byte)0);
                    buffer.put((byte)0);
                    buffer.flip();
                    return new SendFrameHeader(pooledHeaderBuffer);
                }
                int remaining = dataInBuffer;
                remaining = Math.min(remaining, maxData);
                remaining = Math.min(remaining, this.requestedChunkSize);
                int bodySize = remaining + 2;
                buffer.put((byte)18);
                buffer.put((byte)52);
                buffer.put((byte)(bodySize >> 8 & 0xFF));
                buffer.put((byte)(bodySize & 0xFF));
                buffer.put((byte)(remaining >> 8 & 0xFF));
                buffer.put((byte)(remaining & 0xFF));
                this.requestedChunkSize = 0;
                if (remaining < dataInBuffer) {
                    dataBuffer.limit(this.getBuffer().position() + remaining);
                    buffer.flip();
                    return new SendFrameHeader(dataInBuffer - remaining, pooledHeaderBuffer, this.dataSize < 0L);
                }
                buffer.flip();
                return new SendFrameHeader(0, pooledHeaderBuffer, this.dataSize < 0L);
            }
            buffer.flip();
            if (buffer.remaining() == 0) {
                pooledHeaderBuffer.close();
                return new SendFrameHeader(dataInBuffer, null, true);
            }
            dataBuffer.limit(dataBuffer.position());
            return new SendFrameHeader(dataInBuffer, pooledHeaderBuffer, true);
        }
        catch (BufferOverflowException e2) {
            pooledHeaderBuffer.close();
            this.markBroken();
            throw e2;
        }
    }

    SendFrameHeader generateSendFrameHeader() {
        this.header = this.createFrameHeaderImpl();
        return this.header;
    }

    void chunkRequested(int size) throws IOException {
        this.requestedChunkSize = size;
        ((AjpClientChannel)this.getChannel()).recalculateHeldFrames();
    }

    public void startDiscard() {
        this.discardMode = true;
        try {
            ((AjpClientChannel)this.getChannel()).recalculateHeldFrames();
        }
        catch (IOException e2) {
            this.markBroken();
        }
    }

    @Override
    protected final SendFrameHeader createFrameHeader() {
        SendFrameHeader header = this.header;
        this.header = null;
        return header;
    }

    @Override
    protected void handleFlushComplete(boolean finalFrame) {
        super.handleFlushComplete(finalFrame);
        if (finalFrame) {
            ((AjpClientChannel)this.getChannel()).sinkDone();
        }
        if (finalFrame && this.finishListener != null) {
            this.finishListener.handleEvent(this);
        }
    }

    @Override
    protected void channelForciblyClosed() throws IOException {
        super.channelForciblyClosed();
        ((AjpClientChannel)this.getChannel()).sinkDone();
        this.finishListener.handleEvent(this);
    }

    public void clearHeader() {
        this.header = null;
    }
}

