/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.conduits;

import io.undertow.UndertowLogger;
import io.undertow.connector.PooledByteBuffer;
import io.undertow.server.Connectors;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.ConduitFactory;
import io.undertow.util.Headers;
import io.undertow.util.NewInstanceObjectPool;
import io.undertow.util.ObjectPool;
import io.undertow.util.PooledObject;
import io.undertow.util.SimpleObjectPool;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.util.concurrent.TimeUnit;
import java.util.zip.Deflater;
import org.xnio.Bits;
import org.xnio.Buffers;
import org.xnio.IoUtils;
import org.xnio.XnioIoThread;
import org.xnio.XnioWorker;
import org.xnio.channels.StreamSourceChannel;
import org.xnio.conduits.ConduitStreamSinkChannel;
import org.xnio.conduits.ConduitWritableByteChannel;
import org.xnio.conduits.Conduits;
import org.xnio.conduits.StreamSinkConduit;
import org.xnio.conduits.WriteReadyHandler;

public class DeflatingStreamSinkConduit
implements StreamSinkConduit {
    private static final ByteBuffer EMPTY = ByteBuffer.allocate(0);
    protected volatile Deflater deflater;
    protected final PooledObject<Deflater> pooledObject;
    private final ConduitFactory<StreamSinkConduit> conduitFactory;
    private final HttpServerExchange exchange;
    private StreamSinkConduit next;
    private WriteReadyHandler writeReadyHandler;
    protected PooledByteBuffer currentBuffer;
    private ByteBuffer trailerBuffer;
    private int state = 0;
    private static final int SHUTDOWN = 1;
    private static final int NEXT_SHUTDOWN = 2;
    private static final int FLUSHING_BUFFER = 4;
    private static final int WRITES_RESUMED = 8;
    private static final int CLOSED = 16;
    private static final int WRITTEN_TRAILER = 32;

    public DeflatingStreamSinkConduit(ConduitFactory<StreamSinkConduit> conduitFactory, HttpServerExchange exchange) {
        this(conduitFactory, exchange, 8);
    }

    public DeflatingStreamSinkConduit(ConduitFactory<StreamSinkConduit> conduitFactory, HttpServerExchange exchange, int deflateLevel) {
        this(conduitFactory, exchange, DeflatingStreamSinkConduit.newInstanceDeflaterPool(deflateLevel));
    }

    public DeflatingStreamSinkConduit(ConduitFactory<StreamSinkConduit> conduitFactory, HttpServerExchange exchange, ObjectPool<Deflater> deflaterPool) {
        this.pooledObject = deflaterPool.allocate();
        this.deflater = this.pooledObject.getObject();
        this.currentBuffer = exchange.getConnection().getByteBufferPool().allocate();
        this.exchange = exchange;
        this.conduitFactory = conduitFactory;
        this.setWriteReadyHandler(new WriteReadyHandler.ChannelListenerHandler<ConduitStreamSinkChannel>(Connectors.getConduitSinkChannel(exchange)));
    }

    public static ObjectPool<Deflater> newInstanceDeflaterPool(int deflateLevel) {
        return new NewInstanceObjectPool<Deflater>(() -> new Deflater(deflateLevel, true), Deflater::end);
    }

    public static ObjectPool<Deflater> simpleDeflaterPool(int poolSize, int deflateLevel) {
        return new SimpleObjectPool<Deflater>(poolSize, () -> new Deflater(deflateLevel, true), Deflater::reset, Deflater::end);
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        if (Bits.anyAreSet(this.state, 17) || this.currentBuffer == null) {
            throw new ClosedChannelException();
        }
        try {
            if (!this.performFlushIfRequired()) {
                return 0;
            }
            if (!src.hasRemaining()) {
                return 0;
            }
            int initialSrcPosition = src.position();
            int initialRemaining = src.remaining();
            this.deflater.setInput(src);
            this.deflateData(false);
            int consumed = initialRemaining - src.remaining();
            Connectors.updateResponseBytesSent(this.exchange, -consumed);
            int endSrcPosition = src.position();
            int srcLimit = src.limit();
            src.position(initialSrcPosition);
            src.limit(endSrcPosition);
            this.postDeflate(src);
            src.limit(srcLimit);
            src.position(endSrcPosition);
            this.deflater.setInput(EMPTY);
            return consumed;
        }
        catch (IOException | Error | RuntimeException e2) {
            this.freeBuffer();
            throw e2;
        }
    }

    protected void postDeflate(ByteBuffer data) {
    }

    @Override
    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        if (Bits.anyAreSet(this.state, 17) || this.currentBuffer == null) {
            throw new ClosedChannelException();
        }
        try {
            int total = 0;
            for (int i2 = offset; i2 < offset + length; ++i2) {
                ByteBuffer buf = srcs[i2];
                if (!buf.hasRemaining()) continue;
                int ret = this.write(buf);
                total += ret;
                if (ret != 0 && !buf.hasRemaining()) continue;
                return total;
            }
            return total;
        }
        catch (IOException | Error | RuntimeException e2) {
            this.freeBuffer();
            throw e2;
        }
    }

    @Override
    public int writeFinal(ByteBuffer src) throws IOException {
        return Conduits.writeFinalBasic(this, src);
    }

    @Override
    public long writeFinal(ByteBuffer[] srcs, int offset, int length) throws IOException {
        return Conduits.writeFinalBasic(this, srcs, offset, length);
    }

    @Override
    public long transferFrom(FileChannel src, long position, long count) throws IOException {
        if (Bits.anyAreSet(this.state, 17)) {
            throw new ClosedChannelException();
        }
        if (!this.performFlushIfRequired()) {
            return 0L;
        }
        return src.transferTo(position, count, new ConduitWritableByteChannel(this));
    }

    @Override
    public long transferFrom(StreamSourceChannel source, long count, ByteBuffer throughBuffer) throws IOException {
        if (Bits.anyAreSet(this.state, 17)) {
            throw new ClosedChannelException();
        }
        if (!this.performFlushIfRequired()) {
            return 0L;
        }
        return IoUtils.transfer(source, count, throughBuffer, new ConduitWritableByteChannel(this));
    }

    @Override
    public XnioWorker getWorker() {
        return this.exchange.getConnection().getWorker();
    }

    @Override
    public void suspendWrites() {
        if (this.next == null) {
            this.state &= 0xFFFFFFF7;
        } else {
            this.next.suspendWrites();
        }
    }

    @Override
    public boolean isWriteResumed() {
        if (this.next == null) {
            return Bits.anyAreSet(this.state, 8);
        }
        return this.next.isWriteResumed();
    }

    @Override
    public void wakeupWrites() {
        if (this.next == null) {
            this.resumeWrites();
        } else {
            this.next.wakeupWrites();
        }
    }

    @Override
    public void resumeWrites() {
        if (this.next == null) {
            this.state |= 8;
            this.queueWriteListener();
        } else {
            this.next.resumeWrites();
        }
    }

    private void queueWriteListener() {
        this.exchange.getConnection().getIoThread().execute(new Runnable(){

            @Override
            public void run() {
                if (DeflatingStreamSinkConduit.this.writeReadyHandler != null) {
                    try {
                        DeflatingStreamSinkConduit.this.writeReadyHandler.writeReady();
                    }
                    finally {
                        if (DeflatingStreamSinkConduit.this.next == null && DeflatingStreamSinkConduit.this.isWriteResumed()) {
                            DeflatingStreamSinkConduit.this.queueWriteListener();
                        }
                    }
                }
            }
        });
    }

    @Override
    public void terminateWrites() throws IOException {
        if (this.deflater != null) {
            this.deflater.finish();
        }
        this.state |= 1;
    }

    @Override
    public boolean isWriteShutdown() {
        return Bits.anyAreSet(this.state, 1);
    }

    @Override
    public void awaitWritable() throws IOException {
        if (this.next == null) {
            return;
        }
        this.next.awaitWritable();
    }

    @Override
    public void awaitWritable(long time, TimeUnit timeUnit) throws IOException {
        if (this.next == null) {
            return;
        }
        this.next.awaitWritable(time, timeUnit);
    }

    @Override
    public XnioIoThread getWriteThread() {
        return this.exchange.getConnection().getIoThread();
    }

    @Override
    public void setWriteReadyHandler(WriteReadyHandler handler) {
        this.writeReadyHandler = handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean flush() throws IOException {
        if (this.currentBuffer == null) {
            if (!Bits.anyAreSet(this.state, 2)) return true;
            return this.next.flush();
        }
        try {
            boolean nextCreated = false;
            try {
                if (Bits.anyAreSet(this.state, 1)) {
                    if (Bits.anyAreSet(this.state, 2)) {
                        boolean bl = this.next.flush();
                        return bl;
                    }
                    if (!this.performFlushIfRequired()) {
                        boolean bl = false;
                        return bl;
                    }
                    if (!this.deflater.finished()) {
                        this.deflateData(false);
                        if (!this.deflater.finished()) {
                            boolean bl = false;
                            return bl;
                        }
                    }
                    ByteBuffer buffer = this.currentBuffer.getBuffer();
                    if (Bits.allAreClear(this.state, 32)) {
                        this.state |= 0x20;
                        byte[] data = this.getTrailer();
                        if (data != null) {
                            Connectors.updateResponseBytesSent(this.exchange, data.length);
                            if (this.trailerBuffer != null) {
                                throw new IllegalStateException("trailerBuffer is already set");
                            }
                            if (Bits.anyAreSet(this.state, 4) && buffer.capacity() - buffer.remaining() >= data.length) {
                                buffer.compact();
                                buffer.put(data);
                                buffer.flip();
                            } else if (data.length <= buffer.remaining() && !Bits.anyAreSet(this.state, 4)) {
                                buffer.put(data);
                            } else {
                                this.trailerBuffer = ByteBuffer.wrap(data);
                            }
                        }
                    }
                    if (!Bits.anyAreSet(this.state, 4)) {
                        buffer.flip();
                        this.state |= 4;
                        if (this.next == null) {
                            nextCreated = true;
                            this.next = this.createNextChannel();
                        }
                    }
                    if (this.performFlushIfRequired()) {
                        this.state |= 2;
                        this.freeBuffer();
                        this.next.terminateWrites();
                        boolean data = this.next.flush();
                        return data;
                    }
                    boolean data = false;
                    return data;
                }
                if (Bits.allAreClear(this.state, 4)) {
                    if (this.next == null) {
                        nextCreated = true;
                        this.next = this.createNextChannel();
                    }
                    this.deflateData(true);
                    if (Bits.allAreClear(this.state, 4)) {
                        this.currentBuffer.getBuffer().flip();
                        this.state |= 4;
                    }
                }
                if (!this.performFlushIfRequired()) {
                    boolean bl = false;
                    return bl;
                }
                boolean bl = this.next.flush();
                return bl;
            }
            finally {
                if (nextCreated && Bits.anyAreSet(this.state, 8) && !Bits.anyAreSet(this.state, 2)) {
                    try {
                        this.next.resumeWrites();
                    }
                    catch (Throwable e2) {
                        UndertowLogger.REQUEST_LOGGER.debug("Failed to resume", e2);
                    }
                }
            }
        }
        catch (IOException | Error | RuntimeException e3) {
            this.freeBuffer();
            throw e3;
        }
    }

    protected byte[] getTrailer() {
        return null;
    }

    private boolean performFlushIfRequired() throws IOException {
        if (Bits.anyAreSet(this.state, 4)) {
            return this.trailerBuffer == null ? this.performFlushIfRequiredSingleBuffer() : this.performFlushIfRequiredAdditionalBuffer();
        }
        return true;
    }

    private boolean performFlushIfRequiredSingleBuffer() throws IOException {
        ByteBuffer buf = this.currentBuffer.getBuffer();
        long totalLength = buf.remaining();
        if (totalLength > 0L) {
            int total = 0;
            int res = 0;
            do {
                res = this.next.write(buf);
                total += res;
                if (res != 0) continue;
                return false;
            } while ((long)total < totalLength);
        }
        this.currentBuffer.getBuffer().clear();
        this.state &= 0xFFFFFFFB;
        return true;
    }

    private boolean performFlushIfRequiredAdditionalBuffer() throws IOException {
        Buffer[] bufs = new ByteBuffer[]{this.currentBuffer.getBuffer(), this.trailerBuffer};
        long totalLength = Buffers.remaining(bufs);
        if (totalLength > 0L) {
            long total = 0L;
            long res = 0L;
            do {
                res = this.next.write((ByteBuffer[])bufs, 0, bufs.length);
                total += res;
                if (res != 0L) continue;
                return false;
            } while (total < totalLength);
        }
        this.trailerBuffer = null;
        this.currentBuffer.getBuffer().clear();
        this.state &= 0xFFFFFFFB;
        return true;
    }

    private StreamSinkConduit createNextChannel() {
        if (this.deflater.finished() && Bits.allAreSet(this.state, 32)) {
            int remaining = this.currentBuffer.getBuffer().remaining();
            if (this.trailerBuffer != null) {
                remaining += this.trailerBuffer.remaining();
            }
            if (!this.exchange.getResponseHeaders().contains(Headers.TRANSFER_ENCODING)) {
                this.exchange.getResponseHeaders().put(Headers.CONTENT_LENGTH, Integer.toString(remaining));
            }
        } else {
            this.exchange.getResponseHeaders().remove(Headers.CONTENT_LENGTH);
        }
        return this.conduitFactory.create();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deflateData(boolean force) throws IOException {
        boolean nextCreated = false;
        try {
            PooledByteBuffer pooled = this.currentBuffer;
            ByteBuffer outputBuffer = pooled.getBuffer();
            boolean shutdown = Bits.anyAreSet(this.state, 1);
            while (force || !this.deflater.needsInput() || shutdown && !this.deflater.finished()) {
                int count = this.deflater.deflate(outputBuffer, force ? 2 : 0);
                if (count != 0) {
                    Connectors.updateResponseBytesSent(this.exchange, count);
                    if (outputBuffer.hasRemaining()) continue;
                    outputBuffer.flip();
                    this.state |= 4;
                    if (this.next == null) {
                        nextCreated = true;
                        this.next = this.createNextChannel();
                    }
                    if (this.performFlushIfRequired()) continue;
                    return;
                }
                force = false;
            }
        }
        finally {
            if (nextCreated && Bits.anyAreSet(this.state, 8)) {
                this.next.resumeWrites();
            }
        }
    }

    @Override
    public void truncateWrites() throws IOException {
        this.freeBuffer();
        this.state |= 0x10;
        this.next.truncateWrites();
    }

    private void freeBuffer() {
        if (this.currentBuffer != null) {
            this.currentBuffer.close();
            this.currentBuffer = null;
            this.state &= 0xFFFFFFFB;
        }
        if (this.deflater != null) {
            this.deflater = null;
            this.pooledObject.close();
        }
        this.trailerBuffer = null;
    }
}

