/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.conduits;

import io.undertow.UndertowMessages;
import io.undertow.util.Attachable;
import io.undertow.util.AttachmentKey;
import io.undertow.util.HeaderMap;
import io.undertow.util.HttpString;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.xnio.Bits;
import org.xnio.conduits.Conduit;

class ChunkReader<T extends Conduit> {
    private static final long FLAG_FINISHED = 0x4000000000000000L;
    private static final long FLAG_READING_LENGTH = 0x2000000000000000L;
    private static final long FLAG_READING_TILL_END_OF_LINE = 0x1000000000000000L;
    private static final long FLAG_READING_NEWLINE = 0x800000000000000L;
    private static final long FLAG_READING_AFTER_LAST = 0x400000000000000L;
    private static final long MASK_COUNT = Bits.longBitMask(0, 56);
    private static final long LIMIT = 0x7FFFFFFFFFFFFFFL;
    private long state;
    private final Attachable attachable;
    private final AttachmentKey<HeaderMap> trailerAttachmentKey;
    private TrailerParser trailerParser;
    private final T conduit;

    ChunkReader(Attachable attachable, AttachmentKey<HeaderMap> trailerAttachmentKey, T conduit) {
        this.attachable = attachable;
        this.trailerAttachmentKey = trailerAttachmentKey;
        this.conduit = conduit;
        this.state = 0x2000000000000000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long readChunk(ByteBuffer buf) throws IOException {
        long oldVal = this.state;
        long chunkRemaining = this.state & MASK_COUNT;
        if (chunkRemaining > 0L && !Bits.anyAreSet(this.state, 0x3C00000000000000L)) {
            return chunkRemaining;
        }
        long newVal = oldVal & (MASK_COUNT ^ 0xFFFFFFFFFFFFFFFFL);
        try {
            byte b22;
            if (Bits.anyAreSet(oldVal, 0x400000000000000L)) {
                int ret = this.handleChunkedRequestEnd(buf);
                if (ret == -1) {
                    newVal |= 0x4000000000000000L;
                    long l2 = -1L;
                    return l2;
                }
                long l3 = 0L;
                return l3;
            }
            while (Bits.anyAreSet(newVal, 0x800000000000000L)) {
                while (buf.hasRemaining()) {
                    b22 = buf.get();
                    if (b22 != 10) continue;
                    newVal = newVal & 0xF7FFFFFFFFFFFFFFL | 0x2000000000000000L;
                    break;
                }
                if (!Bits.anyAreSet(newVal, 0x800000000000000L)) continue;
                long b22 = 0L;
                return b22;
            }
            while (Bits.anyAreSet(newVal, 0x2000000000000000L)) {
                while (buf.hasRemaining()) {
                    b22 = buf.get();
                    if (b22 >= 48 && b22 <= 57 || b22 >= 97 && b22 <= 102 || b22 >= 65 && b22 <= 70) {
                        if (chunkRemaining > 0x7FFFFFFFFFFFFFFL) {
                            throw UndertowMessages.MESSAGES.chunkSizeTooLarge();
                        }
                        chunkRemaining <<= 4;
                        chunkRemaining += (long)Character.digit((char)b22, 16);
                        continue;
                    }
                    if (b22 == 10) {
                        newVal &= 0xDFFFFFFFFFFFFFFFL;
                        break;
                    }
                    newVal = newVal & 0xDFFFFFFFFFFFFFFFL | 0x1000000000000000L;
                    break;
                }
                if (!Bits.anyAreSet(newVal, 0x2000000000000000L)) continue;
                long b3 = 0L;
                return b3;
            }
            while (Bits.anyAreSet(newVal, 0x1000000000000000L)) {
                while (buf.hasRemaining()) {
                    if (buf.get() != 10) continue;
                    newVal &= 0xEFFFFFFFFFFFFFFFL;
                    break;
                }
                if (!Bits.anyAreSet(newVal, 0x1000000000000000L)) continue;
                long b3 = 0L;
                return b3;
            }
            if (Bits.allAreClear(newVal, 0x3800000000000000L) && chunkRemaining == 0L) {
                newVal |= 0x400000000000000L;
                int ret = this.handleChunkedRequestEnd(buf);
                if (ret == -1) {
                    newVal |= 0x4000000000000000L;
                    long l4 = -1L;
                    return l4;
                }
                long l5 = 0L;
                return l5;
            }
            long l6 = chunkRemaining;
            return l6;
        }
        finally {
            this.state = newVal | chunkRemaining;
        }
    }

    public long getChunkRemaining() {
        if (Bits.anyAreSet(this.state, 0x4000000000000000L)) {
            return -1L;
        }
        if (Bits.anyAreSet(this.state, 0x3C00000000000000L)) {
            return 0L;
        }
        return this.state & MASK_COUNT;
    }

    public void setChunkRemaining(long remaining) {
        if (remaining < 0L || Bits.anyAreSet(this.state, 0x3C00000000000000L)) {
            return;
        }
        long old = this.state;
        long oldRemaining = old & MASK_COUNT;
        if (remaining == 0L && oldRemaining != 0L) {
            old |= 0x800000000000000L;
        }
        this.state = old & (MASK_COUNT ^ 0xFFFFFFFFFFFFFFFFL) | remaining;
    }

    private int handleChunkedRequestEnd(ByteBuffer buffer) throws IOException {
        if (this.trailerParser != null) {
            return this.trailerParser.handle(buffer);
        }
        while (buffer.hasRemaining()) {
            byte b2 = buffer.get();
            if (b2 == 10) {
                return -1;
            }
            if (b2 == 13) continue;
            buffer.position(buffer.position() - 1);
            this.trailerParser = new TrailerParser();
            return this.trailerParser.handle(buffer);
        }
        return 0;
    }

    private final class TrailerParser {
        private HeaderMap headerMap = new HeaderMap();
        private StringBuilder builder = new StringBuilder();
        private HttpString httpString;
        int state = 0;
        private static final int STATE_TRAILER_NAME = 0;
        private static final int STATE_TRAILER_VALUE = 1;
        private static final int STATE_ENDING = 2;

        private TrailerParser() {
        }

        public int handle(ByteBuffer buf) throws IOException {
            while (buf.hasRemaining()) {
                byte b2 = buf.get();
                if (this.state == 0) {
                    if (b2 == 13) {
                        if (this.builder.length() == 0) {
                            this.state = 2;
                            continue;
                        }
                        throw UndertowMessages.MESSAGES.couldNotDecodeTrailers();
                    }
                    if (b2 == 10) {
                        if (this.builder.length() == 0) {
                            ChunkReader.this.attachable.putAttachment(ChunkReader.this.trailerAttachmentKey, this.headerMap);
                            return -1;
                        }
                        throw UndertowMessages.MESSAGES.couldNotDecodeTrailers();
                    }
                    if (b2 == 58) {
                        this.httpString = HttpString.tryFromString(this.builder.toString().trim());
                        this.state = 1;
                        this.builder.setLength(0);
                        continue;
                    }
                    this.builder.append((char)b2);
                    continue;
                }
                if (this.state == 1) {
                    if (b2 == 10) {
                        this.headerMap.put(this.httpString, this.builder.toString().trim());
                        this.httpString = null;
                        this.builder.setLength(0);
                        this.state = 0;
                        continue;
                    }
                    if (b2 == 13) continue;
                    this.builder.append((char)b2);
                    continue;
                }
                if (this.state == 2) {
                    if (b2 == 10) {
                        if (ChunkReader.this.attachable != null) {
                            ChunkReader.this.attachable.putAttachment(ChunkReader.this.trailerAttachmentKey, this.headerMap);
                        }
                        return -1;
                    }
                    throw UndertowMessages.MESSAGES.couldNotDecodeTrailers();
                }
                throw new IllegalStateException();
            }
            return 0;
        }
    }
}

