/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.conduits;

import io.undertow.conduits.ByteActivityCallback;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.xnio.channels.StreamSourceChannel;
import org.xnio.conduits.AbstractStreamSinkConduit;
import org.xnio.conduits.StreamSinkConduit;

public class BytesSentStreamSinkConduit
extends AbstractStreamSinkConduit<StreamSinkConduit> {
    private final ByteActivityCallback callback;

    public BytesSentStreamSinkConduit(StreamSinkConduit next, ByteActivityCallback callback) {
        super(next);
        this.callback = callback;
    }

    @Override
    public long transferFrom(FileChannel src, long position, long count) throws IOException {
        long l2 = ((StreamSinkConduit)this.next).transferFrom(src, position, count);
        if (l2 > 0L) {
            this.callback.activity(l2);
        }
        return l2;
    }

    @Override
    public long transferFrom(StreamSourceChannel source, long count, ByteBuffer throughBuffer) throws IOException {
        long l2 = ((StreamSinkConduit)this.next).transferFrom(source, count, throughBuffer);
        if (l2 > 0L) {
            this.callback.activity(l2);
        }
        return l2;
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        int i2 = ((StreamSinkConduit)this.next).write(src);
        if (i2 > 0) {
            this.callback.activity(i2);
        }
        return i2;
    }

    @Override
    public long write(ByteBuffer[] srcs, int offs, int len) throws IOException {
        long l2 = ((StreamSinkConduit)this.next).write(srcs, offs, len);
        if (l2 > 0L) {
            this.callback.activity(l2);
        }
        return l2;
    }

    @Override
    public int writeFinal(ByteBuffer src) throws IOException {
        int i2 = ((StreamSinkConduit)this.next).writeFinal(src);
        if (i2 > 0) {
            this.callback.activity(i2);
        }
        return i2;
    }

    @Override
    public long writeFinal(ByteBuffer[] srcs, int offset, int length) throws IOException {
        long l2 = ((StreamSinkConduit)this.next).writeFinal(srcs, offset, length);
        if (l2 > 0L) {
            this.callback.activity(l2);
        }
        return l2;
    }
}

