/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.attribute;

import io.undertow.UndertowLogger;
import io.undertow.UndertowMessages;
import io.undertow.attribute.CompositeExchangeAttribute;
import io.undertow.attribute.ConstantExchangeAttribute;
import io.undertow.attribute.ExchangeAttribute;
import io.undertow.attribute.ExchangeAttributeBuilder;
import io.undertow.attribute.ExchangeAttributeWrapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ServiceLoader;

public class ExchangeAttributeParser {
    private final List<ExchangeAttributeBuilder> builders;
    private final List<ExchangeAttributeWrapper> wrappers;

    ExchangeAttributeParser(ClassLoader classLoader, List<ExchangeAttributeWrapper> wrappers) {
        this.wrappers = wrappers;
        ServiceLoader<ExchangeAttributeBuilder> loader = ServiceLoader.load(ExchangeAttributeBuilder.class, classLoader);
        ArrayList<ExchangeAttributeBuilder> builders = new ArrayList<ExchangeAttributeBuilder>();
        for (ExchangeAttributeBuilder instance : loader) {
            builders.add(instance);
        }
        Collections.sort(builders, new Comparator<ExchangeAttributeBuilder>(){

            @Override
            public int compare(ExchangeAttributeBuilder o1, ExchangeAttributeBuilder o2) {
                return Integer.compare(o2.priority(), o1.priority());
            }
        });
        this.builders = Collections.unmodifiableList(builders);
    }

    public ExchangeAttribute parse(String valueString) {
        ArrayList<ExchangeAttribute> attributes = new ArrayList<ExchangeAttribute>();
        int pos = 0;
        int state = 0;
        block11: for (int i2 = 0; i2 < valueString.length(); ++i2) {
            char c2 = valueString.charAt(i2);
            switch (state) {
                case 0: {
                    if (c2 != '%' && c2 != '$') continue block11;
                    if (pos != i2) {
                        attributes.add(this.wrap(this.parseSingleToken(valueString.substring(pos, i2))));
                        pos = i2;
                    }
                    if (c2 == '%') {
                        state = 1;
                        continue block11;
                    }
                    state = 3;
                    continue block11;
                }
                case 1: {
                    if (c2 == '{') {
                        state = 2;
                        continue block11;
                    }
                    if (c2 == '%') {
                        attributes.add(this.wrap(new ConstantExchangeAttribute("%")));
                        pos = i2 + 1;
                        state = 0;
                        continue block11;
                    }
                    attributes.add(this.wrap(this.parseSingleToken(valueString.substring(pos, i2 + 1))));
                    pos = i2 + 1;
                    state = 0;
                    continue block11;
                }
                case 2: {
                    if (c2 != '}') continue block11;
                    attributes.add(this.wrap(this.parseSingleToken(valueString.substring(pos, i2 + 1))));
                    pos = i2 + 1;
                    state = 0;
                    continue block11;
                }
                case 3: {
                    if (c2 == '{') {
                        state = 4;
                        continue block11;
                    }
                    if (c2 == '$') {
                        attributes.add(this.wrap(new ConstantExchangeAttribute("$")));
                        pos = i2 + 1;
                        state = 0;
                        continue block11;
                    }
                    attributes.add(this.wrap(this.parseSingleToken(valueString.substring(pos, i2 + 1))));
                    pos = i2 + 1;
                    state = 0;
                    continue block11;
                }
                case 4: {
                    if (c2 != '}') continue block11;
                    attributes.add(this.wrap(this.parseSingleToken(valueString.substring(pos, i2 + 1))));
                    pos = i2 + 1;
                    state = 0;
                }
            }
        }
        switch (state) {
            case 0: 
            case 1: 
            case 3: {
                if (pos == valueString.length()) break;
                attributes.add(this.wrap(this.parseSingleToken(valueString.substring(pos))));
                break;
            }
            case 2: 
            case 4: {
                throw UndertowMessages.MESSAGES.mismatchedBraces(valueString);
            }
        }
        if (attributes.size() == 1) {
            return (ExchangeAttribute)attributes.get(0);
        }
        return new CompositeExchangeAttribute(attributes.toArray(new ExchangeAttribute[attributes.size()]));
    }

    public ExchangeAttribute parseSingleToken(String token) {
        for (ExchangeAttributeBuilder builder : this.builders) {
            ExchangeAttribute res = builder.build(token);
            if (res == null) continue;
            return res;
        }
        if (token.startsWith("%")) {
            UndertowLogger.ROOT_LOGGER.unknownVariable(token);
        }
        return new ConstantExchangeAttribute(token);
    }

    private ExchangeAttribute wrap(ExchangeAttribute attribute) {
        ExchangeAttribute res = attribute;
        for (ExchangeAttributeWrapper w2 : this.wrappers) {
            res = w2.wrap(res);
        }
        return res;
    }
}

