#!/bin/bash

schema_ohyd=ohyd
schema_pegeldaten=pegeldaten

liquibase_properties="
liquibase.command.url: $MARLIN_PEGELDATEN_DB_URL
liquibase.command.username: $MARLIN_PEGELDATEN_DB_USER
liquibase.command.password: $MARLIN_PEGELDATEN_DB_PASSWORD

ohyd: $schema_ohyd
pegeldaten: $schema_pegeldaten
"

echo "$liquibase_properties" > liquibase.properties

liquibase --changeLogFile=schemas.xml \
          update

liquibase --changeLogFile=ohyd/all.xml \
          --liquibase-schema-name=${schema_ohyd} \
          --defaultSchemaName=${schema_ohyd} \
          update

liquibase --changeLogFile=pegeldaten/all.xml \
          --liquibase-schema-name=${schema_pegeldaten} \
          --defaultSchemaName=${schema_pegeldaten} \
          --contexts=${MARLIN_PROFILE:-lung} \
          update
