require "singleton"
class BerechtigungsCache
  include Singleton

  USER_ZU_ROLLEN_UND_RECHTE = {}
  USER_ZU_NAME = {}
  USER_ZU_ORGA = {}

  def clear()
    USER_ZU_ROLLEN_UND_RECHTE.clear
    USER_ZU_NAME.clear
    USER_ZU_ORGA.clear
  end

  def alle_rollen_und_berechtigungen(user)
    unless USER_ZU_ROLLEN_UND_RECHTE.key?(user.id)
      USER_ZU_ROLLEN_UND_RECHTE[user.id] = user.lade_rollen_und_berechtigungen
    end
    USER_ZU_ROLLEN_UND_RECHTE[user.id]
  end

  def name(user_id)
    unless USER_ZU_NAME.key?(user_id)
      USER_ZU_NAME[user_id] = User.where(id: user_id).first.full_name
    end
    USER_ZU_NAME[user_id]
  end

  def organisationseinheit(user_id)
    unless USER_ZU_ORGA.key?(user_id)
      USER_ZU_ORGA[user_id] = User.where(id: user_id).first.organisationseinheiten_string
    end
    USER_ZU_ORGA[user_id]
  end

end