/*
 * Decompiled with CFR 0.152.
 */
package tech.units.indriya.unit;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.measure.Dimension;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import javax.measure.quantity.Dimensionless;
import tech.units.indriya.AbstractUnit;
import tech.units.indriya.function.AbstractConverter;
import tech.units.indriya.unit.UnitDimension;

public final class ProductUnit<Q extends Quantity<Q>>
extends AbstractUnit<Q> {
    private static final long serialVersionUID = 962983585531030093L;
    private final Element[] elements;

    public ProductUnit() {
        super("");
        this.elements = new Element[0];
    }

    public ProductUnit(Unit<?> productUnit) {
        super(productUnit.getSymbol());
        this.elements = ((ProductUnit)productUnit).elements;
    }

    private ProductUnit(Element[] elements) {
        super(null);
        this.elements = elements;
    }

    public static Unit<?> ofProduct(Unit<?> left, Unit<?> right) {
        Element[] leftElems = left instanceof ProductUnit ? ((ProductUnit)left).elements : new Element[]{new Element(left, 1, 1)};
        Element[] rightElems = right instanceof ProductUnit ? ((ProductUnit)right).elements : new Element[]{new Element(right, 1, 1)};
        return ProductUnit.getInstance(leftElems, rightElems);
    }

    public static Unit<?> ofQuotient(Unit<?> left, Unit<?> right) {
        Element[] rightElems;
        Element[] leftElems = left instanceof ProductUnit ? ((ProductUnit)left).elements : new Element[]{new Element(left, 1, 1)};
        if (right instanceof ProductUnit) {
            Element[] elems = ((ProductUnit)right).elements;
            rightElems = new Element[elems.length];
            for (int i2 = 0; i2 < elems.length; ++i2) {
                rightElems[i2] = new Element(elems[i2].unit, -elems[i2].pow, elems[i2].root);
            }
        } else {
            rightElems = new Element[]{new Element(right, -1, 1)};
        }
        return ProductUnit.getInstance(leftElems, rightElems);
    }

    public static Unit<?> ofRoot(Unit<?> unit, int n2) {
        Element[] unitElems;
        if (unit instanceof ProductUnit) {
            Element[] elems = ((ProductUnit)unit).elements;
            unitElems = new Element[elems.length];
            for (int i2 = 0; i2 < elems.length; ++i2) {
                int gcd = ProductUnit.gcd(Math.abs(elems[i2].pow), elems[i2].root * n2);
                unitElems[i2] = new Element(elems[i2].unit, elems[i2].pow / gcd, elems[i2].root * n2 / gcd);
            }
        } else {
            unitElems = new Element[]{new Element(unit, 1, n2)};
        }
        return ProductUnit.getInstance(unitElems, new Element[0]);
    }

    public static Unit<?> ofPow(Unit<?> unit, int n2) {
        Element[] unitElems;
        if (unit instanceof ProductUnit) {
            Element[] elems = ((ProductUnit)unit).elements;
            unitElems = new Element[elems.length];
            for (int i2 = 0; i2 < elems.length; ++i2) {
                int gcd = ProductUnit.gcd(Math.abs(elems[i2].pow * n2), elems[i2].root);
                unitElems[i2] = new Element(elems[i2].unit, elems[i2].pow * n2 / gcd, elems[i2].root / gcd);
            }
        } else {
            unitElems = new Element[]{new Element(unit, n2, 1)};
        }
        return ProductUnit.getInstance(unitElems, new Element[0]);
    }

    @Override
    public Unit<?> pow(int n2) {
        return ProductUnit.ofPow(this, n2);
    }

    public int getUnitCount() {
        return this.elements.length;
    }

    public Unit<?> getUnit(int index) {
        return this.elements[index].getUnit();
    }

    public int getUnitPow(int index) {
        return this.elements[index].getPow();
    }

    public int getUnitRoot(int index) {
        return this.elements[index].getRoot();
    }

    @Override
    public Map<Unit<?>, Integer> getBaseUnits() {
        LinkedHashMap units = new LinkedHashMap();
        for (int i2 = 0; i2 < this.getUnitCount(); ++i2) {
            units.put(this.getUnit(i2), this.getUnitPow(i2));
        }
        return units;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ProductUnit) {
            Element[] elems = ((ProductUnit)obj).elements;
            if (this.elements.length != elems.length) {
                return false;
            }
            for (Element element : this.elements) {
                boolean unitFound = false;
                for (Element elem : elems) {
                    if (!element.unit.equals(elem.unit)) continue;
                    if (element.pow != elem.pow || element.root != elem.root) {
                        return false;
                    }
                    unitFound = true;
                    break;
                }
                if (unitFound) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        Arrays.sort(this.elements, new Comparator<Element>(){

            @Override
            public int compare(Element e0, Element e1) {
                if (e0.getUnit().getSystemUnit().getSymbol() != null && e1.getUnit().getSystemUnit().getSymbol() != null) {
                    return e0.getUnit().getSystemUnit().getSymbol().compareTo(e1.getUnit().getSystemUnit().getSymbol());
                }
                return e0.getUnit().getSystemUnit().toString().compareTo(e1.getUnit().getSystemUnit().toString());
            }
        });
        return Objects.hash(this.elements);
    }

    @Override
    public Unit<Q> toSystemUnit() {
        Unit<Dimensionless> systemUnit = AbstractUnit.ONE;
        for (Element element : this.elements) {
            Unit<Object> unit = element.unit.getSystemUnit();
            unit = unit.pow(element.pow);
            unit = unit.root(element.root);
            systemUnit = systemUnit.multiply(unit);
        }
        return (AbstractUnit)systemUnit;
    }

    @Override
    public UnitConverter getSystemConverter() {
        UnitConverter converter = AbstractConverter.IDENTITY;
        for (Element e2 : this.elements) {
            if (!(e2.unit instanceof AbstractUnit)) continue;
            UnitConverter cvtr = ((AbstractUnit)e2.unit).getSystemConverter();
            if (!cvtr.isLinear()) {
                throw new UnsupportedOperationException(e2.unit + " is non-linear, cannot convert");
            }
            if (e2.root != 1) {
                throw new UnsupportedOperationException(e2.unit + " holds a base unit with fractional exponent");
            }
            int pow = e2.pow;
            if (pow < 0) {
                pow = -pow;
                cvtr = cvtr.inverse();
            }
            for (int j2 = 0; j2 < pow; ++j2) {
                converter = converter.concatenate(cvtr);
            }
        }
        return converter;
    }

    @Override
    public Dimension getDimension() {
        Dimension dimension = UnitDimension.NONE;
        for (int i2 = 0; i2 < this.getUnitCount(); ++i2) {
            Unit<?> unit = this.getUnit(i2);
            if (this.elements == null || unit.getDimension() == null) continue;
            Dimension d2 = unit.getDimension().pow(this.getUnitPow(i2)).root(this.getUnitRoot(i2));
            dimension = dimension.multiply(d2);
        }
        return dimension;
    }

    private static Unit<?> getInstance(Element[] leftElems, Element[] rightElems) {
        Unit unit;
        Element[] result = new Element[leftElems.length + rightElems.length];
        int resultIndex = 0;
        for (Element leftElem : leftElems) {
            unit = leftElem.unit;
            int p1 = leftElem.pow;
            int r1 = leftElem.root;
            int p2 = 0;
            int r2 = 1;
            for (Element rightElem : rightElems) {
                if (!unit.equals(rightElem.unit)) continue;
                p2 = rightElem.pow;
                r2 = rightElem.root;
                break;
            }
            int pow = p1 * r2 + p2 * r1;
            int root = r1 * r2;
            if (pow == 0) continue;
            int gcd = ProductUnit.gcd(Math.abs(pow), root);
            result[resultIndex++] = new Element(unit, pow / gcd, root / gcd);
        }
        for (Element rightElem : rightElems) {
            unit = rightElem.unit;
            boolean hasBeenMerged = false;
            for (Element leftElem : leftElems) {
                if (!unit.equals(leftElem.unit)) continue;
                hasBeenMerged = true;
                break;
            }
            if (hasBeenMerged) continue;
            result[resultIndex++] = rightElem;
        }
        if (resultIndex == 0) {
            return AbstractUnit.ONE;
        }
        if (resultIndex == 1 && result[0].pow == result[0].root) {
            return result[0].unit;
        }
        Element[] elems = new Element[resultIndex];
        System.arraycopy(result, 0, elems, 0, resultIndex);
        return new ProductUnit(elems);
    }

    private static int gcd(int m2, int n2) {
        return n2 == 0 ? m2 : ProductUnit.gcd(n2, m2 % n2);
    }

    private static final class Element
    implements Serializable {
        private static final long serialVersionUID = 452938412398890507L;
        private final Unit<?> unit;
        private final int pow;
        private final int root;

        private Element(Unit<?> unit, int pow, int root) {
            this.unit = unit;
            this.pow = pow;
            this.root = root;
        }

        public Unit<?> getUnit() {
            return this.unit;
        }

        public int getPow() {
            return this.pow;
        }

        public int getRoot() {
            return this.root;
        }

        public boolean equals(Object o2) {
            if (this == o2) {
                return true;
            }
            if (o2 == null || this.getClass() != o2.getClass()) {
                return false;
            }
            Element element = (Element)o2;
            if (this.pow != element.pow) {
                return false;
            }
            return this.root == element.root && this.unit != null ? this.unit.equals(element.unit) : element.unit == null;
        }

        public int hashCode() {
            return Objects.hash(this.unit, this.pow, this.root);
        }
    }
}

