/*
 * Decompiled with CFR 0.152.
 */
package tech.units.indriya.format;

import java.io.IOException;
import java.text.FieldPosition;
import java.text.ParsePosition;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.measure.BinaryPrefix;
import javax.measure.MetricPrefix;
import javax.measure.Prefix;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import javax.measure.format.MeasurementParseException;
import javax.measure.quantity.Dimensionless;
import tech.units.indriya.AbstractUnit;
import tech.units.indriya.format.AbstractUnitFormat;
import tech.units.indriya.format.SymbolMap;
import tech.units.indriya.function.AddConverter;
import tech.units.indriya.function.MultiplyConverter;
import tech.units.indriya.function.RationalNumber;
import tech.units.indriya.unit.AlternateUnit;
import tech.units.indriya.unit.AnnotatedUnit;
import tech.units.indriya.unit.BaseUnit;
import tech.units.indriya.unit.ProductUnit;
import tech.units.indriya.unit.TransformedUnit;
import tech.units.indriya.unit.Units;

public abstract class SimpleUnitFormat
extends AbstractUnitFormat {
    private static final Unit<?>[] METRIC_UNITS;
    private static final String[] METRIC_PREFIX_SYMBOLS;
    private static final UnitConverter[] METRIC_PREFIX_CONVERTERS;
    private static final String[] BINARY_PREFIX_SYMBOLS;
    private static final UnitConverter[] BINARY_PREFIX_CONVERTERS;
    private static final String MU = "\u03bc";
    private static final DefaultFormat DEFAULT;
    private static final ASCIIFormat ASCII;
    private static final Map<String, Unit<?>> SYMBOL_TO_UNIT;

    public static SimpleUnitFormat getInstance() {
        return SimpleUnitFormat.getInstance(Flavor.Default);
    }

    public static SimpleUnitFormat getInstance(Flavor flavor) {
        switch (flavor) {
            case ASCII: {
                return ASCII;
            }
        }
        return DEFAULT;
    }

    protected SimpleUnitFormat() {
    }

    @Override
    public abstract Appendable format(Unit<?> var1, Appendable var2) throws IOException;

    public abstract Unit<? extends Quantity> parseProductUnit(CharSequence var1, ParsePosition var2) throws MeasurementParseException;

    public abstract Unit<? extends Quantity> parseSingleUnit(CharSequence var1, ParsePosition var2) throws MeasurementParseException;

    @Override
    public abstract void label(Unit<?> var1, String var2);

    public abstract void alias(Unit<?> var1, String var2);

    protected abstract boolean isValidIdentifier(String var1);

    public final StringBuffer format(Object unit, final StringBuffer toAppendTo, FieldPosition pos) {
        try {
            StringBuffer dest = toAppendTo;
            if (dest instanceof Appendable) {
                this.format((Unit)unit, dest);
            } else {
                this.format((Unit)unit, new Appendable(){

                    @Override
                    public Appendable append(char arg0) throws IOException {
                        toAppendTo.append(arg0);
                        return null;
                    }

                    @Override
                    public Appendable append(CharSequence arg0) throws IOException {
                        toAppendTo.append(arg0);
                        return null;
                    }

                    @Override
                    public Appendable append(CharSequence arg0, int arg1, int arg2) throws IOException {
                        toAppendTo.append(arg0.subSequence(arg1, arg2));
                        return null;
                    }
                });
            }
            return toAppendTo;
        }
        catch (IOException e2) {
            throw new Error(e2);
        }
    }

    public final Unit<?> parseObject(String source, ParsePosition pos) throws MeasurementParseException {
        return this.parseProductUnit(source, pos);
    }

    private static String asciiPrefix(String prefix) {
        return "\u00b5".equals(prefix) ? "micro" : prefix;
    }

    private static String asciiSymbol(String s2) {
        return "\u03a9".equals(s2) ? "Ohm" : s2;
    }

    protected static boolean isAllASCII(String input) {
        boolean isASCII = true;
        for (int i2 = 0; i2 < input.length(); ++i2) {
            char c2 = input.charAt(i2);
            if (c2 <= '\u007f') continue;
            isASCII = false;
            break;
        }
        return isASCII;
    }

    static {
        int i2;
        METRIC_UNITS = new Unit[]{Units.AMPERE, Units.BECQUEREL, Units.CANDELA, Units.COULOMB, Units.FARAD, Units.GRAY, Units.HENRY, Units.HERTZ, Units.JOULE, Units.KATAL, Units.KELVIN, Units.LUMEN, Units.LUX, Units.METRE, Units.MOLE, Units.NEWTON, Units.OHM, Units.PASCAL, Units.RADIAN, Units.SECOND, Units.SIEMENS, Units.SIEVERT, Units.STERADIAN, Units.TESLA, Units.VOLT, Units.WATT, Units.WEBER};
        METRIC_PREFIX_SYMBOLS = Stream.of(MetricPrefix.values()).map(Prefix::getSymbol).collect(Collectors.toList()).toArray(new String[0]);
        METRIC_PREFIX_CONVERTERS = Stream.of(MetricPrefix.values()).map(MultiplyConverter::ofPrefix).collect(Collectors.toList()).toArray(new UnitConverter[0]);
        BINARY_PREFIX_SYMBOLS = Stream.of(BinaryPrefix.values()).map(Prefix::getSymbol).collect(Collectors.toList()).toArray(new String[0]);
        BINARY_PREFIX_CONVERTERS = Stream.of(BinaryPrefix.values()).map(MultiplyConverter::ofPrefix).collect(Collectors.toList()).toArray(new UnitConverter[0]);
        DEFAULT = new DefaultFormat();
        ASCII = new ASCIIFormat();
        SYMBOL_TO_UNIT = new HashMap();
        for (int i3 = 0; i3 < METRIC_UNITS.length; ++i3) {
            Unit<?> si = METRIC_UNITS[i3];
            String symbol = si instanceof BaseUnit ? ((BaseUnit)si).getSymbol() : ((AlternateUnit)si).getSymbol();
            DEFAULT.label(si, symbol);
            if (SimpleUnitFormat.isAllASCII(symbol)) {
                ASCII.label(si, symbol);
            }
            for (int j2 = 0; j2 < METRIC_PREFIX_SYMBOLS.length; ++j2) {
                Unit<?> u2 = si.prefix(MetricPrefix.values()[j2]);
                DEFAULT.label(u2, METRIC_PREFIX_SYMBOLS[j2] + symbol);
                if (!"\u00b5".equals(METRIC_PREFIX_SYMBOLS[j2])) continue;
                DEFAULT.label(u2, MU + symbol);
                ASCII.label(u2, "micro" + SimpleUnitFormat.asciiSymbol(symbol));
            }
        }
        ASCII.label(Units.GRAM, "g");
        DEFAULT.label(Units.GRAM, "g");
        block6: for (MetricPrefix prefix : MetricPrefix.values()) {
            switch (prefix) {
                case KILO: {
                    DEFAULT.label(Units.KILOGRAM, "kg");
                    ASCII.label(Units.KILOGRAM, "kg");
                    continue block6;
                }
                case MICRO: {
                    DEFAULT.label(Units.GRAM.prefix(prefix), prefix.getSymbol() + "g");
                    ASCII.label(MetricPrefix.MICRO(Units.LITRE), "microg");
                    continue block6;
                }
                default: {
                    ASCII.label(Units.GRAM.prefix(prefix), prefix.getSymbol() + "g");
                    DEFAULT.label(Units.GRAM.prefix(prefix), prefix.getSymbol() + "g");
                }
            }
        }
        DEFAULT.label(MetricPrefix.MICRO(Units.GRAM), MetricPrefix.MICRO.getSymbol() + "g");
        SYMBOL_TO_UNIT.put(MetricPrefix.MICRO.getSymbol() + "g", MetricPrefix.MICRO(Units.GRAM));
        SYMBOL_TO_UNIT.put("\u03bcg", MetricPrefix.MICRO(Units.GRAM));
        SYMBOL_TO_UNIT.put("\u03bcg", MetricPrefix.MICRO(Units.GRAM));
        DEFAULT.alias(Units.OHM, "Ohm");
        ASCII.label(Units.OHM, "Ohm");
        for (i2 = 0; i2 < METRIC_PREFIX_SYMBOLS.length; ++i2) {
            DEFAULT.alias(Units.OHM.prefix(MetricPrefix.values()[i2]), METRIC_PREFIX_SYMBOLS[i2] + "Ohm");
            ASCII.label(Units.OHM.prefix(MetricPrefix.values()[i2]), SimpleUnitFormat.asciiPrefix(METRIC_PREFIX_SYMBOLS[i2]) + "Ohm");
        }
        DEFAULT.label(Units.CELSIUS, "\u2103");
        DEFAULT.alias(Units.CELSIUS, "\u00b0C");
        ASCII.label(Units.CELSIUS, "Celsius");
        for (i2 = 0; i2 < METRIC_PREFIX_SYMBOLS.length; ++i2) {
            DEFAULT.label(Units.CELSIUS.prefix(MetricPrefix.values()[i2]), METRIC_PREFIX_SYMBOLS[i2] + "\u2103");
            DEFAULT.alias(Units.CELSIUS.prefix(MetricPrefix.values()[i2]), METRIC_PREFIX_SYMBOLS[i2] + "\u00b0C");
            ASCII.label(Units.CELSIUS.prefix(MetricPrefix.values()[i2]), SimpleUnitFormat.asciiPrefix(METRIC_PREFIX_SYMBOLS[i2]) + "Celsius");
        }
        DEFAULT.label(Units.PERCENT, "%");
        DEFAULT.label(Units.METRE, "m");
        ASCII.label(Units.METRE, "m");
        DEFAULT.label(Units.SECOND, "s");
        ASCII.label(Units.SECOND, "s");
        DEFAULT.label(Units.MINUTE, "min");
        DEFAULT.label(Units.HOUR, "h");
        DEFAULT.label(Units.DAY, "day");
        DEFAULT.alias(Units.DAY, "d");
        DEFAULT.label(Units.WEEK, "week");
        DEFAULT.label(Units.YEAR, "year");
        DEFAULT.alias(Units.YEAR, "days365");
        ASCII.label(Units.KILOMETRE_PER_HOUR, "km/h");
        DEFAULT.label(Units.KILOMETRE_PER_HOUR, "km/h");
        DEFAULT.label(Units.CUBIC_METRE, "\u33a5");
        ASCII.label(Units.CUBIC_METRE, "m3");
        ASCII.label(Units.LITRE, "l");
        DEFAULT.label(Units.LITRE, "l");
        for (MetricPrefix prefix : MetricPrefix.values()) {
            if (prefix == MetricPrefix.MICRO) {
                ASCII.label(MetricPrefix.MICRO(Units.LITRE), "microL");
            } else {
                ASCII.label(Units.LITRE.prefix(prefix), prefix.getSymbol() + "L");
            }
            DEFAULT.label(Units.LITRE.prefix(prefix), prefix.getSymbol() + "l");
        }
        DEFAULT.label(Units.NEWTON, "N");
        ASCII.label(Units.NEWTON, "N");
        DEFAULT.label(Units.RADIAN, "rad");
        ASCII.label(Units.RADIAN, "rad");
        DEFAULT.label(AbstractUnit.ONE, "one");
        ASCII.label(AbstractUnit.ONE, "one");
    }

    protected static final class ASCIIFormat
    extends DefaultFormat {
        protected ASCIIFormat() {
        }

        @Override
        protected String nameFor(Unit<?> unit) {
            String name = (String)this.unitToName.get(unit);
            if (name != null) {
                return name;
            }
            return DEFAULT.nameFor(unit);
        }

        @Override
        protected Unit<?> unitFor(String name) {
            Unit unit = (Unit)this.nameToUnit.get(name);
            if (unit != null) {
                return unit;
            }
            return DEFAULT.unitFor(name);
        }

        @Override
        public String toString() {
            return "SimpleUnitFormat - ASCII";
        }

        @Override
        public Appendable format(Unit<?> unit, Appendable appendable) throws IOException {
            String name = this.nameFor(unit);
            if (name != null) {
                return appendable.append(name);
            }
            if (!(unit instanceof ProductUnit)) {
                throw new IllegalArgumentException("Cannot format given Object as a Unit");
            }
            ProductUnit productUnit = (ProductUnit)unit;
            for (int i2 = 0; i2 < productUnit.getUnitCount(); ++i2) {
                if (i2 != 0) {
                    appendable.append('*');
                }
                name = this.nameFor(productUnit.getUnit(i2));
                int pow = productUnit.getUnitPow(i2);
                int root = productUnit.getUnitRoot(i2);
                appendable.append(name);
                if (pow == 1 && root == 1) continue;
                appendable.append('^');
                appendable.append(String.valueOf(pow));
                if (root == 1) continue;
                appendable.append(':');
                appendable.append(String.valueOf(root));
            }
            return appendable;
        }

        @Override
        protected boolean isValidIdentifier(String name) {
            if (name == null || name.length() == 0) {
                return false;
            }
            return ASCIIFormat.isUnitIdentifierPart(name.charAt(0)) && ASCIIFormat.isAllASCII(name);
        }
    }

    protected static class DefaultFormat
    extends SimpleUnitFormat {
        protected final HashMap<String, Unit<?>> nameToUnit = new HashMap();
        protected final HashMap<Unit<?>, String> unitToName = new HashMap();

        protected DefaultFormat() {
        }

        public String toString() {
            return "SimpleUnitFormat";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void label(Unit<?> unit, String label) {
            if (!this.isValidIdentifier(label)) {
                throw new IllegalArgumentException("Label: " + label + " is not a valid identifier.");
            }
            DefaultFormat defaultFormat = this;
            synchronized (defaultFormat) {
                this.nameToUnit.put(label, unit);
                this.unitToName.put(unit, label);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void alias(Unit<?> unit, String alias) {
            if (!this.isValidIdentifier(alias)) {
                throw new IllegalArgumentException("Alias: " + alias + " is not a valid identifier.");
            }
            DefaultFormat defaultFormat = this;
            synchronized (defaultFormat) {
                this.nameToUnit.put(alias, unit);
            }
        }

        @Override
        protected boolean isValidIdentifier(String name) {
            if (name == null || name.length() == 0) {
                return false;
            }
            return DefaultFormat.isUnitIdentifierPart(name.charAt(0));
        }

        protected static boolean isUnitIdentifierPart(char ch) {
            return Character.isLetter(ch) || !Character.isWhitespace(ch) && !Character.isDigit(ch) && ch != '\u00b7' && ch != '*' && ch != '/' && ch != '(' && ch != ')' && ch != '[' && ch != ']' && ch != '\u00b9' && ch != '\u00b2' && ch != '\u00b3' && ch != '^' && ch != '+' && ch != '-';
        }

        protected String nameFor(Unit<?> unit) {
            String label = this.unitToName.get(unit);
            if (label != null) {
                return label;
            }
            if (unit instanceof BaseUnit) {
                return ((BaseUnit)unit).getSymbol();
            }
            if (unit instanceof AlternateUnit) {
                return ((AlternateUnit)unit).getSymbol();
            }
            if (unit instanceof TransformedUnit) {
                TransformedUnit tfmUnit = (TransformedUnit)unit;
                if (tfmUnit.getSymbol() != null) {
                    return tfmUnit.getSymbol();
                }
                Unit baseUnit = tfmUnit.getParentUnit();
                UnitConverter cvtr = tfmUnit.getConverter();
                StringBuilder result = new StringBuilder();
                String baseUnitName = baseUnit.toString();
                String prefix = this.prefixFor(cvtr);
                if (baseUnitName.indexOf(183) >= 0 || baseUnitName.indexOf(42) >= 0 || baseUnitName.indexOf(47) >= 0) {
                    result.append('(');
                    result.append(baseUnitName);
                    result.append(')');
                } else {
                    result.append(baseUnitName);
                }
                if (prefix != null) {
                    result.insert(0, prefix);
                } else if (cvtr instanceof AddConverter) {
                    result.append('+');
                    result.append(((AddConverter)cvtr).getOffset());
                } else if (cvtr instanceof MultiplyConverter) {
                    Number scaleFactor = ((MultiplyConverter)cvtr).getFactor();
                    if (scaleFactor instanceof RationalNumber) {
                        RationalNumber rational = (RationalNumber)scaleFactor;
                        RationalNumber reciprocal = rational.reciprocal();
                        if (reciprocal.isInteger()) {
                            result.append('/');
                            result.append(reciprocal.toString());
                        } else {
                            result.append('*');
                            result.append(scaleFactor);
                        }
                    } else {
                        result.append('*');
                        result.append(scaleFactor);
                    }
                } else {
                    return "[" + baseUnit + "?]";
                }
                return result.toString();
            }
            if (unit instanceof AnnotatedUnit) {
                AnnotatedUnit annotatedUnit = (AnnotatedUnit)unit;
                StringBuilder annotable = new StringBuilder(this.nameFor(annotatedUnit.getActualUnit()));
                if (annotatedUnit.getAnnotation() != null) {
                    annotable.append('{');
                    annotable.append(annotatedUnit.getAnnotation());
                    annotable.append('}');
                }
                return annotable.toString();
            }
            return null;
        }

        protected String prefixFor(UnitConverter converter) {
            for (int i2 = 0; i2 < METRIC_PREFIX_CONVERTERS.length; ++i2) {
                if (!METRIC_PREFIX_CONVERTERS[i2].equals(converter)) continue;
                return METRIC_PREFIX_SYMBOLS[i2];
            }
            for (int j2 = 0; j2 < BINARY_PREFIX_CONVERTERS.length; ++j2) {
                if (!BINARY_PREFIX_CONVERTERS[j2].equals(converter)) continue;
                return BINARY_PREFIX_SYMBOLS[j2];
            }
            return null;
        }

        protected Unit<?> unitFor(String name) {
            Unit unit = this.nameToUnit.get(name);
            if (unit != null) {
                return unit;
            }
            unit = (Unit)SYMBOL_TO_UNIT.get(name);
            return unit;
        }

        @Override
        public Unit<? extends Quantity> parseSingleUnit(CharSequence csq, ParsePosition pos) throws MeasurementParseException {
            int startIndex = pos.getIndex();
            String name = DefaultFormat.readIdentifier(csq, pos);
            Unit<?> unit = this.unitFor(name);
            DefaultFormat.check(unit != null, name + " not recognized", csq, startIndex);
            return unit;
        }

        @Override
        public Unit<? extends Quantity> parseProductUnit(CharSequence csq, ParsePosition pos) throws MeasurementParseException {
            Unit<Quantity<Dimensionless>> result = AbstractUnit.ONE;
            Token token = DefaultFormat.nextToken(csq, pos);
            switch (token) {
                case IDENTIFIER: {
                    result = this.parseSingleUnit(csq, pos);
                    break;
                }
                case OPEN_PAREN: {
                    pos.setIndex(pos.getIndex() + 1);
                    result = this.parseProductUnit(csq, pos);
                    token = DefaultFormat.nextToken(csq, pos);
                    DefaultFormat.check(token == Token.CLOSE_PAREN, "')' expected", csq, pos.getIndex());
                    pos.setIndex(pos.getIndex() + 1);
                    break;
                }
            }
            token = DefaultFormat.nextToken(csq, pos);
            while (true) {
                switch (token) {
                    case EXPONENT: {
                        Exponent e2 = DefaultFormat.readExponent(csq, pos);
                        if (e2.pow != 1) {
                            result = result.pow(e2.pow);
                        }
                        if (e2.root == 1) break;
                        result = result.root(e2.root);
                        break;
                    }
                    case MULTIPLY: {
                        pos.setIndex(pos.getIndex() + 1);
                        token = DefaultFormat.nextToken(csq, pos);
                        if (token == Token.INTEGER) {
                            long n2 = DefaultFormat.readLong(csq, pos);
                            if (n2 == 1L) break;
                            result = result.multiply(n2);
                            break;
                        }
                        if (token == Token.FLOAT) {
                            double d2 = DefaultFormat.readDouble(csq, pos);
                            if (d2 == 1.0) break;
                            result = result.multiply(d2);
                            break;
                        }
                        result = result.multiply(this.parseProductUnit(csq, pos));
                        break;
                    }
                    case DIVIDE: {
                        pos.setIndex(pos.getIndex() + 1);
                        token = DefaultFormat.nextToken(csq, pos);
                        if (token == Token.INTEGER) {
                            long n3 = DefaultFormat.readLong(csq, pos);
                            if (n3 == 1L) break;
                            result = result.divide(n3);
                            break;
                        }
                        if (token == Token.FLOAT) {
                            double d3 = DefaultFormat.readDouble(csq, pos);
                            if (d3 == 1.0) break;
                            result = result.divide(d3);
                            break;
                        }
                        result = result.divide(this.parseProductUnit(csq, pos));
                        break;
                    }
                    case PLUS: {
                        pos.setIndex(pos.getIndex() + 1);
                        token = DefaultFormat.nextToken(csq, pos);
                        if (token == Token.INTEGER) {
                            long n4 = DefaultFormat.readLong(csq, pos);
                            if (n4 == 1L) break;
                            result = result.shift(n4);
                            break;
                        }
                        if (token == Token.FLOAT) {
                            double d4 = DefaultFormat.readDouble(csq, pos);
                            if (d4 == 1.0) break;
                            result = result.shift(d4);
                            break;
                        }
                        throw new MeasurementParseException("not a number", csq, pos.getIndex());
                    }
                    case EOF: 
                    case CLOSE_PAREN: {
                        return result;
                    }
                    default: {
                        throw new MeasurementParseException("unexpected token " + (Object)((Object)token), csq, pos.getIndex());
                    }
                }
                token = DefaultFormat.nextToken(csq, pos);
            }
        }

        private static Token nextToken(CharSequence csq, ParsePosition pos) {
            int length = csq.length();
            while (pos.getIndex() < length) {
                char c2 = csq.charAt(pos.getIndex());
                if (DefaultFormat.isUnitIdentifierPart(c2)) {
                    return Token.IDENTIFIER;
                }
                if (c2 == '(') {
                    return Token.OPEN_PAREN;
                }
                if (c2 == ')') {
                    return Token.CLOSE_PAREN;
                }
                if (c2 == '^' || c2 == '\u00b9' || c2 == '\u00b2' || c2 == '\u00b3') {
                    return Token.EXPONENT;
                }
                if (c2 == '*') {
                    if (csq.length() == pos.getIndex() + 1) {
                        throw new MeasurementParseException("unexpected token " + (Object)((Object)Token.EOF), csq, pos.getIndex());
                    }
                    char c22 = csq.charAt(pos.getIndex() + 1);
                    return c22 == '*' ? Token.EXPONENT : Token.MULTIPLY;
                }
                if (c2 == '\u00b7') {
                    return Token.MULTIPLY;
                }
                if (c2 == '/') {
                    return Token.DIVIDE;
                }
                if (c2 == '+') {
                    return Token.PLUS;
                }
                if (c2 == '-' || Character.isDigit(c2)) {
                    int index = pos.getIndex() + 1;
                    while (index < length && (Character.isDigit(c2) || c2 == '-' || c2 == '.' || c2 == 'E')) {
                        if ((c2 = csq.charAt(index++)) != '.') continue;
                        return Token.FLOAT;
                    }
                    return Token.INTEGER;
                }
                pos.setIndex(pos.getIndex() + 1);
            }
            return Token.EOF;
        }

        private static void check(boolean expr, String message, CharSequence csq, int index) throws MeasurementParseException {
            if (!expr) {
                throw new MeasurementParseException((CharSequence)(message + " (in " + csq + " at index " + index + ")"), index);
            }
        }

        private static Exponent readExponent(CharSequence csq, ParsePosition pos) {
            char c2 = csq.charAt(pos.getIndex());
            if (c2 == '^') {
                pos.setIndex(pos.getIndex() + 1);
            } else if (c2 == '*') {
                pos.setIndex(pos.getIndex() + 2);
            }
            int length = csq.length();
            int pow = 0;
            boolean isPowNegative = false;
            boolean parseRoot = false;
            block13: while (pos.getIndex() < length) {
                c2 = csq.charAt(pos.getIndex());
                switch (c2) {
                    case '-': {
                        isPowNegative = true;
                        break;
                    }
                    case '\u00b9': {
                        pow = pow * 10 + 1;
                        break;
                    }
                    case '\u00b2': {
                        pow = pow * 10 + 2;
                        break;
                    }
                    case '\u00b3': {
                        pow = pow * 10 + 3;
                        break;
                    }
                    case ':': {
                        parseRoot = true;
                        break block13;
                    }
                    default: {
                        if (c2 < '0' || c2 > '9') break block13;
                        pow = pow * 10 + (c2 - 48);
                    }
                }
                pos.setIndex(pos.getIndex() + 1);
            }
            if (pow == 0) {
                pow = 1;
            }
            int root = 0;
            boolean isRootNegative = false;
            if (parseRoot) {
                pos.setIndex(pos.getIndex() + 1);
                block14: while (pos.getIndex() < length) {
                    c2 = csq.charAt(pos.getIndex());
                    switch (c2) {
                        case '-': {
                            isRootNegative = true;
                            break;
                        }
                        case '\u00b9': {
                            root = root * 10 + 1;
                            break;
                        }
                        case '\u00b2': {
                            root = root * 10 + 2;
                            break;
                        }
                        case '\u00b3': {
                            root = root * 10 + 3;
                            break;
                        }
                        default: {
                            if (c2 < '0' || c2 > '9') break block14;
                            root = root * 10 + (c2 - 48);
                        }
                    }
                    pos.setIndex(pos.getIndex() + 1);
                }
            }
            if (root == 0) {
                root = 1;
            }
            return new Exponent(isPowNegative ? -pow : pow, isRootNegative ? -root : root);
        }

        private static long readLong(CharSequence csq, ParsePosition pos) {
            int length = csq.length();
            int result = 0;
            boolean isNegative = false;
            while (pos.getIndex() < length) {
                char c2 = csq.charAt(pos.getIndex());
                if (c2 == '-') {
                    isNegative = true;
                } else {
                    if (c2 < '0' || c2 > '9') break;
                    result = result * 10 + (c2 - 48);
                }
                pos.setIndex(pos.getIndex() + 1);
            }
            return isNegative ? (long)(-result) : (long)result;
        }

        private static double readDouble(CharSequence csq, ParsePosition pos) {
            int end;
            int length = csq.length();
            int start = pos.getIndex();
            for (end = start + 1; end < length && "0123456789+-.E".indexOf(csq.charAt(end)) >= 0; ++end) {
            }
            pos.setIndex(end + 1);
            return Double.parseDouble(csq.subSequence(start, end).toString());
        }

        private static String readIdentifier(CharSequence csq, ParsePosition pos) {
            int start;
            int length = csq.length();
            int i2 = start = pos.getIndex();
            while (++i2 < length && DefaultFormat.isUnitIdentifierPart(csq.charAt(i2))) {
            }
            pos.setIndex(i2);
            return csq.subSequence(start, i2).toString();
        }

        @Override
        public Appendable format(Unit<?> unit, Appendable appendable) throws IOException {
            int root;
            int pow;
            int i2;
            ProductUnit powerUnit;
            String name = this.nameFor(unit);
            if (name != null) {
                return appendable.append(name);
            }
            if (!(unit instanceof ProductUnit)) {
                throw new IllegalArgumentException("Cannot format given Object as a Unit");
            }
            ProductUnit productUnit = (ProductUnit)unit;
            if (productUnit.getUnitCount() == 1 && productUnit.getUnit(0) instanceof ProductUnit && this.nameFor(powerUnit = (ProductUnit)productUnit.getUnit(0)) == null) {
                return this.format(ProductUnit.ofPow(powerUnit, productUnit.getUnitPow(0)), appendable);
            }
            int invNbr = 0;
            boolean start = true;
            for (i2 = 0; i2 < productUnit.getUnitCount(); ++i2) {
                pow = productUnit.getUnitPow(i2);
                if (pow >= 0) {
                    if (!start) {
                        appendable.append('\u00b7');
                    }
                    name = this.nameFor(productUnit.getUnit(i2));
                    root = productUnit.getUnitRoot(i2);
                    DefaultFormat.append(appendable, name, pow, root);
                    start = false;
                    continue;
                }
                ++invNbr;
            }
            if (invNbr != 0) {
                if (start) {
                    appendable.append('1');
                }
                appendable.append('/');
                if (invNbr > 1) {
                    appendable.append('(');
                }
                start = true;
                for (i2 = 0; i2 < productUnit.getUnitCount(); ++i2) {
                    pow = productUnit.getUnitPow(i2);
                    if (pow >= 0) continue;
                    name = this.nameFor(productUnit.getUnit(i2));
                    root = productUnit.getUnitRoot(i2);
                    if (!start) {
                        appendable.append('\u00b7');
                    }
                    DefaultFormat.append(appendable, name, -pow, root);
                    start = false;
                }
                if (invNbr > 1) {
                    appendable.append(')');
                }
            }
            return appendable;
        }

        private static void append(Appendable appendable, CharSequence symbol, int pow, int root) throws IOException {
            appendable.append(symbol);
            if (pow != 1 || root != 1) {
                if (pow == 2 && root == 1) {
                    appendable.append('\u00b2');
                } else if (pow == 3 && root == 1) {
                    appendable.append('\u00b3');
                } else {
                    appendable.append('^');
                    appendable.append(String.valueOf(pow));
                    if (root != 1) {
                        appendable.append(':');
                        appendable.append(String.valueOf(root));
                    }
                }
            }
        }

        @Override
        public Unit<?> parse(CharSequence csq) throws MeasurementParseException {
            return this.parse(csq, 0);
        }

        @Override
        protected SymbolMap getSymbols() {
            return null;
        }

        @Override
        protected Unit<?> parse(CharSequence csq, int index) throws IllegalArgumentException {
            return this.parse(csq, new ParsePosition(index));
        }

        @Override
        public Unit<?> parse(CharSequence csq, ParsePosition cursor) throws IllegalArgumentException {
            return this.parseObject(csq.toString(), cursor);
        }

        private static enum Token {
            EOF,
            IDENTIFIER,
            OPEN_PAREN,
            CLOSE_PAREN,
            EXPONENT,
            MULTIPLY,
            DIVIDE,
            PLUS,
            INTEGER,
            FLOAT;

        }
    }

    private static class Exponent {
        public final int pow;
        public final int root;

        public Exponent(int pow, int root) {
            this.pow = pow;
            this.root = root;
        }
    }

    public static enum Flavor {
        Default,
        ASCII;

    }
}

