/*
 * Decompiled with CFR 0.152.
 */
package org.xnio.streams;

import java.io.Flushable;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.xnio.Pooled;

public class BufferPipeOutputStream
extends OutputStream {
    private Pooled<ByteBuffer> buffer;
    private boolean closed;
    private final BufferWriter bufferWriterTask;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferPipeOutputStream(BufferWriter bufferWriterTask) throws IOException {
        this.bufferWriterTask = bufferWriterTask;
        BufferPipeOutputStream bufferPipeOutputStream = this;
        synchronized (bufferPipeOutputStream) {
            this.buffer = bufferWriterTask.getBuffer(true);
        }
    }

    private static IOException closed() {
        return new IOException("Stream is closed");
    }

    private void checkClosed() throws IOException {
        assert (Thread.holdsLock(this));
        if (this.closed) {
            throw BufferPipeOutputStream.closed();
        }
    }

    private Pooled<ByteBuffer> getBuffer() throws IOException {
        assert (Thread.holdsLock(this));
        Pooled<ByteBuffer> buffer = this.buffer;
        if (buffer != null && buffer.getResource().hasRemaining()) {
            return buffer;
        }
        if (buffer != null) {
            this.send(false);
        }
        this.buffer = this.bufferWriterTask.getBuffer(false);
        return this.buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(int b2) throws IOException {
        BufferPipeOutputStream bufferPipeOutputStream = this;
        synchronized (bufferPipeOutputStream) {
            this.checkClosed();
            this.getBuffer().getResource().put((byte)b2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(byte[] b2, int off, int len) throws IOException {
        BufferPipeOutputStream bufferPipeOutputStream = this;
        synchronized (bufferPipeOutputStream) {
            this.checkClosed();
            while (len > 0) {
                ByteBuffer buffer = this.getBuffer().getResource();
                int cnt = Math.min(len, buffer.remaining());
                buffer.put(b2, off, cnt);
                len -= cnt;
                off += cnt;
            }
        }
    }

    private void send(boolean eof) throws IOException {
        assert (Thread.holdsLock(this));
        assert (!this.closed);
        Pooled<ByteBuffer> pooledBuffer = this.buffer;
        ByteBuffer buffer = pooledBuffer == null ? null : pooledBuffer.getResource();
        this.buffer = null;
        if (buffer != null && buffer.position() > 0) {
            buffer.flip();
            this.send(pooledBuffer, eof);
        } else if (eof) {
            Pooled<ByteBuffer> pooledBuffer1 = this.getBuffer();
            ByteBuffer buffer1 = pooledBuffer1.getResource();
            buffer1.flip();
            this.send(pooledBuffer1, eof);
        }
    }

    private void send(Pooled<ByteBuffer> buffer, boolean eof) throws IOException {
        assert (Thread.holdsLock(this));
        try {
            this.bufferWriterTask.accept(buffer, eof);
        }
        catch (IOException e2) {
            this.closed = true;
            throw e2;
        }
    }

    @Override
    public void flush() throws IOException {
        this.flush(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flush(boolean eof) throws IOException {
        BufferPipeOutputStream bufferPipeOutputStream = this;
        synchronized (bufferPipeOutputStream) {
            if (this.closed) {
                return;
            }
            this.send(eof);
            try {
                this.bufferWriterTask.flush();
            }
            catch (IOException e2) {
                this.closed = true;
                this.buffer = null;
                throw e2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        BufferPipeOutputStream bufferPipeOutputStream = this;
        synchronized (bufferPipeOutputStream) {
            if (this.closed) {
                return;
            }
            try {
                this.flush(true);
            }
            finally {
                this.closed = true;
            }
        }
    }

    public Pooled<ByteBuffer> breakPipe() {
        BufferPipeOutputStream bufferPipeOutputStream = this;
        synchronized (bufferPipeOutputStream) {
            Pooled<ByteBuffer> pooled;
            if (this.closed) {
                return null;
            }
            this.closed = true;
            try {
                pooled = this.buffer;
                this.buffer = null;
            }
            catch (Throwable throwable) {
                this.buffer = null;
                throw throwable;
            }
            return pooled;
        }
    }

    public static interface BufferWriter
    extends Flushable {
        public Pooled<ByteBuffer> getBuffer(boolean var1) throws IOException;

        public void accept(Pooled<ByteBuffer> var1, boolean var2) throws IOException;

        @Override
        public void flush() throws IOException;
    }
}

