/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.common.os;

import java.io.File;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.security.PrivilegedAction;

final class GetProcessInfoAction
implements PrivilegedAction<Object[]> {
    GetProcessInfoAction() {
    }

    @Override
    public Object[] run() {
        int idx;
        RuntimeMXBean runtime;
        long pid = -1L;
        String processName = "<unknown>";
        try {
            runtime = ManagementFactory.getPlatformMXBean(RuntimeMXBean.class);
        }
        catch (Exception ignored) {
            return new Object[]{pid, processName};
        }
        String name = runtime.getName();
        if (name != null && (idx = name.indexOf(64)) != -1) {
            try {
                pid = Long.parseLong(name.substring(0, idx));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((processName = System.getProperty("jboss.process.name")) == null) {
            String classPath = System.getProperty("java.class.path");
            String commandLine = System.getProperty("sun.java.command");
            if (commandLine != null) {
                if (classPath != null && commandLine.startsWith(classPath)) {
                    int sepIdx = classPath.lastIndexOf(File.separatorChar);
                    processName = sepIdx > 0 ? classPath.substring(sepIdx + 1) : classPath;
                } else {
                    int firstSpace = commandLine.indexOf(32);
                    String className = firstSpace > 0 ? commandLine.substring(0, firstSpace) : commandLine;
                    int lastDot = className.lastIndexOf(46, firstSpace);
                    if (lastDot > 0) {
                        processName = className.substring(lastDot + 1);
                        if (processName.equalsIgnoreCase("jar") || processName.equalsIgnoreCase("\u0237ar")) {
                            int lastSep;
                            int secondLastDot = className.lastIndexOf(46, lastDot - 1);
                            int sepIdx = className.lastIndexOf(File.separatorChar);
                            int n2 = secondLastDot == -1 ? sepIdx : (lastSep = sepIdx == -1 ? secondLastDot : Math.max(sepIdx, secondLastDot));
                            processName = lastSep > 0 ? className.substring(lastSep + 1) : className;
                        }
                    } else {
                        processName = className;
                    }
                }
            }
        }
        if (processName == null) {
            processName = "<unknown>";
        }
        return new Object[]{pid, processName};
    }
}

