/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.common.net;

import java.lang.reflect.Array;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.util.Enumeration;
import java.util.regex.Pattern;
import org.wildfly.common.Assert;
import org.wildfly.common._private.CommonMessages;
import org.wildfly.common.net.CidrAddress;

public final class Inet {
    public static final Inet4Address INET4_ANY = Inet.getInet4Address(0, 0, 0, 0);
    public static final Inet4Address INET4_LOOPBACK = Inet.getInet4Address(127, 0, 0, 1);
    public static final Inet4Address INET4_BROADCAST = Inet.getInet4Address(255, 255, 255, 255);
    public static final Inet6Address INET6_ANY = Inet.getInet6Address(0, 0, 0, 0, 0, 0, 0, 0);
    public static final Inet6Address INET6_LOOPBACK = Inet.getInet6Address(0, 0, 0, 0, 0, 0, 0, 1);
    private static final Pattern NUMERIC = Pattern.compile("\\d+");

    private Inet() {
    }

    public static String toOptimalString(InetAddress inetAddress) {
        Assert.checkNotNullParam("inetAddress", inetAddress);
        return inetAddress instanceof Inet6Address ? Inet.toOptimalStringV6(inetAddress.getAddress()) : inetAddress.getHostAddress();
    }

    public static String toOptimalString(byte[] addressBytes) {
        Assert.checkNotNullParam("addressBytes", addressBytes);
        if (addressBytes.length == 4) {
            return (addressBytes[0] & 0xFF) + "." + (addressBytes[1] & 0xFF) + "." + (addressBytes[2] & 0xFF) + "." + (addressBytes[3] & 0xFF);
        }
        if (addressBytes.length == 16) {
            return Inet.toOptimalStringV6(addressBytes);
        }
        throw CommonMessages.msg.invalidAddressBytes(addressBytes.length);
    }

    public static String toURLString(InetAddress inetAddress, boolean useHostNameIfPresent) {
        String hostName;
        Assert.checkNotNullParam("inetAddress", inetAddress);
        if (useHostNameIfPresent && (hostName = Inet.getHostNameIfResolved(inetAddress)) != null) {
            if (inetAddress instanceof Inet6Address && Inet.isInet6Address(hostName)) {
                return "[" + hostName + "]";
            }
            return hostName;
        }
        if (inetAddress instanceof Inet6Address) {
            return "[" + Inet.toOptimalString(inetAddress) + "]";
        }
        return Inet.toOptimalString(inetAddress);
    }

    public static String toURLString(byte[] addressBytes) {
        Assert.checkNotNullParam("addressBytes", addressBytes);
        if (addressBytes.length == 4) {
            return (addressBytes[0] & 0xFF) + "." + (addressBytes[1] & 0xFF) + "." + (addressBytes[2] & 0xFF) + "." + (addressBytes[3] & 0xFF);
        }
        if (addressBytes.length == 16) {
            return "[" + Inet.toOptimalStringV6(addressBytes) + "]";
        }
        throw CommonMessages.msg.invalidAddressBytes(addressBytes.length);
    }

    public static Inet6Address toInet6Address(InetAddress inetAddress) {
        if (inetAddress instanceof Inet6Address) {
            return (Inet6Address)inetAddress;
        }
        assert (inetAddress instanceof Inet4Address);
        byte[] addr = new byte[16];
        addr[11] = -1;
        addr[10] = -1;
        System.arraycopy(inetAddress.getAddress(), 0, addr, 12, 4);
        try {
            return Inet6Address.getByAddress(Inet.getHostNameIfResolved(inetAddress), addr, 0);
        }
        catch (UnknownHostException e2) {
            throw new IllegalStateException(e2);
        }
    }

    public static String getHostNameIfResolved(InetAddress inetAddress) {
        Assert.checkNotNullParam("inetAddress", inetAddress);
        return Inet.getHostNameIfResolved(new InetSocketAddress(inetAddress, 0));
    }

    public static String getHostNameIfResolved(InetSocketAddress socketAddress) {
        Assert.checkNotNullParam("socketAddress", socketAddress);
        String hostString = socketAddress.getHostString();
        String toString = socketAddress.toString();
        int slash = toString.lastIndexOf(47);
        if (slash == 0) {
            return hostString.isEmpty() ? "" : null;
        }
        return hostString;
    }

    public static InetSocketAddress getResolved(URI uri, int defaultPort, Class<? extends InetAddress> addressType) throws UnknownHostException {
        Assert.checkNotNullParam("uri", uri);
        Assert.checkMinimumParameter("defaultPort", 1, defaultPort);
        Assert.checkMaximumParameter("defaultPort", 65535, defaultPort);
        Assert.checkNotNullParam("addressType", addressType);
        InetAddress resolved = Inet.getResolvedInetAddress(uri, addressType);
        if (resolved == null) {
            return null;
        }
        int uriPort = uri.getPort();
        return uriPort != -1 ? new InetSocketAddress(resolved, uriPort) : new InetSocketAddress(resolved, defaultPort);
    }

    public static InetSocketAddress getResolved(URI uri, int defaultPort) throws UnknownHostException {
        return Inet.getResolved(uri, defaultPort, InetAddress.class);
    }

    public static <T extends InetAddress> T getResolvedInetAddress(URI uri, Class<T> addressType) throws UnknownHostException {
        String uriHost = uri.getHost();
        if (uriHost == null) {
            return null;
        }
        int length = uriHost.length();
        if (length == 0) {
            return null;
        }
        return Inet.getAddressByNameAndType(uriHost, addressType);
    }

    public static InetAddress getResolvedInetAddress(URI uri) throws UnknownHostException {
        return Inet.getResolvedInetAddress(uri, InetAddress.class);
    }

    public static InetSocketAddress getResolved(InetSocketAddress address) throws UnknownHostException {
        return Inet.getResolved(address, InetAddress.class);
    }

    public static InetSocketAddress getResolved(InetSocketAddress address, Class<? extends InetAddress> addressType) throws UnknownHostException {
        Assert.checkNotNullParam("address", address);
        Assert.checkNotNullParam("addressType", addressType);
        if (!address.isUnresolved()) {
            if (!addressType.isInstance(address.getAddress())) {
                throw new UnknownHostException(address.getHostString());
            }
            return address;
        }
        return new InetSocketAddress(Inet.getAddressByNameAndType(address.getHostString(), addressType), address.getPort());
    }

    public static <T extends InetAddress> T getAddressByNameAndType(String hostName, Class<T> addressType) throws UnknownHostException {
        Assert.checkNotNullParam("hostName", hostName);
        Assert.checkNotNullParam("addressType", addressType);
        if (addressType == InetAddress.class) {
            return (T)((InetAddress)addressType.cast(InetAddress.getByName(hostName)));
        }
        for (InetAddress inetAddress : InetAddress.getAllByName(hostName)) {
            if (!addressType.isInstance(inetAddress)) continue;
            return (T)((InetAddress)addressType.cast(inetAddress));
        }
        throw new UnknownHostException(hostName);
    }

    public static <T extends InetAddress> T[] getAllAddressesByNameAndType(String hostName, Class<T> addressType) throws UnknownHostException {
        Assert.checkNotNullParam("hostName", hostName);
        Assert.checkNotNullParam("addressType", addressType);
        if (addressType == InetAddress.class) {
            return InetAddress.getAllByName(hostName);
        }
        InetAddress[] addresses = InetAddress.getAllByName(hostName);
        int length = addresses.length;
        int count = 0;
        for (InetAddress inetAddress : addresses) {
            if (!addressType.isInstance(inetAddress)) continue;
            ++count;
        }
        if (count == 0) {
            throw new UnknownHostException(hostName);
        }
        InetAddress[] newArray = (InetAddress[])Array.newInstance(addressType, count);
        if (count == length) {
            System.arraycopy(addresses, 0, newArray, 0, length);
        } else {
            int idx = 0;
            for (InetAddress inetAddress : addresses) {
                if (!addressType.isInstance(inetAddress)) continue;
                newArray[idx] = (InetAddress)addressType.cast(inetAddress);
            }
        }
        return newArray;
    }

    public static Inet4Address getInet4Address(int s1, int s2, int s3, int s4) {
        byte[] bytes = new byte[4];
        Assert.checkMinimumParameter("s1", 0, s1);
        Assert.checkMaximumParameter("s1", 255, s1);
        Assert.checkMinimumParameter("s2", 0, s2);
        Assert.checkMaximumParameter("s2", 255, s2);
        Assert.checkMinimumParameter("s3", 0, s3);
        Assert.checkMaximumParameter("s3", 255, s3);
        Assert.checkMinimumParameter("s4", 0, s4);
        Assert.checkMaximumParameter("s4", 255, s4);
        bytes[0] = (byte)s1;
        bytes[1] = (byte)s2;
        bytes[2] = (byte)s3;
        bytes[3] = (byte)s4;
        try {
            return (Inet4Address)InetAddress.getByAddress(s1 + "." + s2 + "." + s3 + "." + s4, bytes);
        }
        catch (UnknownHostException e2) {
            throw new IllegalStateException(e2);
        }
    }

    public static Inet6Address getInet6Address(int s1, int s2, int s3, int s4, int s5, int s6, int s7, int s8) {
        byte[] bytes = new byte[16];
        Assert.checkMinimumParameter("s1", 0, s1);
        Assert.checkMaximumParameter("s1", 65535, s1);
        Assert.checkMinimumParameter("s2", 0, s2);
        Assert.checkMaximumParameter("s2", 65535, s2);
        Assert.checkMinimumParameter("s3", 0, s3);
        Assert.checkMaximumParameter("s3", 65535, s3);
        Assert.checkMinimumParameter("s4", 0, s4);
        Assert.checkMaximumParameter("s4", 65535, s4);
        Assert.checkMinimumParameter("s5", 0, s5);
        Assert.checkMaximumParameter("s5", 65535, s5);
        Assert.checkMinimumParameter("s6", 0, s6);
        Assert.checkMaximumParameter("s6", 65535, s6);
        Assert.checkMinimumParameter("s7", 0, s7);
        Assert.checkMaximumParameter("s7", 65535, s7);
        Assert.checkMinimumParameter("s8", 0, s8);
        Assert.checkMaximumParameter("s8", 65535, s8);
        bytes[0] = (byte)(s1 >> 8);
        bytes[1] = (byte)s1;
        bytes[2] = (byte)(s2 >> 8);
        bytes[3] = (byte)s2;
        bytes[4] = (byte)(s3 >> 8);
        bytes[5] = (byte)s3;
        bytes[6] = (byte)(s4 >> 8);
        bytes[7] = (byte)s4;
        bytes[8] = (byte)(s5 >> 8);
        bytes[9] = (byte)s5;
        bytes[10] = (byte)(s6 >> 8);
        bytes[11] = (byte)s6;
        bytes[12] = (byte)(s7 >> 8);
        bytes[13] = (byte)s7;
        bytes[14] = (byte)(s8 >> 8);
        bytes[15] = (byte)s8;
        try {
            return Inet6Address.getByAddress(Inet.toOptimalStringV6(bytes), bytes, 0);
        }
        catch (UnknownHostException e2) {
            throw new IllegalStateException(e2);
        }
    }

    public static boolean isInet6Address(String address) {
        return Inet.parseInet6AddressToBytes(address) != null;
    }

    public static Inet6Address parseInet6Address(String address) {
        return Inet.parseInet6Address(address, null);
    }

    public static Inet6Address parseInet6Address(String address, String hostName) {
        Inet6Address inetAddress;
        byte[] bytes = Inet.parseInet6AddressToBytes(address);
        if (bytes == null) {
            return null;
        }
        int scopeId = 0;
        try {
            inetAddress = Inet6Address.getByAddress(hostName == null ? Inet.toOptimalStringV6(bytes) : hostName, bytes, 0);
        }
        catch (UnknownHostException e2) {
            throw new IllegalStateException(e2);
        }
        int pctIdx = address.indexOf(37);
        if (pctIdx != -1) {
            scopeId = Inet.getScopeId(address.substring(pctIdx + 1), (InetAddress)inetAddress);
            if (scopeId == 0) {
                return null;
            }
            try {
                inetAddress = Inet6Address.getByAddress(hostName == null ? Inet.toOptimalStringV6(bytes) : hostName, bytes, scopeId);
            }
            catch (UnknownHostException e3) {
                throw new IllegalStateException(e3);
            }
        }
        return inetAddress;
    }

    public static Inet6Address parseInet6AddressOrFail(String address) {
        Inet6Address result = Inet.parseInet6Address(address, null);
        if (result == null) {
            throw CommonMessages.msg.invalidAddress(address);
        }
        return result;
    }

    public static Inet6Address parseInet6AddressOrFail(String address, String hostName) {
        Inet6Address result = Inet.parseInet6Address(address, hostName);
        if (result == null) {
            throw CommonMessages.msg.invalidAddress(address);
        }
        return result;
    }

    public static boolean isInet4Address(String address) {
        return Inet.parseInet4AddressToBytes(address) != null;
    }

    public static Inet4Address parseInet4Address(String address) {
        return Inet.parseInet4Address(address, null);
    }

    public static Inet4Address parseInet4Address(String address, String hostName) {
        byte[] bytes = Inet.parseInet4AddressToBytes(address);
        if (bytes == null) {
            return null;
        }
        try {
            return (Inet4Address)Inet4Address.getByAddress(hostName == null ? Inet.toOptimalString(bytes) : hostName, bytes);
        }
        catch (UnknownHostException e2) {
            throw new IllegalStateException(e2);
        }
    }

    public static Inet4Address parseInet4AddressOrFail(String address) {
        Inet4Address result = Inet.parseInet4Address(address, null);
        if (result == null) {
            throw CommonMessages.msg.invalidAddress(address);
        }
        return result;
    }

    public static Inet4Address parseInet4AddressOrFail(String address, String hostName) {
        Inet4Address result = Inet.parseInet4Address(address, hostName);
        if (result == null) {
            throw CommonMessages.msg.invalidAddress(address);
        }
        return result;
    }

    public static InetAddress parseInetAddress(String address) {
        return Inet.parseInetAddress(address, null);
    }

    public static InetAddress parseInetAddress(String address, String hostName) {
        if (address.indexOf(58) != -1) {
            return Inet.parseInet6Address(address, hostName);
        }
        return Inet.parseInet4Address(address, hostName);
    }

    public static InetAddress parseInetAddressOrFail(String address) {
        InetAddress result = Inet.parseInetAddress(address, null);
        if (result == null) {
            throw CommonMessages.msg.invalidAddress(address);
        }
        return result;
    }

    public static InetAddress parseInetAddressOrFail(String address, String hostName) {
        InetAddress result = Inet.parseInetAddress(address, hostName);
        if (result == null) {
            throw CommonMessages.msg.invalidAddress(address);
        }
        return result;
    }

    public static CidrAddress parseCidrAddress(String address) {
        int mask;
        int idx = address.indexOf(47);
        if (idx == -1) {
            return null;
        }
        try {
            mask = Integer.parseInt(address.substring(idx + 1));
        }
        catch (NumberFormatException e2) {
            return null;
        }
        byte[] addressBytes = Inet.parseInetAddressToBytes(address.substring(0, idx));
        if (addressBytes == null) {
            return null;
        }
        try {
            return CidrAddress.create(addressBytes, mask, false);
        }
        catch (IllegalArgumentException e3) {
            return null;
        }
    }

    public static byte[] parseInet6AddressToBytes(String address) {
        int skippedSegments;
        int skipIndex;
        boolean isDefaultRoute;
        int totalSegments;
        String[] segments;
        int pctIdx;
        if (address == null || address.isEmpty()) {
            return null;
        }
        if (address.startsWith("[") && address.endsWith("]")) {
            address = address.substring(1, address.length() - 1);
        }
        if ((pctIdx = address.indexOf(37)) != -1) {
            address = address.substring(0, pctIdx);
        }
        if ((segments = address.split(":", 10)).length > 9 || segments.length < 3) {
            return null;
        }
        if (segments[0].length() == 0 && segments[1].length() != 0) {
            return null;
        }
        if (segments[segments.length - 1].length() == 0 && segments[segments.length - 2].length() != 0) {
            return null;
        }
        for (int i2 = 0; i2 < segments.length; ++i2) {
            for (int charIdx = 0; charIdx < segments[i2].length(); ++charIdx) {
                char c2 = segments[i2].charAt(charIdx);
                if (c2 == '.' && i2 != segments.length - 1) {
                    return null;
                }
                if (c2 == '.' || c2 == ':' || Character.digit(c2, 16) != -1) continue;
                return null;
            }
        }
        int emptyIndex = -1;
        for (int i3 = 0; i3 < segments.length - 1; ++i3) {
            if (segments[i3].length() != 0) continue;
            if (emptyIndex > 0) {
                return null;
            }
            if (emptyIndex == 0) continue;
            emptyIndex = i3;
        }
        boolean containsIPv4 = segments[segments.length - 1].contains(".");
        int n2 = totalSegments = containsIPv4 ? 7 : 8;
        if (emptyIndex == -1 && segments.length != totalSegments) {
            return null;
        }
        boolean bl = isDefaultRoute = segments.length == 3 && segments[0].isEmpty() && segments[1].isEmpty() && segments[2].isEmpty();
        if (isDefaultRoute) {
            skipIndex = 0;
            skippedSegments = 8;
        } else if (segments[0].isEmpty() || segments[segments.length - 1].isEmpty()) {
            skipIndex = emptyIndex;
            skippedSegments = totalSegments - segments.length + 2;
        } else if (emptyIndex > -1) {
            skipIndex = emptyIndex;
            skippedSegments = totalSegments - segments.length + 1;
        } else {
            skipIndex = 0;
            skippedSegments = 0;
        }
        ByteBuffer bytes = ByteBuffer.allocate(16);
        try {
            int i4;
            for (i4 = 0; i4 < skipIndex; ++i4) {
                bytes.putShort(Inet.parseHexadecimal(segments[i4]));
            }
            for (i4 = skipIndex; i4 < skipIndex + skippedSegments; ++i4) {
                bytes.putShort((short)0);
            }
            for (i4 = skipIndex + skippedSegments; i4 < totalSegments; ++i4) {
                int segmentIdx = segments.length - (totalSegments - i4);
                if (containsIPv4 && i4 == totalSegments - 1) {
                    String[] ipV4Segments = segments[segmentIdx].split("\\.");
                    if (ipV4Segments.length != 4) {
                        return null;
                    }
                    for (int idxV4 = 0; idxV4 < 4; ++idxV4) {
                        bytes.put(Inet.parseDecimal(ipV4Segments[idxV4]));
                    }
                    continue;
                }
                bytes.putShort(Inet.parseHexadecimal(segments[segmentIdx]));
            }
            return bytes.array();
        }
        catch (NumberFormatException e2) {
            return null;
        }
    }

    public static byte[] parseInet4AddressToBytes(String address) {
        String[] segments = address.split("\\.", 5);
        if (segments.length != 4) {
            return null;
        }
        for (int i2 = 0; i2 < segments.length; ++i2) {
            if (segments[i2].length() < 1) {
                return null;
            }
            for (int cidx = 0; cidx < segments[i2].length(); ++cidx) {
                if (Character.digit(segments[i2].charAt(cidx), 10) >= 0) continue;
                return null;
            }
        }
        byte[] bytes = new byte[4];
        try {
            for (int i3 = 0; i3 < segments.length; ++i3) {
                bytes[i3] = Inet.parseDecimal(segments[i3]);
            }
            return bytes;
        }
        catch (NumberFormatException e2) {
            return null;
        }
    }

    public static byte[] parseInetAddressToBytes(String address) {
        if (address.indexOf(58) != -1) {
            return Inet.parseInet6AddressToBytes(address);
        }
        return Inet.parseInet4AddressToBytes(address);
    }

    public static int getScopeId(InetAddress address) {
        return address instanceof Inet6Address ? ((Inet6Address)address).getScopeId() : 0;
    }

    public static int getScopeId(String scopeName) {
        return Inet.getScopeId(scopeName, null);
    }

    public static int getScopeId(String scopeName, InetAddress compareWith) {
        Assert.checkNotNullParam("scopeName", scopeName);
        if (NUMERIC.matcher(scopeName).matches()) {
            try {
                return Integer.parseInt(scopeName);
            }
            catch (NumberFormatException ignored) {
                return 0;
            }
        }
        NetworkInterface ni = Inet.findInterfaceWithScopeId(scopeName);
        if (ni == null) {
            return 0;
        }
        return Inet.getScopeId(ni, compareWith);
    }

    public static NetworkInterface findInterfaceWithScopeId(String scopeName) {
        Enumeration<NetworkInterface> enumeration;
        try {
            enumeration = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException ignored) {
            return null;
        }
        while (enumeration.hasMoreElements()) {
            NetworkInterface net = enumeration.nextElement();
            if (!net.getName().equals(scopeName)) continue;
            return net;
        }
        return null;
    }

    public static int getScopeId(NetworkInterface networkInterface) {
        return Inet.getScopeId(networkInterface, null);
    }

    public static int getScopeId(NetworkInterface networkInterface, InetAddress compareWith) {
        Assert.checkNotNullParam("networkInterface", networkInterface);
        Inet6Address cw6 = compareWith instanceof Inet6Address ? (Inet6Address)compareWith : null;
        Inet6Address address = AccessController.doPrivileged(() -> {
            Enumeration<InetAddress> addresses = networkInterface.getInetAddresses();
            while (addresses.hasMoreElements()) {
                InetAddress a2 = addresses.nextElement();
                if (!(a2 instanceof Inet6Address)) continue;
                Inet6Address a6 = (Inet6Address)a2;
                if (cw6 != null && (a6.isLinkLocalAddress() != cw6.isLinkLocalAddress() || a6.isSiteLocalAddress() != cw6.isSiteLocalAddress())) continue;
                return a6;
            }
            return null;
        });
        return address == null ? 0 : address.getScopeId();
    }

    public static URI getURIFromAddress(String scheme, InetSocketAddress socketAddress, int defaultPort) throws URISyntaxException {
        int port;
        String host = Inet.getHostNameIfResolved(socketAddress);
        if (Inet.isInet6Address(host)) {
            host = '[' + host + ']';
        }
        return new URI(scheme, null, host, (port = socketAddress.getPort()) == defaultPort ? -1 : port, null, null, null);
    }

    private static byte parseDecimal(String number) {
        int i2 = Integer.parseInt(number);
        if (i2 < 0 || i2 > 255) {
            throw new NumberFormatException();
        }
        return (byte)i2;
    }

    private static short parseHexadecimal(String hexNumber) {
        int i2 = Integer.parseInt(hexNumber, 16);
        if (i2 > 65535) {
            throw new NumberFormatException();
        }
        return (short)i2;
    }

    private static String toOptimalStringV6(byte[] bytes) {
        int[] segments = new int[8];
        for (int i2 = 0; i2 < 8; ++i2) {
            segments[i2] = (bytes[i2 << 1] & 0xFF) << 8 | bytes[(i2 << 1) + 1] & 0xFF;
        }
        StringBuilder b2 = new StringBuilder();
        for (int i3 = 0; i3 < 8; ++i3) {
            if (segments[i3] == 0) {
                if (i3 == 7) {
                    b2.append('0');
                    continue;
                }
                if (segments[++i3] == 0) {
                    b2.append(':').append(':');
                    ++i3;
                    while (i3 < 8) {
                        if (segments[i3] == 65535 && b2.length() == 2) {
                            b2.append("ffff");
                            if (i3 == 5) {
                                b2.append(':').append(bytes[12] & 0xFF).append('.').append(bytes[13] & 0xFF).append('.').append(bytes[14] & 0xFF).append('.').append(bytes[15] & 0xFF);
                                i3 = 8;
                            } else if (i3 == 4 && segments[5] == 0) {
                                b2.append(":0:").append(bytes[12] & 0xFF).append('.').append(bytes[13] & 0xFF).append('.').append(bytes[14] & 0xFF).append('.').append(bytes[15] & 0xFF);
                                i3 = 8;
                            } else {
                                ++i3;
                                while (i3 < 8) {
                                    b2.append(':').append(Integer.toHexString(segments[i3]));
                                    ++i3;
                                }
                            }
                        } else if (segments[i3] != 0) {
                            b2.append(Integer.toHexString(segments[i3]));
                            ++i3;
                            while (i3 < 8) {
                                b2.append(':').append(Integer.toHexString(segments[i3]));
                                ++i3;
                            }
                        }
                        ++i3;
                    }
                    continue;
                }
                if (i3 > 1) {
                    b2.append(':');
                }
                b2.append('0').append(':').append(Integer.toHexString(segments[i3]));
                continue;
            }
            if (i3 > 0) {
                b2.append(':');
            }
            b2.append(Integer.toHexString(segments[i3]));
        }
        return b2.toString();
    }
}

