/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.common.function;

import org.wildfly.common.Assert;
import org.wildfly.common.function.ExceptionBiConsumer;
import org.wildfly.common.function.ExceptionConsumer;
import org.wildfly.common.function.ExceptionFunction;
import org.wildfly.common.function.ExceptionSupplier;

@FunctionalInterface
public interface ExceptionBiFunction<T, U, R, E extends Exception> {
    public R apply(T var1, U var2) throws E;

    default public <R2> ExceptionBiFunction<T, U, R2, E> andThen(ExceptionFunction<? super R, ? extends R2, ? extends E> after) {
        Assert.checkNotNullParam("after", after);
        return (t2, u2) -> after.apply((R)this.apply(t2, u2));
    }

    default public ExceptionBiConsumer<T, U, E> andThen(ExceptionConsumer<R, ? extends E> after) {
        Assert.checkNotNullParam("after", after);
        return (t2, u2) -> after.accept(this.apply(t2, u2));
    }

    default public ExceptionSupplier<R, E> compose(ExceptionSupplier<? extends T, ? extends E> before1, ExceptionSupplier<? extends U, ? extends E> before2) {
        Assert.checkNotNullParam("before1", before1);
        Assert.checkNotNullParam("before2", before2);
        return () -> this.apply(before1.get(), before2.get());
    }
}

