/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.common.expression;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import java.util.function.BiConsumer;
import org.wildfly.common.Assert;
import org.wildfly.common._private.CommonMessages;
import org.wildfly.common.expression.ExpressionNode;
import org.wildfly.common.expression.LiteralNode;
import org.wildfly.common.expression.Node;
import org.wildfly.common.expression.ResolveContext;
import org.wildfly.common.function.ExceptionBiConsumer;

public final class Expression {
    private final Node content;
    private final Set<String> referencedStrings;
    private static final Expression EMPTY = new Expression(Node.NULL);
    private static final EnumSet<Flag> NO_FLAGS = EnumSet.noneOf(Flag.class);

    Expression(Node content) {
        this.content = content;
        HashSet<String> strings = new HashSet<String>();
        content.catalog(strings);
        this.referencedStrings = strings.isEmpty() ? Collections.emptySet() : (strings.size() == 1 ? Collections.singleton(strings.iterator().next()) : Collections.unmodifiableSet(strings));
    }

    public Set<String> getReferencedStrings() {
        return this.referencedStrings;
    }

    public <E extends Exception> String evaluateException(ExceptionBiConsumer<ResolveContext<E>, StringBuilder, E> expandFunction) throws E {
        Assert.checkNotNullParam("expandFunction", expandFunction);
        StringBuilder b2 = new StringBuilder();
        this.content.emit(new ResolveContext<E>(expandFunction, b2), expandFunction);
        return b2.toString();
    }

    public String evaluate(BiConsumer<ResolveContext<RuntimeException>, StringBuilder> expandFunction) {
        return this.evaluateException(expandFunction::accept);
    }

    public String evaluateWithPropertiesAndEnvironment(boolean failOnNoDefault) {
        return this.evaluate((c2, b2) -> {
            String key = c2.getKey();
            if (key.startsWith("env.")) {
                String env = key.substring(4);
                String val = System.getenv(env);
                if (val == null) {
                    if (failOnNoDefault && !c2.hasDefault()) {
                        throw CommonMessages.msg.unresolvedEnvironmentProperty(env);
                    }
                    c2.expandDefault();
                } else {
                    b2.append(val);
                }
            } else {
                String val = System.getProperty(key);
                if (val == null) {
                    if (failOnNoDefault && !c2.hasDefault()) {
                        throw CommonMessages.msg.unresolvedSystemProperty(key);
                    }
                    c2.expandDefault();
                } else {
                    b2.append(val);
                }
            }
        });
    }

    public String evaluateWithProperties(boolean failOnNoDefault) {
        return this.evaluate((c2, b2) -> {
            String key = c2.getKey();
            String val = System.getProperty(key);
            if (val == null) {
                if (failOnNoDefault && !c2.hasDefault()) {
                    throw CommonMessages.msg.unresolvedSystemProperty(key);
                }
                c2.expandDefault();
            } else {
                b2.append(val);
            }
        });
    }

    public String evaluateWithEnvironment(boolean failOnNoDefault) {
        return this.evaluate((c2, b2) -> {
            String key = c2.getKey();
            String val = System.getenv(key);
            if (val == null) {
                if (failOnNoDefault && !c2.hasDefault()) {
                    throw CommonMessages.msg.unresolvedEnvironmentProperty(key);
                }
                c2.expandDefault();
            } else {
                b2.append(val);
            }
        });
    }

    public static Expression compile(String string, Flag ... flags) {
        return Expression.compile(string, flags == null || flags.length == 0 ? NO_FLAGS : EnumSet.of(flags[0], flags));
    }

    public static Expression compile(String string, EnumSet<Flag> flags) {
        Assert.checkNotNullParam("string", string);
        Assert.checkNotNullParam("flags", flags);
        Itr itr = flags.contains((Object)Flag.NO_TRIM) ? new Itr(string) : new Itr(string.trim());
        Node content = Expression.parseString(itr, true, false, false, flags);
        return content == Node.NULL ? EMPTY : new Expression(content);
    }

    private static Node parseString(Itr itr, boolean allowExpr, boolean endOnBrace, boolean endOnColon, EnumSet<Flag> flags) {
        int ignoreBraceLevel = 0;
        ArrayList<Node> list = new ArrayList<Node>();
        int start = itr.getNextIdx();
        block21: while (itr.hasNext()) {
            int idx = itr.getNextIdx();
            int ch = itr.next();
            switch (ch) {
                case 36: {
                    if (!allowExpr) continue block21;
                    if (!itr.hasNext()) {
                        if (!flags.contains((Object)Flag.LENIENT_SYNTAX)) {
                            throw Expression.invalidExpressionSyntax(itr.getStr(), idx);
                        }
                        list.add(new LiteralNode(itr.getStr(), start, itr.getNextIdx()));
                        start = itr.getNextIdx();
                        continue block21;
                    }
                    if (idx > start) {
                        list.add(new LiteralNode(itr.getStr(), start, idx));
                    }
                    idx = itr.getNextIdx();
                    ch = itr.next();
                    switch (ch) {
                        case 123: {
                            boolean general;
                            boolean bl = general = flags.contains((Object)Flag.GENERAL_EXPANSION) && itr.hasNext() && itr.peekNext() == 123;
                            if (general) {
                                itr.next();
                            }
                            start = itr.getNextIdx();
                            Node keyNode = Expression.parseString(itr, !flags.contains((Object)Flag.NO_RECURSE_KEY), true, true, flags);
                            if (!itr.hasNext()) {
                                if (!flags.contains((Object)Flag.LENIENT_SYNTAX)) {
                                    throw Expression.invalidExpressionSyntax(itr.getStr(), itr.getNextIdx());
                                }
                                list.add(new ExpressionNode(general, keyNode, Node.NULL));
                                start = itr.getNextIdx();
                                continue block21;
                            }
                            if (itr.peekNext() == 58) {
                                if (flags.contains((Object)Flag.DOUBLE_COLON) && itr.hasNext() && itr.peekNext() == 58) {
                                    itr.rewind(start);
                                    keyNode = Expression.parseString(itr, !flags.contains((Object)Flag.NO_RECURSE_KEY), true, false, flags);
                                    list.add(new ExpressionNode(general, keyNode, Node.NULL));
                                } else {
                                    itr.next();
                                    Node defaultValueNode = Expression.parseString(itr, !flags.contains((Object)Flag.NO_RECURSE_DEFAULT), true, false, flags);
                                    list.add(new ExpressionNode(general, keyNode, defaultValueNode));
                                }
                                if (!itr.hasNext()) {
                                    if (!flags.contains((Object)Flag.LENIENT_SYNTAX)) {
                                        throw Expression.invalidExpressionSyntax(itr.getStr(), itr.getNextIdx());
                                    }
                                    start = itr.getNextIdx();
                                    continue block21;
                                }
                                assert (itr.peekNext() == 125);
                                itr.next();
                                if (general) {
                                    if (!itr.hasNext()) {
                                        if (!flags.contains((Object)Flag.LENIENT_SYNTAX)) {
                                            throw Expression.invalidExpressionSyntax(itr.getStr(), itr.getNextIdx());
                                        }
                                        start = itr.getNextIdx();
                                        continue block21;
                                    }
                                    if (itr.peekNext() == 125) {
                                        itr.next();
                                        start = itr.getNextIdx();
                                        continue block21;
                                    }
                                    if (!flags.contains((Object)Flag.LENIENT_SYNTAX)) {
                                        throw Expression.invalidExpressionSyntax(itr.getStr(), itr.getNextIdx());
                                    }
                                    start = itr.getNextIdx();
                                    continue block21;
                                }
                                start = itr.getNextIdx();
                                continue block21;
                            }
                            assert (itr.peekNext() == 125);
                            itr.next();
                            list.add(new ExpressionNode(general, keyNode, Node.NULL));
                            if (general) {
                                if (!itr.hasNext()) {
                                    if (!flags.contains((Object)Flag.LENIENT_SYNTAX)) {
                                        throw Expression.invalidExpressionSyntax(itr.getStr(), itr.getNextIdx());
                                    }
                                    start = itr.getNextIdx();
                                    continue block21;
                                }
                                if (itr.peekNext() == 125) {
                                    itr.next();
                                    start = itr.getNextIdx();
                                    continue block21;
                                }
                                if (!flags.contains((Object)Flag.LENIENT_SYNTAX)) {
                                    throw Expression.invalidExpressionSyntax(itr.getStr(), itr.getNextIdx());
                                }
                                start = itr.getNextIdx();
                                continue block21;
                            }
                            start = itr.getNextIdx();
                            continue block21;
                        }
                        case 36: {
                            if (flags.contains((Object)Flag.MINI_EXPRS)) {
                                list.add(new ExpressionNode(false, LiteralNode.DOLLAR, Node.NULL));
                            } else {
                                list.add(LiteralNode.DOLLAR);
                            }
                            start = itr.getNextIdx();
                            continue block21;
                        }
                        case 125: {
                            if (flags.contains((Object)Flag.MINI_EXPRS)) {
                                list.add(new ExpressionNode(false, LiteralNode.CLOSE_BRACE, Node.NULL));
                                start = itr.getNextIdx();
                                continue block21;
                            }
                            if (endOnBrace) {
                                if (flags.contains((Object)Flag.LENIENT_SYNTAX)) {
                                    list.add(LiteralNode.DOLLAR);
                                    itr.prev();
                                    return Node.fromList(list);
                                }
                                throw Expression.invalidExpressionSyntax(itr.getStr(), idx);
                            }
                            if (flags.contains((Object)Flag.LENIENT_SYNTAX)) {
                                list.add(LiteralNode.DOLLAR);
                                list.add(LiteralNode.CLOSE_BRACE);
                                start = itr.getNextIdx();
                                continue block21;
                            }
                            throw Expression.invalidExpressionSyntax(itr.getStr(), idx);
                        }
                        case 58: {
                            if (flags.contains((Object)Flag.MINI_EXPRS)) {
                                list.add(new ExpressionNode(false, LiteralNode.COLON, Node.NULL));
                                start = itr.getNextIdx();
                                continue block21;
                            }
                            if (endOnColon) {
                                if (flags.contains((Object)Flag.LENIENT_SYNTAX)) {
                                    itr.prev();
                                    list.add(LiteralNode.DOLLAR);
                                    return Node.fromList(list);
                                }
                                throw Expression.invalidExpressionSyntax(itr.getStr(), idx);
                            }
                            if (flags.contains((Object)Flag.LENIENT_SYNTAX)) {
                                list.add(LiteralNode.DOLLAR);
                                list.add(LiteralNode.COLON);
                                start = itr.getNextIdx();
                                continue block21;
                            }
                            throw Expression.invalidExpressionSyntax(itr.getStr(), idx);
                        }
                    }
                    if (flags.contains((Object)Flag.MINI_EXPRS)) {
                        list.add(new ExpressionNode(false, new LiteralNode(itr.getStr(), idx, itr.getNextIdx()), Node.NULL));
                        start = itr.getNextIdx();
                        continue block21;
                    }
                    if (flags.contains((Object)Flag.LENIENT_SYNTAX)) {
                        start = itr.getPrevIdx() - 1;
                        continue block21;
                    }
                    throw Expression.invalidExpressionSyntax(itr.getStr(), idx);
                }
                case 58: {
                    if (!endOnColon) continue block21;
                    itr.prev();
                    if (idx > start) {
                        list.add(new LiteralNode(itr.getStr(), start, idx));
                    }
                    return Node.fromList(list);
                }
                case 123: {
                    if (flags.contains((Object)Flag.NO_SMART_BRACES)) continue block21;
                    ++ignoreBraceLevel;
                    continue block21;
                }
                case 125: {
                    if (!flags.contains((Object)Flag.NO_SMART_BRACES) && ignoreBraceLevel > 0) {
                        --ignoreBraceLevel;
                        continue block21;
                    }
                    if (!endOnBrace) continue block21;
                    itr.prev();
                    if (idx >= start) {
                        list.add(new LiteralNode(itr.getStr(), start, idx));
                    }
                    return Node.fromList(list);
                }
                case 92: {
                    LiteralNode node;
                    if (!flags.contains((Object)Flag.ESCAPES)) continue block21;
                    if (idx > start) {
                        list.add(new LiteralNode(itr.getStr(), start, idx));
                        start = idx;
                    }
                    if (!itr.hasNext()) {
                        if (flags.contains((Object)Flag.LENIENT_SYNTAX)) continue block21;
                        throw Expression.invalidExpressionSyntax(itr.getStr(), idx);
                    }
                    ch = itr.next();
                    switch (ch) {
                        case 110: {
                            node = LiteralNode.NEWLINE;
                            break;
                        }
                        case 114: {
                            node = LiteralNode.CARRIAGE_RETURN;
                            break;
                        }
                        case 116: {
                            node = LiteralNode.TAB;
                            break;
                        }
                        case 98: {
                            node = LiteralNode.BACKSPACE;
                            break;
                        }
                        case 102: {
                            node = LiteralNode.FORM_FEED;
                            break;
                        }
                        case 92: {
                            node = LiteralNode.BACKSLASH;
                            break;
                        }
                        default: {
                            if (flags.contains((Object)Flag.LENIENT_SYNTAX)) {
                                start = itr.getPrevIdx();
                                continue block21;
                            }
                            throw Expression.invalidExpressionSyntax(itr.getStr(), idx);
                        }
                    }
                    list.add(node);
                    start = itr.getNextIdx();
                    continue block21;
                }
            }
        }
        int length = itr.getStr().length();
        if (length > start) {
            list.add(new LiteralNode(itr.getStr(), start, length));
        }
        return Node.fromList(list);
    }

    private static IllegalArgumentException invalidExpressionSyntax(String string, int index) {
        String msg = CommonMessages.msg.invalidExpressionSyntax(index);
        StringBuilder b2 = new StringBuilder(msg.length() + string.length() + string.length() + 5);
        b2.append(msg);
        b2.append('\n').append('\t').append(string);
        b2.append('\n').append('\t');
        int i2 = 0;
        while (i2 < index) {
            int cp = string.codePointAt(i2);
            if (Character.isWhitespace(cp)) {
                b2.append(cp);
            } else if (Character.isValidCodePoint(cp) && !Character.isISOControl(cp)) {
                b2.append(' ');
            }
            i2 = string.offsetByCodePoints(i2, 1);
        }
        b2.append('^');
        return new IllegalArgumentException(b2.toString());
    }

    public static enum Flag {
        NO_TRIM,
        LENIENT_SYNTAX,
        MINI_EXPRS,
        NO_RECURSE_KEY,
        NO_RECURSE_DEFAULT,
        NO_SMART_BRACES,
        GENERAL_EXPANSION,
        ESCAPES,
        DOUBLE_COLON;

    }

    static final class Itr {
        private final String str;
        private int idx;

        Itr(String str) {
            this.str = str;
        }

        boolean hasNext() {
            return this.idx < this.str.length();
        }

        int next() {
            int idx = this.idx;
            try {
                int n2 = this.str.codePointAt(idx);
                return n2;
            }
            finally {
                this.idx = this.str.offsetByCodePoints(idx, 1);
            }
        }

        int prev() {
            int idx = this.idx;
            try {
                int n2 = this.str.codePointBefore(idx);
                return n2;
            }
            finally {
                this.idx = this.str.offsetByCodePoints(idx, -1);
            }
        }

        int getNextIdx() {
            return this.idx;
        }

        int getPrevIdx() {
            return this.str.offsetByCodePoints(this.idx, -1);
        }

        String getStr() {
            return this.str;
        }

        int peekNext() {
            return this.str.codePointAt(this.idx);
        }

        int peekPrev() {
            return this.str.codePointBefore(this.idx);
        }

        void rewind(int newNext) {
            this.idx = newNext;
        }
    }
}

