/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.common.array;

import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.wildfly.common.Assert;
import org.wildfly.common.iteration.EnumerationIterator;

public final class ArrayIterator<E>
implements ListIterator<E>,
EnumerationIterator<E> {
    private final E[] elements;
    private final boolean descending;
    private int idx;

    public ArrayIterator(E[] elements) {
        this(elements, false);
    }

    public ArrayIterator(E[] elements, boolean descending) {
        this(elements, descending, descending ? elements.length : 0);
    }

    public ArrayIterator(E[] elements, int startIdx) {
        this(elements, false, startIdx);
    }

    public ArrayIterator(E[] elements, boolean descending, int startIdx) {
        Assert.checkNotNullParam("elements", elements);
        Assert.checkMinimumParameter("startIdx", 0, startIdx);
        Assert.checkMaximumParameter("startIdx", elements.length, startIdx);
        this.elements = elements;
        this.descending = descending;
        this.idx = startIdx;
    }

    @Override
    public boolean hasPrevious() {
        return this.descending ? this.idx < this.elements.length : this.idx > 0;
    }

    @Override
    public boolean hasNext() {
        return this.descending ? this.idx > 0 : this.idx < this.elements.length;
    }

    @Override
    public E previous() {
        int n2;
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        if (this.descending) {
            int n3 = this.idx;
            n2 = n3;
            this.idx = n3 + 1;
        } else {
            n2 = this.idx = this.idx - 1;
        }
        return this.elements[n2];
    }

    @Override
    public E next() {
        int n2;
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        if (this.descending) {
            n2 = this.idx = this.idx - 1;
        } else {
            int n3 = this.idx;
            n2 = n3;
            this.idx = n3 + 1;
        }
        return this.elements[n2];
    }

    @Override
    public int nextIndex() {
        return this.descending ? this.idx - 1 : this.idx;
    }

    @Override
    public int previousIndex() {
        return this.descending ? this.idx : this.idx - 1;
    }

    @Override
    public void remove() {
        throw Assert.unsupported();
    }

    @Override
    public void set(E e2) {
        throw Assert.unsupported();
    }

    @Override
    public void add(E e2) {
        throw Assert.unsupported();
    }
}

