/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.client.config;

import java.util.NoSuchElementException;
import javax.xml.stream.XMLStreamException;
import org.wildfly.client.config.AbstractDelegatingXMLStreamReader;
import org.wildfly.client.config.ConfigXMLParseException;
import org.wildfly.client.config.ConfigurationXMLStreamReader;

final class ScopedXMLStreamReader
extends AbstractDelegatingXMLStreamReader {
    private int level;

    ScopedXMLStreamReader(boolean closeDelegate, ConfigurationXMLStreamReader delegate) {
        super(closeDelegate, delegate);
    }

    @Override
    public boolean hasNext() throws ConfigXMLParseException {
        try {
            return this.level >= 0 && this.getDelegate().hasNext();
        }
        catch (XMLStreamException e2) {
            throw ConfigXMLParseException.from(e2);
        }
    }

    @Override
    public int next() throws ConfigXMLParseException {
        int next;
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        try {
            next = this.getDelegate().next();
        }
        catch (XMLStreamException e2) {
            throw ConfigXMLParseException.from(e2);
        }
        switch (next) {
            case 1: {
                ++this.level;
                break;
            }
            case 2: {
                --this.level;
            }
        }
        return next;
    }
}

