/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.util;

import java.awt.Paint;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.jfree.io.SerialUtilities;
import org.jfree.util.AbstractObjectList;
import org.jfree.util.PaintUtilities;

public class PaintList
extends AbstractObjectList {
    private static final long serialVersionUID = -708669381577938219L;

    public Paint getPaint(int index) {
        return (Paint)this.get(index);
    }

    public void setPaint(int index, Paint paint) {
        this.set(index, paint);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof PaintList)) {
            return false;
        }
        PaintList that = (PaintList)obj;
        int listSize = this.size();
        for (int i2 = 0; i2 < listSize; ++i2) {
            if (PaintUtilities.equal(this.getPaint(i2), that.getPaint(i2))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        int count = this.size();
        stream.writeInt(count);
        for (int i2 = 0; i2 < count; ++i2) {
            Paint paint = this.getPaint(i2);
            if (paint != null) {
                stream.writeInt(i2);
                SerialUtilities.writePaint(paint, stream);
                continue;
            }
            stream.writeInt(-1);
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        int count = stream.readInt();
        for (int i2 = 0; i2 < count; ++i2) {
            int index = stream.readInt();
            if (index == -1) continue;
            this.setPaint(index, SerialUtilities.readPaint(stream));
        }
    }
}

