/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.ui.action;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JRadioButton;
import javax.swing.KeyStroke;
import org.jfree.util.Log;

public class ActionRadioButton
extends JRadioButton {
    private Action action;
    private ActionEnablePropertyChangeHandler propertyChangeHandler;

    public ActionRadioButton() {
    }

    public ActionRadioButton(String text) {
        super(text);
    }

    public ActionRadioButton(String text, Icon icon) {
        super(text, icon);
    }

    public ActionRadioButton(Icon icon) {
        super(icon);
    }

    public ActionRadioButton(Action action) {
        this.setAction(action);
    }

    @Override
    public Action getAction() {
        return this.action;
    }

    private ActionEnablePropertyChangeHandler getPropertyChangeHandler() {
        if (this.propertyChangeHandler == null) {
            this.propertyChangeHandler = new ActionEnablePropertyChangeHandler();
        }
        return this.propertyChangeHandler;
    }

    @Override
    public void setEnabled(boolean b2) {
        super.setEnabled(b2);
        if (this.getAction() != null) {
            this.getAction().setEnabled(b2);
        }
    }

    @Override
    public void setAction(Action newAction) {
        KeyStroke k2;
        Object o2;
        Action oldAction = this.getAction();
        if (oldAction != null) {
            this.removeActionListener(oldAction);
            oldAction.removePropertyChangeListener(this.getPropertyChangeHandler());
            o2 = oldAction.getValue("AcceleratorKey");
            if (o2 instanceof KeyStroke && o2 != null) {
                k2 = (KeyStroke)o2;
                this.unregisterKeyboardAction(k2);
            }
        }
        this.action = newAction;
        if (this.action != null) {
            this.addActionListener(newAction);
            newAction.addPropertyChangeListener(this.getPropertyChangeHandler());
            this.setText((String)newAction.getValue("Name"));
            this.setToolTipText((String)newAction.getValue("ShortDescription"));
            this.setIcon((Icon)newAction.getValue("SmallIcon"));
            this.setEnabled(this.action.isEnabled());
            o2 = newAction.getValue("MnemonicKey");
            if (o2 != null) {
                Comparable<Character> c2;
                if (o2 instanceof Character) {
                    c2 = (Character)o2;
                    this.setMnemonic(((Character)c2).charValue());
                } else if (o2 instanceof Integer) {
                    c2 = (Integer)o2;
                    this.setMnemonic((Integer)c2);
                }
            }
            if ((o2 = newAction.getValue("AcceleratorKey")) instanceof KeyStroke && o2 != null) {
                k2 = (KeyStroke)o2;
                this.registerKeyboardAction(newAction, k2, 2);
            }
        }
    }

    private class ActionEnablePropertyChangeHandler
    implements PropertyChangeListener {
        private ActionEnablePropertyChangeHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            try {
                Object o2;
                if (event.getPropertyName().equals("enabled")) {
                    ActionRadioButton.this.setEnabled(ActionRadioButton.this.getAction().isEnabled());
                } else if (event.getPropertyName().equals("SmallIcon")) {
                    ActionRadioButton.this.setIcon((Icon)ActionRadioButton.this.getAction().getValue("SmallIcon"));
                } else if (event.getPropertyName().equals("Name")) {
                    ActionRadioButton.this.setText((String)ActionRadioButton.this.getAction().getValue("Name"));
                } else if (event.getPropertyName().equals("ShortDescription")) {
                    ActionRadioButton.this.setToolTipText((String)ActionRadioButton.this.getAction().getValue("ShortDescription"));
                }
                Action ac2 = ActionRadioButton.this.getAction();
                if (event.getPropertyName().equals("AcceleratorKey")) {
                    Object o3;
                    KeyStroke oldVal = (KeyStroke)event.getOldValue();
                    if (oldVal != null) {
                        ActionRadioButton.this.unregisterKeyboardAction(oldVal);
                    }
                    if ((o3 = ac2.getValue("AcceleratorKey")) instanceof KeyStroke && o3 != null) {
                        KeyStroke k2 = (KeyStroke)o3;
                        ActionRadioButton.this.registerKeyboardAction(ac2, k2, 2);
                    }
                } else if (event.getPropertyName().equals("MnemonicKey") && (o2 = ac2.getValue("MnemonicKey")) != null) {
                    if (o2 instanceof Character) {
                        Character c2 = (Character)o2;
                        ActionRadioButton.this.setMnemonic(c2.charValue());
                    } else if (o2 instanceof Integer) {
                        Integer c3 = (Integer)o2;
                        ActionRadioButton.this.setMnemonic(c3);
                    }
                }
            }
            catch (Exception e2) {
                Log.warn("Error on PropertyChange in ActionButton: ", e2);
            }
        }
    }
}

