/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.lang.reflect.Method;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.jfree.ui.NumberCellRenderer;

public class RefineryUtilities {
    private RefineryUtilities() {
    }

    public static Point getCenterPoint() {
        GraphicsEnvironment localGraphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        try {
            Method method = GraphicsEnvironment.class.getMethod("getCenterPoint", null);
            return (Point)method.invoke((Object)localGraphicsEnvironment, (Object[])null);
        }
        catch (Exception e2) {
            Dimension s2 = Toolkit.getDefaultToolkit().getScreenSize();
            return new Point(s2.width / 2, s2.height / 2);
        }
    }

    public static Rectangle getMaximumWindowBounds() {
        GraphicsEnvironment localGraphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        try {
            Method method = GraphicsEnvironment.class.getMethod("getMaximumWindowBounds", null);
            return (Rectangle)method.invoke((Object)localGraphicsEnvironment, (Object[])null);
        }
        catch (Exception e2) {
            Dimension s2 = Toolkit.getDefaultToolkit().getScreenSize();
            return new Rectangle(0, 0, s2.width, s2.height);
        }
    }

    public static void centerFrameOnScreen(Window frame) {
        RefineryUtilities.positionFrameOnScreen(frame, 0.5, 0.5);
    }

    public static void positionFrameOnScreen(Window frame, double horizontalPercent, double verticalPercent) {
        Rectangle s2 = frame.getGraphicsConfiguration().getBounds();
        Dimension f2 = frame.getSize();
        int w2 = Math.max(s2.width - f2.width, 0);
        int h2 = Math.max(s2.height - f2.height, 0);
        int x2 = (int)(horizontalPercent * (double)w2) + s2.x;
        int y2 = (int)(verticalPercent * (double)h2) + s2.y;
        frame.setBounds(x2, y2, f2.width, f2.height);
    }

    public static void positionFrameRandomly(Window frame) {
        RefineryUtilities.positionFrameOnScreen(frame, Math.random(), Math.random());
    }

    public static void centerDialogInParent(Dialog dialog) {
        RefineryUtilities.positionDialogRelativeToParent(dialog, 0.5, 0.5);
    }

    public static void positionDialogRelativeToParent(Dialog dialog, double horizontalPercent, double verticalPercent) {
        Container parent = dialog.getParent();
        if (parent == null) {
            RefineryUtilities.centerFrameOnScreen(dialog);
            return;
        }
        Dimension d2 = dialog.getSize();
        Dimension p2 = parent.getSize();
        int baseX = parent.getX();
        int baseY = parent.getY();
        int x2 = baseX + (int)(horizontalPercent * (double)p2.width);
        int y2 = baseY + (int)(verticalPercent * (double)p2.height);
        Rectangle s2 = parent.getGraphicsConfiguration().getBounds();
        Rectangle r2 = new Rectangle(x2, y2, d2.width, d2.height);
        dialog.setBounds(r2.intersection(s2));
    }

    public static JPanel createTablePanel(TableModel model) {
        JPanel panel = new JPanel(new BorderLayout());
        JTable table = new JTable(model);
        for (int columnIndex = 0; columnIndex < model.getColumnCount(); ++columnIndex) {
            TableColumn column = table.getColumnModel().getColumn(columnIndex);
            Class<?> c2 = model.getColumnClass(columnIndex);
            if (!c2.equals(Number.class)) continue;
            column.setCellRenderer(new NumberCellRenderer());
        }
        panel.add(new JScrollPane(table));
        return panel;
    }

    public static JLabel createJLabel(String text, Font font) {
        JLabel result = new JLabel(text);
        result.setFont(font);
        return result;
    }

    public static JLabel createJLabel(String text, Font font, Color color) {
        JLabel result = new JLabel(text);
        result.setFont(font);
        result.setForeground(color);
        return result;
    }

    public static JButton createJButton(String label, Font font) {
        JButton result = new JButton(label);
        result.setFont(font);
        return result;
    }
}

