/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.statistics;

import org.jfree.chart.util.ParamChecks;
import org.jfree.data.xy.XYDataset;

public abstract class Regression {
    public static double[] getOLSRegression(double[][] data) {
        int n2 = data.length;
        if (n2 < 2) {
            throw new IllegalArgumentException("Not enough data.");
        }
        double sumX = 0.0;
        double sumY = 0.0;
        double sumXX = 0.0;
        double sumXY = 0.0;
        for (int i2 = 0; i2 < n2; ++i2) {
            double x2 = data[i2][0];
            double y2 = data[i2][1];
            sumX += x2;
            sumY += y2;
            double xx = x2 * x2;
            sumXX += xx;
            double xy = x2 * y2;
            sumXY += xy;
        }
        double sxx = sumXX - sumX * sumX / (double)n2;
        double sxy = sumXY - sumX * sumY / (double)n2;
        double xbar = sumX / (double)n2;
        double ybar = sumY / (double)n2;
        double[] result = new double[2];
        result[1] = sxy / sxx;
        result[0] = ybar - result[1] * xbar;
        return result;
    }

    public static double[] getOLSRegression(XYDataset data, int series) {
        int n2 = data.getItemCount(series);
        if (n2 < 2) {
            throw new IllegalArgumentException("Not enough data.");
        }
        double sumX = 0.0;
        double sumY = 0.0;
        double sumXX = 0.0;
        double sumXY = 0.0;
        for (int i2 = 0; i2 < n2; ++i2) {
            double x2 = data.getXValue(series, i2);
            double y2 = data.getYValue(series, i2);
            sumX += x2;
            sumY += y2;
            double xx = x2 * x2;
            sumXX += xx;
            double xy = x2 * y2;
            sumXY += xy;
        }
        double sxx = sumXX - sumX * sumX / (double)n2;
        double sxy = sumXY - sumX * sumY / (double)n2;
        double xbar = sumX / (double)n2;
        double ybar = sumY / (double)n2;
        double[] result = new double[2];
        result[1] = sxy / sxx;
        result[0] = ybar - result[1] * xbar;
        return result;
    }

    public static double[] getPowerRegression(double[][] data) {
        int n2 = data.length;
        if (n2 < 2) {
            throw new IllegalArgumentException("Not enough data.");
        }
        double sumX = 0.0;
        double sumY = 0.0;
        double sumXX = 0.0;
        double sumXY = 0.0;
        for (int i2 = 0; i2 < n2; ++i2) {
            double x2 = Math.log(data[i2][0]);
            double y2 = Math.log(data[i2][1]);
            sumX += x2;
            sumY += y2;
            double xx = x2 * x2;
            sumXX += xx;
            double xy = x2 * y2;
            sumXY += xy;
        }
        double sxx = sumXX - sumX * sumX / (double)n2;
        double sxy = sumXY - sumX * sumY / (double)n2;
        double xbar = sumX / (double)n2;
        double ybar = sumY / (double)n2;
        double[] result = new double[2];
        result[1] = sxy / sxx;
        result[0] = Math.pow(Math.exp(1.0), ybar - result[1] * xbar);
        return result;
    }

    public static double[] getPowerRegression(XYDataset data, int series) {
        int n2 = data.getItemCount(series);
        if (n2 < 2) {
            throw new IllegalArgumentException("Not enough data.");
        }
        double sumX = 0.0;
        double sumY = 0.0;
        double sumXX = 0.0;
        double sumXY = 0.0;
        for (int i2 = 0; i2 < n2; ++i2) {
            double x2 = Math.log(data.getXValue(series, i2));
            double y2 = Math.log(data.getYValue(series, i2));
            sumX += x2;
            sumY += y2;
            double xx = x2 * x2;
            sumXX += xx;
            double xy = x2 * y2;
            sumXY += xy;
        }
        double sxx = sumXX - sumX * sumX / (double)n2;
        double sxy = sumXY - sumX * sumY / (double)n2;
        double xbar = sumX / (double)n2;
        double ybar = sumY / (double)n2;
        double[] result = new double[2];
        result[1] = sxy / sxx;
        result[0] = Math.pow(Math.exp(1.0), ybar - result[1] * xbar);
        return result;
    }

    public static double[] getPolynomialRegression(XYDataset dataset, int series, int order) {
        double rSquare;
        int coe;
        int eq;
        ParamChecks.nullNotPermitted(dataset, "dataset");
        int itemCount = dataset.getItemCount(series);
        if (itemCount < order + 1) {
            throw new IllegalArgumentException("Not enough data.");
        }
        int validItems = 0;
        double[][] data = new double[2][itemCount];
        for (int item = 0; item < itemCount; ++item) {
            double x2 = dataset.getXValue(series, item);
            double y2 = dataset.getYValue(series, item);
            if (Double.isNaN(x2) || Double.isNaN(y2)) continue;
            data[0][validItems] = x2;
            data[1][validItems] = y2;
            ++validItems;
        }
        if (validItems < order + 1) {
            throw new IllegalArgumentException("Not enough data.");
        }
        int equations = order + 1;
        int coefficients = order + 2;
        double[] result = new double[equations + 1];
        double[][] matrix = new double[equations][coefficients];
        double sumX = 0.0;
        double sumY = 0.0;
        for (int item = 0; item < validItems; ++item) {
            sumX += data[0][item];
            sumY += data[1][item];
            for (eq = 0; eq < equations; ++eq) {
                for (coe = 0; coe < coefficients - 1; ++coe) {
                    double[] dArray = matrix[eq];
                    int n2 = coe;
                    dArray[n2] = dArray[n2] + Math.pow(data[0][item], eq + coe);
                }
                double[] dArray = matrix[eq];
                int n3 = coefficients - 1;
                dArray[n3] = dArray[n3] + data[1][item] * Math.pow(data[0][item], eq);
            }
        }
        double[][] subMatrix = Regression.calculateSubMatrix(matrix);
        for (eq = 1; eq < equations; ++eq) {
            matrix[eq][0] = 0.0;
            for (coe = 1; coe < coefficients; ++coe) {
                matrix[eq][coe] = subMatrix[eq - 1][coe - 1];
            }
        }
        for (eq = equations - 1; eq > -1; --eq) {
            double value = matrix[eq][coefficients - 1];
            for (int coe2 = eq; coe2 < coefficients - 1; ++coe2) {
                value -= matrix[eq][coe2] * result[coe2];
            }
            result[eq] = value / matrix[eq][eq];
        }
        double meanY = sumY / (double)validItems;
        double yObsSquare = 0.0;
        double yRegSquare = 0.0;
        for (int item = 0; item < validItems; ++item) {
            double yCalc = 0.0;
            for (int eq2 = 0; eq2 < equations; ++eq2) {
                yCalc += result[eq2] * Math.pow(data[0][item], eq2);
            }
            yRegSquare += Math.pow(yCalc - meanY, 2.0);
            yObsSquare += Math.pow(data[1][item] - meanY, 2.0);
        }
        result[equations] = rSquare = yRegSquare / yObsSquare;
        return result;
    }

    private static double[][] calculateSubMatrix(double[][] matrix) {
        int equations = matrix.length;
        int coefficients = matrix[0].length;
        double[][] result = new double[equations - 1][coefficients - 1];
        for (int eq = 1; eq < equations; ++eq) {
            double factor = matrix[0][0] / matrix[eq][0];
            for (int coe = 1; coe < coefficients; ++coe) {
                result[eq - 1][coe - 1] = matrix[0][coe] - matrix[eq][coe] * factor;
            }
        }
        if (equations == 1) {
            return result;
        }
        if (result[0][0] == 0.0) {
            boolean found = false;
            for (int i2 = 0; i2 < result.length; ++i2) {
                if (result[i2][0] == 0.0) continue;
                found = true;
                double[] temp = result[0];
                System.arraycopy(result[i2], 0, result[0], 0, result[i2].length);
                System.arraycopy(temp, 0, result[i2], 0, temp.length);
                break;
            }
            if (!found) {
                return new double[equations - 1][coefficients - 1];
            }
        }
        double[][] subMatrix = Regression.calculateSubMatrix(result);
        for (int eq = 1; eq < equations - 1; ++eq) {
            result[eq][0] = 0.0;
            for (int coe = 1; coe < coefficients - 1; ++coe) {
                result[eq][coe] = subMatrix[eq - 1][coe - 1];
            }
        }
        return result;
    }
}

