/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.util;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import org.jfree.chart.util.ParamChecks;
import org.jfree.ui.TextAnchor;

public class TextUtils {
    public static Rectangle2D drawAlignedString(String text, Graphics2D g2, float x2, float y2, TextAnchor anchor) {
        Rectangle2D.Double textBounds = new Rectangle2D.Double();
        float[] adjust = TextUtils.deriveTextBoundsAnchorOffsets(g2, text, anchor, textBounds);
        ((Rectangle2D)textBounds).setRect(x2 + adjust[0], y2 + adjust[1] + adjust[2], ((RectangularShape)textBounds).getWidth(), ((RectangularShape)textBounds).getHeight());
        g2.drawString(text, x2 + adjust[0], y2 + adjust[1]);
        return textBounds;
    }

    public static Rectangle2D calcAlignedStringBounds(String text, Graphics2D g2, float x2, float y2, TextAnchor anchor) {
        Rectangle2D.Double textBounds = new Rectangle2D.Double();
        float[] adjust = TextUtils.deriveTextBoundsAnchorOffsets(g2, text, anchor, textBounds);
        ((Rectangle2D)textBounds).setRect(x2 + adjust[0], y2 + adjust[1] + adjust[2], ((RectangularShape)textBounds).getWidth(), ((RectangularShape)textBounds).getHeight());
        return textBounds;
    }

    private static float[] deriveTextBoundsAnchorOffsets(Graphics2D g2, String text, TextAnchor anchor) {
        float[] result = new float[2];
        FontRenderContext frc = g2.getFontRenderContext();
        Font f2 = g2.getFont();
        FontMetrics fm = g2.getFontMetrics(f2);
        Rectangle2D bounds = TextUtils.getTextBounds(text, fm);
        LineMetrics metrics = f2.getLineMetrics(text, frc);
        float ascent = metrics.getAscent();
        float halfAscent = ascent / 2.0f;
        float descent = metrics.getDescent();
        float leading = metrics.getLeading();
        float xAdj = 0.0f;
        float yAdj = 0.0f;
        if (anchor.isHorizontalCenter()) {
            xAdj = (float)(-bounds.getWidth()) / 2.0f;
        } else if (anchor.isRight()) {
            xAdj = (float)(-bounds.getWidth());
        }
        if (anchor.isTop()) {
            yAdj = -descent - leading + (float)bounds.getHeight();
        } else if (anchor.isHalfAscent()) {
            yAdj = halfAscent;
        } else if (anchor.isVerticalCenter()) {
            yAdj = -descent - leading + (float)(bounds.getHeight() / 2.0);
        } else if (anchor.isBaseline()) {
            yAdj = 0.0f;
        } else if (anchor.isBottom()) {
            yAdj = -metrics.getDescent() - metrics.getLeading();
        }
        result[0] = xAdj;
        result[1] = yAdj;
        return result;
    }

    private static float[] deriveTextBoundsAnchorOffsets(Graphics2D g2, String text, TextAnchor anchor, Rectangle2D textBounds) {
        float[] result = new float[3];
        FontRenderContext frc = g2.getFontRenderContext();
        Font f2 = g2.getFont();
        FontMetrics fm = g2.getFontMetrics(f2);
        Rectangle2D bounds = TextUtils.getTextBounds(text, fm);
        LineMetrics metrics = f2.getLineMetrics(text, frc);
        float ascent = metrics.getAscent();
        result[2] = -ascent;
        float halfAscent = ascent / 2.0f;
        float descent = metrics.getDescent();
        float leading = metrics.getLeading();
        float xAdj = 0.0f;
        float yAdj = 0.0f;
        if (anchor.isHorizontalCenter()) {
            xAdj = (float)(-bounds.getWidth()) / 2.0f;
        } else if (anchor.isRight()) {
            xAdj = (float)(-bounds.getWidth());
        }
        if (anchor.isTop()) {
            yAdj = -descent - leading + (float)bounds.getHeight();
        } else if (anchor.isHalfAscent()) {
            yAdj = halfAscent;
        } else if (anchor.isHorizontalCenter()) {
            yAdj = -descent - leading + (float)(bounds.getHeight() / 2.0);
        } else if (anchor.isBaseline()) {
            yAdj = 0.0f;
        } else if (anchor.isBottom()) {
            yAdj = -metrics.getDescent() - metrics.getLeading();
        }
        if (textBounds != null) {
            textBounds.setRect(bounds);
        }
        result[0] = xAdj;
        result[1] = yAdj;
        return result;
    }

    public static Rectangle2D getTextBounds(String text, FontMetrics fm) {
        return TextUtils.getTextBounds(text, 0.0, 0.0, fm);
    }

    public static Rectangle2D getTextBounds(String text, double x2, double y2, FontMetrics fm) {
        ParamChecks.nullNotPermitted(text, "text");
        ParamChecks.nullNotPermitted(fm, "fm");
        double width = fm.stringWidth(text);
        double height = fm.getHeight();
        return new Rectangle2D.Double(x2, y2 - (double)fm.getAscent(), width, height);
    }
}

