/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.util;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.LinearGradientPaint;
import java.awt.Paint;
import java.awt.RadialGradientPaint;
import java.awt.TexturePaint;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.awt.image.WritableRaster;
import java.util.Hashtable;

public class PaintAlpha {
    private static final double FACTOR = 0.7;
    private static boolean legacyAlpha = false;

    public static boolean setLegacyAlpha(boolean legacyAlpha) {
        boolean old = PaintAlpha.legacyAlpha;
        PaintAlpha.legacyAlpha = legacyAlpha;
        return old;
    }

    public static Paint darker(Paint paint) {
        if (paint instanceof Color) {
            return PaintAlpha.darker((Color)paint);
        }
        if (legacyAlpha) {
            return paint;
        }
        if (paint instanceof GradientPaint) {
            return PaintAlpha.darker((GradientPaint)paint);
        }
        if (paint instanceof LinearGradientPaint) {
            return PaintAlpha.darkerLinearGradientPaint((LinearGradientPaint)paint);
        }
        if (paint instanceof RadialGradientPaint) {
            return PaintAlpha.darkerRadialGradientPaint((RadialGradientPaint)paint);
        }
        if (paint instanceof TexturePaint) {
            try {
                return PaintAlpha.darkerTexturePaint((TexturePaint)paint);
            }
            catch (Exception e2) {
                return paint;
            }
        }
        return paint;
    }

    private static Color darker(Color paint) {
        return new Color((int)((double)paint.getRed() * 0.7), (int)((double)paint.getGreen() * 0.7), (int)((double)paint.getBlue() * 0.7), paint.getAlpha());
    }

    private static GradientPaint darker(GradientPaint paint) {
        return new GradientPaint(paint.getPoint1(), PaintAlpha.darker(paint.getColor1()), paint.getPoint2(), PaintAlpha.darker(paint.getColor2()), paint.isCyclic());
    }

    private static Paint darkerLinearGradientPaint(LinearGradientPaint paint) {
        Color[] paintColors = paint.getColors();
        for (int i2 = 0; i2 < paintColors.length; ++i2) {
            paintColors[i2] = PaintAlpha.darker(paintColors[i2]);
        }
        return new LinearGradientPaint(paint.getStartPoint(), paint.getEndPoint(), paint.getFractions(), paintColors, paint.getCycleMethod(), paint.getColorSpace(), paint.getTransform());
    }

    private static Paint darkerRadialGradientPaint(RadialGradientPaint paint) {
        Color[] paintColors = paint.getColors();
        for (int i2 = 0; i2 < paintColors.length; ++i2) {
            paintColors[i2] = PaintAlpha.darker(paintColors[i2]);
        }
        return new RadialGradientPaint(paint.getCenterPoint(), paint.getRadius(), paint.getFocusPoint(), paint.getFractions(), paintColors, paint.getCycleMethod(), paint.getColorSpace(), paint.getTransform());
    }

    private static TexturePaint darkerTexturePaint(TexturePaint paint) {
        if (paint.getImage().getColorModel().isAlphaPremultiplied()) {
            // empty if block
        }
        BufferedImage img = PaintAlpha.cloneImage(paint.getImage());
        WritableRaster ras = img.copyData(null);
        int miX = ras.getMinX();
        int miY = ras.getMinY();
        int maY = ras.getMinY() + ras.getHeight();
        int wid = ras.getWidth();
        int[] pix = new int[wid * img.getSampleModel().getNumBands()];
        if (img.getColorModel() instanceof IndexColorModel) {
            int[] nco = new int[4];
            for (int y2 = miY; y2 < maY; ++y2) {
                pix = ras.getPixels(miX, y2, wid, 1, pix);
                for (int p2 = 0; p2 < pix.length; ++p2) {
                    nco = img.getColorModel().getComponents(pix[p2], nco, 0);
                    nco[0] = (int)((double)nco[0] * 0.7);
                    nco[1] = (int)((double)nco[1] * 0.7);
                    nco[2] = (int)((double)nco[2] * 0.7);
                    pix[p2] = img.getColorModel().getDataElement(nco, 0);
                }
                ras.setPixels(miX, y2, wid, 1, pix);
            }
            img.setData(ras);
            return new TexturePaint(img, paint.getAnchorRect());
        }
        if (img.getSampleModel().getNumBands() == 4) {
            for (int y3 = miY; y3 < maY; ++y3) {
                pix = ras.getPixels(miX, y3, wid, 1, pix);
                for (int p3 = 0; p3 < pix.length; ++p3) {
                    pix[p3] = (int)((double)pix[p3++] * 0.7);
                    pix[p3] = (int)((double)pix[p3++] * 0.7);
                    pix[p3] = (int)((double)pix[p3++] * 0.7);
                }
                ras.setPixels(miX, y3, wid, 1, pix);
            }
            img.setData(ras);
            return new TexturePaint(img, paint.getAnchorRect());
        }
        for (int y4 = miY; y4 < maY; ++y4) {
            pix = ras.getPixels(miX, y4, wid, 1, pix);
            for (int p4 = 0; p4 < pix.length; ++p4) {
                pix[p4] = (int)((double)pix[p4] * 0.7);
            }
            ras.setPixels(miX, y4, wid, 1, pix);
        }
        img.setData(ras);
        return new TexturePaint(img, paint.getAnchorRect());
    }

    public static BufferedImage cloneImage(BufferedImage image) {
        WritableRaster rin = image.getRaster();
        WritableRaster ras = rin.createCompatibleWritableRaster();
        ras.setRect(rin);
        Hashtable<String, Object> props = null;
        String[] propNames = image.getPropertyNames();
        if (propNames != null) {
            props = new Hashtable<String, Object>();
            for (int i2 = 0; i2 < propNames.length; ++i2) {
                props.put(propNames[i2], image.getProperty(propNames[i2]));
            }
        }
        return new BufferedImage(image.getColorModel(), ras, image.isAlphaPremultiplied(), props);
    }
}

