/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.block;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.jfree.chart.block.BlockFrame;
import org.jfree.chart.util.ParamChecks;
import org.jfree.io.SerialUtilities;
import org.jfree.ui.RectangleInsets;
import org.jfree.util.ObjectUtilities;
import org.jfree.util.PaintUtilities;

public class LineBorder
implements BlockFrame,
Serializable {
    static final long serialVersionUID = 4630356736707233924L;
    private transient Paint paint;
    private transient Stroke stroke;
    private RectangleInsets insets;

    public LineBorder() {
        this(Color.black, new BasicStroke(1.0f), new RectangleInsets(1.0, 1.0, 1.0, 1.0));
    }

    public LineBorder(Paint paint, Stroke stroke, RectangleInsets insets) {
        ParamChecks.nullNotPermitted(paint, "paint");
        ParamChecks.nullNotPermitted(stroke, "stroke");
        ParamChecks.nullNotPermitted(insets, "insets");
        this.paint = paint;
        this.stroke = stroke;
        this.insets = insets;
    }

    public Paint getPaint() {
        return this.paint;
    }

    @Override
    public RectangleInsets getInsets() {
        return this.insets;
    }

    public Stroke getStroke() {
        return this.stroke;
    }

    @Override
    public void draw(Graphics2D g2, Rectangle2D area) {
        double w2 = area.getWidth();
        double h2 = area.getHeight();
        if (w2 <= 0.0 || h2 <= 0.0) {
            return;
        }
        double t2 = this.insets.calculateTopInset(h2);
        double b2 = this.insets.calculateBottomInset(h2);
        double l2 = this.insets.calculateLeftInset(w2);
        double r2 = this.insets.calculateRightInset(w2);
        double x2 = area.getX();
        double y2 = area.getY();
        double x0 = x2 + l2 / 2.0;
        double x1 = x2 + w2 - r2 / 2.0;
        double y0 = y2 + h2 - b2 / 2.0;
        double y1 = y2 + t2 / 2.0;
        g2.setPaint(this.getPaint());
        g2.setStroke(this.getStroke());
        Object saved = g2.getRenderingHint(RenderingHints.KEY_STROKE_CONTROL);
        g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        Line2D.Double line = new Line2D.Double();
        if (t2 > 0.0) {
            ((Line2D)line).setLine(x0, y1, x1, y1);
            g2.draw(line);
        }
        if (b2 > 0.0) {
            ((Line2D)line).setLine(x0, y0, x1, y0);
            g2.draw(line);
        }
        if (l2 > 0.0) {
            ((Line2D)line).setLine(x0, y0, x0, y1);
            g2.draw(line);
        }
        if (r2 > 0.0) {
            ((Line2D)line).setLine(x1, y0, x1, y1);
            g2.draw(line);
        }
        g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, saved);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof LineBorder)) {
            return false;
        }
        LineBorder that = (LineBorder)obj;
        if (!PaintUtilities.equal(this.paint, that.paint)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.stroke, that.stroke)) {
            return false;
        }
        return this.insets.equals(that.insets);
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        SerialUtilities.writePaint(this.paint, stream);
        SerialUtilities.writeStroke(this.stroke, stream);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.paint = SerialUtilities.readPaint(stream);
        this.stroke = SerialUtilities.readStroke(stream);
    }
}

