/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.threads;

import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.threads.BlockingExecutor;
import org.jboss.threads.DirectExecutor;
import org.jboss.threads.Messages;
import org.jboss.threads.management.BoundedThreadPoolExecutorMBean;
import org.wildfly.common.Assert;

@Deprecated
class ThreadFactoryExecutor
implements BlockingExecutor,
BoundedThreadPoolExecutorMBean {
    private final ThreadFactory factory;
    private final Semaphore limitSemaphore;
    private final DirectExecutor taskExecutor;
    private final Object lock = new Object();
    private int maxThreads;
    private int largestThreadCount;
    private int currentThreadCount;
    private final AtomicInteger rejected = new AtomicInteger();
    private volatile boolean blocking;

    ThreadFactoryExecutor(ThreadFactory factory, int maxThreads, boolean blocking, DirectExecutor taskExecutor) {
        this.factory = factory;
        this.maxThreads = maxThreads;
        this.blocking = blocking;
        this.taskExecutor = taskExecutor;
        this.limitSemaphore = new Semaphore(maxThreads);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMaxThreads() {
        Object object = this.lock;
        synchronized (object) {
            return this.maxThreads;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMaxThreads(int maxThreads) {
        Assert.checkMinimumParameter("maxThreads", 0, maxThreads);
        Object object = this.lock;
        synchronized (object) {
            int old = this.maxThreads;
            int diff = old - maxThreads;
            if (diff < 0) {
                this.limitSemaphore.release(-diff);
            } else if (diff > 0 && !this.limitSemaphore.tryAcquire(diff)) {
                throw Messages.msg.cannotReduceMaxBelowCurrent();
            }
            this.maxThreads = maxThreads;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(final Runnable task) {
        Assert.checkNotNullParam("task", task);
        try {
            Semaphore semaphore = this.limitSemaphore;
            if (this.blocking) {
                try {
                    semaphore.acquire();
                }
                catch (InterruptedException e2) {
                    Thread.currentThread().interrupt();
                    throw Messages.msg.executionInterrupted();
                }
            } else if (!semaphore.tryAcquire()) {
                throw Messages.msg.taskLimitReached();
            }
            boolean ok = false;
            try {
                Thread thread = this.factory.newThread(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            Object object = ThreadFactoryExecutor.this.lock;
                            synchronized (object) {
                                int t2 = ++ThreadFactoryExecutor.this.currentThreadCount;
                                if (t2 > ThreadFactoryExecutor.this.largestThreadCount) {
                                    ThreadFactoryExecutor.this.largestThreadCount = t2;
                                }
                            }
                            ThreadFactoryExecutor.this.taskExecutor.execute(task);
                            object = ThreadFactoryExecutor.this.lock;
                            synchronized (object) {
                                ThreadFactoryExecutor.this.currentThreadCount--;
                            }
                        }
                        finally {
                            ThreadFactoryExecutor.this.limitSemaphore.release();
                        }
                    }
                });
                if (thread == null) {
                    throw Messages.msg.noThreadCreated();
                }
                thread.start();
                ok = true;
            }
            finally {
                if (!ok) {
                    semaphore.release();
                }
            }
        }
        catch (RejectedExecutionException e3) {
            this.rejected.getAndIncrement();
            throw e3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeBlocking(final Runnable task) throws RejectedExecutionException, InterruptedException {
        Assert.checkNotNullParam("task", task);
        try {
            Semaphore semaphore = this.limitSemaphore;
            semaphore.acquire();
            boolean ok = false;
            try {
                Thread thread = this.factory.newThread(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            Object object = ThreadFactoryExecutor.this.lock;
                            synchronized (object) {
                                int t2 = ++ThreadFactoryExecutor.this.currentThreadCount;
                                if (t2 > ThreadFactoryExecutor.this.largestThreadCount) {
                                    ThreadFactoryExecutor.this.largestThreadCount = t2;
                                }
                            }
                            ThreadFactoryExecutor.this.taskExecutor.execute(task);
                            object = ThreadFactoryExecutor.this.lock;
                            synchronized (object) {
                                ThreadFactoryExecutor.this.currentThreadCount--;
                            }
                        }
                        finally {
                            ThreadFactoryExecutor.this.limitSemaphore.release();
                        }
                    }
                });
                if (thread == null) {
                    throw Messages.msg.noThreadCreated();
                }
                thread.start();
                ok = true;
            }
            finally {
                if (!ok) {
                    semaphore.release();
                }
            }
        }
        catch (RejectedExecutionException e2) {
            this.rejected.getAndIncrement();
            throw e2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeBlocking(final Runnable task, long timeout, TimeUnit unit) throws RejectedExecutionException, InterruptedException {
        Assert.checkNotNullParam("task", task);
        try {
            Semaphore semaphore = this.limitSemaphore;
            if (!semaphore.tryAcquire(timeout, unit)) {
                throw Messages.msg.executionTimedOut();
            }
            boolean ok = false;
            try {
                Thread thread = this.factory.newThread(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            Object object = ThreadFactoryExecutor.this.lock;
                            synchronized (object) {
                                int t2 = ++ThreadFactoryExecutor.this.currentThreadCount;
                                if (t2 > ThreadFactoryExecutor.this.largestThreadCount) {
                                    ThreadFactoryExecutor.this.largestThreadCount = t2;
                                }
                            }
                            ThreadFactoryExecutor.this.taskExecutor.execute(task);
                            object = ThreadFactoryExecutor.this.lock;
                            synchronized (object) {
                                ThreadFactoryExecutor.this.currentThreadCount--;
                            }
                        }
                        finally {
                            ThreadFactoryExecutor.this.limitSemaphore.release();
                        }
                    }
                });
                if (thread == null) {
                    throw Messages.msg.noThreadCreated();
                }
                thread.start();
                ok = true;
            }
            finally {
                if (!ok) {
                    semaphore.release();
                }
            }
        }
        catch (RejectedExecutionException e2) {
            this.rejected.getAndIncrement();
            throw e2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeNonBlocking(final Runnable task) throws RejectedExecutionException {
        Assert.checkNotNullParam("task", task);
        try {
            Semaphore semaphore = this.limitSemaphore;
            if (!semaphore.tryAcquire()) {
                throw Messages.msg.taskLimitReached();
            }
            boolean ok = false;
            try {
                Thread thread = this.factory.newThread(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            Object object = ThreadFactoryExecutor.this.lock;
                            synchronized (object) {
                                int t2 = ++ThreadFactoryExecutor.this.currentThreadCount;
                                if (t2 > ThreadFactoryExecutor.this.largestThreadCount) {
                                    ThreadFactoryExecutor.this.largestThreadCount = t2;
                                }
                            }
                            ThreadFactoryExecutor.this.taskExecutor.execute(task);
                            object = ThreadFactoryExecutor.this.lock;
                            synchronized (object) {
                                ThreadFactoryExecutor.this.currentThreadCount--;
                            }
                        }
                        finally {
                            ThreadFactoryExecutor.this.limitSemaphore.release();
                        }
                    }
                });
                if (thread == null) {
                    throw Messages.msg.noThreadCreated();
                }
                thread.start();
                ok = true;
            }
            finally {
                if (!ok) {
                    semaphore.release();
                }
            }
        }
        catch (RejectedExecutionException e2) {
            this.rejected.getAndIncrement();
            throw e2;
        }
    }

    @Override
    public boolean isBlocking() {
        return this.blocking;
    }

    @Override
    public void setBlocking(boolean blocking) {
        this.blocking = blocking;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getLargestThreadCount() {
        Object object = this.lock;
        synchronized (object) {
            return this.largestThreadCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getCurrentThreadCount() {
        Object object = this.lock;
        synchronized (object) {
            return this.currentThreadCount;
        }
    }

    @Override
    public int getQueueSize() {
        return 0;
    }

    @Override
    public int getRejectedCount() {
        return this.rejected.get();
    }

    @Override
    public long getKeepAliveTime() {
        return 0L;
    }

    @Override
    public void setKeepAliveTime(long milliseconds) {
        if (milliseconds != 0L) {
            throw Messages.msg.keepAliveNotZero();
        }
    }

    public String toString() {
        return String.format("%s (%s)", super.toString(), this.factory);
    }
}

