/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.threads;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.jboss.threads.JBossExecutors;
import org.jboss.threads.management.ManageableThreadPoolExecutorService;
import org.jboss.threads.management.StandardThreadPoolMXBean;
import org.wildfly.common.Assert;

public final class ManagedThreadPoolExecutor
extends ThreadPoolExecutor
implements ManageableThreadPoolExecutorService {
    private final Runnable terminationTask;
    private final StandardThreadPoolMXBean mxBean = new MXBeanImpl();
    private volatile Executor handoffExecutor = JBossExecutors.rejectingExecutor();
    private static final RejectedExecutionHandler HANDLER = new RejectedExecutionHandler(){

        @Override
        public void rejectedExecution(Runnable r2, ThreadPoolExecutor executor) {
            ((ManagedThreadPoolExecutor)executor).reject(r2);
        }
    };

    public ManagedThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, Runnable terminationTask) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, HANDLER);
        this.terminationTask = terminationTask;
    }

    public ManagedThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory, Runnable terminationTask) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory, HANDLER);
        this.terminationTask = terminationTask;
    }

    public ManagedThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, Executor handoffExecutor, Runnable terminationTask) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, HANDLER);
        this.terminationTask = terminationTask;
        this.handoffExecutor = handoffExecutor;
    }

    public ManagedThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory, Executor handoffExecutor, Runnable terminationTask) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory, HANDLER);
        this.terminationTask = terminationTask;
        this.handoffExecutor = handoffExecutor;
    }

    @Override
    public StandardThreadPoolMXBean getThreadPoolMXBean() {
        return this.mxBean;
    }

    public Executor getHandoffExecutor() {
        return this.handoffExecutor;
    }

    public void setHandoffExecutor(Executor handoffExecutor) {
        Assert.checkNotNullParam("handoffExecutor", handoffExecutor);
        this.handoffExecutor = handoffExecutor;
        super.setRejectedExecutionHandler(HANDLER);
    }

    void reject(Runnable r2) {
        this.handoffExecutor.execute(r2);
    }

    @Override
    protected void terminated() {
        this.terminationTask.run();
    }

    class MXBeanImpl
    implements StandardThreadPoolMXBean {
        MXBeanImpl() {
        }

        @Override
        public float getGrowthResistance() {
            return 1.0f;
        }

        @Override
        public void setGrowthResistance(float value) {
        }

        @Override
        public boolean isGrowthResistanceSupported() {
            return false;
        }

        @Override
        public int getCorePoolSize() {
            return ManagedThreadPoolExecutor.this.getCorePoolSize();
        }

        @Override
        public void setCorePoolSize(int corePoolSize) {
            ManagedThreadPoolExecutor.this.setCorePoolSize(corePoolSize);
        }

        @Override
        public boolean isCorePoolSizeSupported() {
            return true;
        }

        @Override
        public boolean prestartCoreThread() {
            return ManagedThreadPoolExecutor.this.prestartCoreThread();
        }

        @Override
        public int prestartAllCoreThreads() {
            return ManagedThreadPoolExecutor.this.prestartAllCoreThreads();
        }

        @Override
        public boolean isCoreThreadPrestartSupported() {
            return true;
        }

        @Override
        public int getMaximumPoolSize() {
            return ManagedThreadPoolExecutor.this.getMaximumPoolSize();
        }

        @Override
        public void setMaximumPoolSize(int maxPoolSize) {
            ManagedThreadPoolExecutor.this.setMaximumPoolSize(maxPoolSize);
        }

        @Override
        public int getPoolSize() {
            return ManagedThreadPoolExecutor.this.getPoolSize();
        }

        @Override
        public int getLargestPoolSize() {
            return ManagedThreadPoolExecutor.this.getLargestPoolSize();
        }

        @Override
        public int getActiveCount() {
            return ManagedThreadPoolExecutor.this.getActiveCount();
        }

        @Override
        public boolean isAllowCoreThreadTimeOut() {
            return ManagedThreadPoolExecutor.this.allowsCoreThreadTimeOut();
        }

        @Override
        public void setAllowCoreThreadTimeOut(boolean value) {
            ManagedThreadPoolExecutor.this.allowCoreThreadTimeOut(value);
        }

        @Override
        public long getKeepAliveTimeSeconds() {
            return ManagedThreadPoolExecutor.this.getKeepAliveTime(TimeUnit.SECONDS);
        }

        @Override
        public void setKeepAliveTimeSeconds(long seconds) {
            ManagedThreadPoolExecutor.this.setKeepAliveTime(seconds, TimeUnit.SECONDS);
        }

        @Override
        public int getMaximumQueueSize() {
            return 0;
        }

        @Override
        public void setMaximumQueueSize(int size) {
        }

        @Override
        public int getQueueSize() {
            return ManagedThreadPoolExecutor.this.getQueue().size();
        }

        @Override
        public int getLargestQueueSize() {
            return 0;
        }

        @Override
        public boolean isQueueBounded() {
            return false;
        }

        @Override
        public boolean isQueueSizeModifiable() {
            return false;
        }

        @Override
        public boolean isShutdown() {
            return ManagedThreadPoolExecutor.this.isShutdown();
        }

        @Override
        public boolean isTerminating() {
            return ManagedThreadPoolExecutor.this.isTerminating();
        }

        @Override
        public boolean isTerminated() {
            return ManagedThreadPoolExecutor.this.isTerminated();
        }

        @Override
        public long getSubmittedTaskCount() {
            return ManagedThreadPoolExecutor.this.getTaskCount();
        }

        @Override
        public long getRejectedTaskCount() {
            return 0L;
        }

        @Override
        public long getCompletedTaskCount() {
            return ManagedThreadPoolExecutor.this.getCompletedTaskCount();
        }
    }
}

