/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.threads;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.threads.BlockingExecutorService;
import org.jboss.threads.EventListener;
import org.jboss.threads.Messages;
import org.jboss.threads.ShutdownListenable;
import org.jboss.threads.SimpleShutdownListenable;
import org.jboss.threads.management.BoundedQueueThreadPoolExecutorMBean;
import org.wildfly.common.Assert;

@Deprecated
public final class JBossThreadPoolExecutor
extends ThreadPoolExecutor
implements BlockingExecutorService,
BoundedQueueThreadPoolExecutorMBean,
ShutdownListenable {
    private final SimpleShutdownListenable shutdownListenable = new SimpleShutdownListenable();
    private final AtomicInteger rejectCount = new AtomicInteger();

    public JBossThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue);
        this.setRejectedExecutionHandler(super.getRejectedExecutionHandler());
    }

    public JBossThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory);
        this.setRejectedExecutionHandler(super.getRejectedExecutionHandler());
    }

    public JBossThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, RejectedExecutionHandler handler) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue);
        this.setRejectedExecutionHandler(handler);
    }

    public JBossThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory);
        this.setRejectedExecutionHandler(handler);
    }

    @Override
    public void execute(Runnable task) {
        super.execute(task);
    }

    @Override
    public void executeBlocking(Runnable task) throws RejectedExecutionException, InterruptedException {
        super.execute(task);
    }

    @Override
    public void executeBlocking(Runnable task, long timeout, TimeUnit unit) throws RejectedExecutionException, InterruptedException {
        super.execute(task);
    }

    @Override
    public void executeNonBlocking(Runnable task) throws RejectedExecutionException {
        super.execute(task);
    }

    @Override
    public int getLargestThreadCount() {
        return super.getLargestPoolSize();
    }

    @Override
    public boolean isAllowCoreThreadTimeout() {
        return this.allowsCoreThreadTimeOut();
    }

    @Override
    public void setAllowCoreThreadTimeout(boolean allow) {
        this.allowCoreThreadTimeOut(allow);
    }

    @Override
    public int getMaxThreads() {
        return this.getMaximumPoolSize();
    }

    @Override
    public void setMaxThreads(int newSize) {
        this.setMaximumPoolSize(newSize);
    }

    @Override
    public int getCoreThreads() {
        return this.getCorePoolSize();
    }

    @Override
    public void setCoreThreads(int newSize) {
        this.setCorePoolSize(newSize);
    }

    @Override
    public long getKeepAliveTime() {
        return this.getKeepAliveTime(TimeUnit.MILLISECONDS);
    }

    @Override
    public void setKeepAliveTime(long milliseconds) {
        this.setKeepAliveTime(milliseconds, TimeUnit.MILLISECONDS);
    }

    @Override
    public int getCurrentThreadCount() {
        return this.getPoolSize();
    }

    @Override
    public int getRejectedCount() {
        return this.rejectCount.get();
    }

    @Override
    public int getQueueSize() {
        return this.getQueue().size();
    }

    @Override
    public boolean isBlocking() {
        return false;
    }

    @Override
    public void setBlocking(boolean blocking) {
        throw Assert.unsupported();
    }

    @Override
    public RejectedExecutionHandler getRejectedExecutionHandler() {
        return ((CountingRejectHandler)super.getRejectedExecutionHandler()).getDelegate();
    }

    @Override
    public void setRejectedExecutionHandler(RejectedExecutionHandler handler) {
        super.setRejectedExecutionHandler(new CountingRejectHandler(handler));
    }

    @Override
    public <A> void addShutdownListener(EventListener<A> shutdownListener, A attachment) {
        this.shutdownListenable.addShutdownListener(shutdownListener, attachment);
    }

    @Override
    protected void terminated() {
        this.shutdownListenable.shutdown();
    }

    private final class CountingRejectHandler
    implements RejectedExecutionHandler {
        private final RejectedExecutionHandler delegate;

        public CountingRejectHandler(RejectedExecutionHandler delegate) {
            this.delegate = delegate;
        }

        public RejectedExecutionHandler getDelegate() {
            return this.delegate;
        }

        @Override
        public void rejectedExecution(Runnable r2, ThreadPoolExecutor executor) {
            JBossThreadPoolExecutor.this.rejectCount.incrementAndGet();
            if (JBossThreadPoolExecutor.this.isShutdown()) {
                throw Messages.msg.shutDownInitiated();
            }
            this.delegate.rejectedExecution(r2, executor);
        }
    }
}

