/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.threads;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.jboss.threads.Messages;
import org.wildfly.common.Assert;

public final class Dependency {
    private static final AtomicIntegerFieldUpdater<Dependency> depUpdater = AtomicIntegerFieldUpdater.newUpdater(Dependency.class, "remainingDependencies");
    private volatile int remainingDependencies;
    private final Executor executor;
    private final Object lock = new Object();
    private Runner runner;
    private State state;
    private static final ThreadLocal<Dependency> CTH = new ThreadLocal();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Dependency(Executor executor, Runnable runnable, int initialDepCount) {
        this.executor = executor;
        Object object = this.lock;
        synchronized (object) {
            this.runner = new Runner(runnable);
            this.state = State.WAITING;
            this.remainingDependencies = initialDepCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addDependent(Dependency task) {
        Object object = this.lock;
        synchronized (object) {
            switch (this.state) {
                case WAITING: 
                case RUNNING: {
                    this.runner.dependents.add(task);
                    return;
                }
                case FAILED: {
                    return;
                }
                case DONE: {
                    break;
                }
                default: {
                    throw Assert.impossibleSwitchCase((Object)this.state);
                }
            }
        }
        task.dependencyFinished();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dependencyFinished() {
        AtomicIntegerFieldUpdater<Dependency> updater = depUpdater;
        int res = updater.decrementAndGet(this);
        if (res == 0) {
            Runner runner = this.runner;
            Object object = this.lock;
            synchronized (object) {
                try {
                    this.executor.execute(runner);
                    this.state = State.RUNNING;
                }
                catch (RejectedExecutionException e2) {
                    Messages.msg.taskSubmitFailed(e2, runner.runnable);
                    this.state = State.FAILED;
                    runner.runnable = null;
                    runner.dependents = null;
                    this.runner = null;
                }
            }
        }
        if (res < 0) {
            updater.incrementAndGet(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dependencyFailed() {
        AtomicIntegerFieldUpdater<Dependency> updater = depUpdater;
        int res = updater.decrementAndGet(this);
        Object object = this.lock;
        synchronized (object) {
            this.state = State.FAILED;
            Runner runner = this.runner;
            runner.runnable = null;
            runner.dependents = null;
            this.runner = null;
        }
        if (res < 0) {
            updater.incrementAndGet(this);
        }
    }

    public static Dependency currentTask() {
        return CTH.get();
    }

    private static enum State {
        WAITING,
        RUNNING,
        FAILED,
        DONE;

    }

    private class Runner
    implements Runnable {
        private List<Dependency> dependents = new ArrayList<Dependency>();
        private Runnable runnable;

        public Runner(Runnable runnable) {
            this.runnable = runnable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            List<Dependency> tasks;
            boolean ok = false;
            CTH.set(Dependency.this);
            try {
                this.runnable.run();
                ok = true;
                CTH.set(null);
            }
            catch (Throwable throwable) {
                List<Dependency> tasks2;
                CTH.set(null);
                Iterator<Dependency> iterator = Dependency.this.lock;
                synchronized (iterator) {
                    tasks2 = this.dependents;
                    this.dependents = null;
                    this.runnable = null;
                    Dependency.this.runner = null;
                    Dependency.this.state = ok ? State.DONE : State.FAILED;
                }
                if (ok) {
                    for (Dependency task : tasks2) {
                        task.dependencyFinished();
                    }
                } else {
                    for (Dependency task : tasks2) {
                        task.dependencyFailed();
                    }
                }
                throw throwable;
            }
            Iterator<Dependency> iterator = Dependency.this.lock;
            synchronized (iterator) {
                tasks = this.dependents;
                this.dependents = null;
                this.runnable = null;
                Dependency.this.runner = null;
                Dependency.this.state = ok ? State.DONE : State.FAILED;
            }
            if (ok) {
                for (Dependency task : tasks) {
                    task.dependencyFinished();
                }
            } else {
                for (Dependency task : tasks) {
                    task.dependencyFailed();
                }
            }
        }
    }
}

