/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.qteslarnd1;

import org.bouncycastle.pqc.crypto.qteslarnd1.CommonFunction;
import org.bouncycastle.pqc.crypto.qteslarnd1.HashUtils;
import org.bouncycastle.pqc.crypto.qteslarnd1.PolynomialHeuristic;
import org.bouncycastle.pqc.crypto.qteslarnd1.PolynomialProvablySecure;
import org.bouncycastle.util.Arrays;

class Polynomial {
    public static final int RANDOM = 32;
    public static final int SEED = 32;
    public static final int HASH = 32;
    public static final int MESSAGE = 64;
    public static final int SIGNATURE_I = 1376;
    public static final int SIGNATURE_III_SIZE = 2720;
    public static final int SIGNATURE_III_SPEED = 2848;
    public static final int SIGNATURE_I_P = 2848;
    public static final int SIGNATURE_III_P = 6176;
    public static final int PUBLIC_KEY_I = 1504;
    public static final int PUBLIC_KEY_III_SIZE = 2976;
    public static final int PUBLIC_KEY_III_SPEED = 3104;
    public static final int PUBLIC_KEY_I_P = 14880;
    public static final int PUBLIC_KEY_III_P = 39712;
    public static final int PRIVATE_KEY_I = 1344;
    public static final int PRIVATE_KEY_III_SIZE = 2112;
    public static final int PRIVATE_KEY_III_SPEED = 2368;
    public static final int PRIVATE_KEY_I_P = 5184;
    public static final int PRIVATE_KEY_III_P = 12352;

    Polynomial() {
    }

    private static int montgomery(long l2, int n2, long l3) {
        return (int)(l2 + (l2 * l3 & 0xFFFFFFFFL) * (long)n2 >> 32);
    }

    private static long montgomeryP(long l2, int n2, long l3) {
        return l2 + (l2 * l3 & 0xFFFFFFFFL) * (long)n2 >> 32;
    }

    public static int barrett(int n2, int n3, int n4, int n5) {
        return n2 - (int)((long)n2 * (long)n4 >> n5) * n3;
    }

    public static long barrett(long l2, int n2, int n3, int n4) {
        return l2 - (l2 * (long)n3 >> n4) * (long)n2;
    }

    private static void numberTheoreticTransform(int[] nArray, int[] nArray2, int n2, int n3, long l2) {
        int n4 = 0;
        for (int i2 = n2 >> 1; i2 > 0; i2 >>= 1) {
            int n5 = 0;
            int n6 = 0;
            while (n6 < n2) {
                long l3 = nArray2[n4++];
                for (n5 = n6; n5 < n6 + i2; ++n5) {
                    int n7 = Polynomial.montgomery(l3 * (long)nArray[n5 + i2], n3, l2);
                    nArray[n5 + i2] = nArray[n5] - n7;
                    nArray[n5] = nArray[n5] + n7;
                }
                n6 = n5 + i2;
            }
        }
    }

    private static void numberTheoreticTransformIP(long[] lArray, long[] lArray2) {
        int n2 = 0;
        for (int i2 = 512; i2 > 0; i2 >>= 1) {
            int n3 = 0;
            int n4 = 0;
            while (n4 < 1024) {
                long l2 = lArray2[n2++];
                for (n3 = n4; n3 < n4 + i2; ++n3) {
                    long l3 = Polynomial.montgomeryP(l2 * lArray[n3 + i2], 485978113, 3421990911L);
                    lArray[n3 + i2] = lArray[n3] + (485978113L - l3);
                    lArray[n3] = lArray[n3] + l3;
                }
                n4 = n3 + i2;
            }
        }
    }

    private static void numberTheoreticTransformIIIP(long[] lArray, long[] lArray2) {
        int n2 = 0;
        for (int i2 = 1024; i2 > 0; i2 >>= 1) {
            int n3 = 0;
            int n4 = 0;
            while (n4 < 2048) {
                int n5 = (int)lArray2[n2++];
                for (n3 = n4; n3 < n4 + i2; ++n3) {
                    long l2 = Polynomial.barrett(Polynomial.montgomeryP((long)n5 * lArray[n3 + i2], 1129725953, 861290495L), 1129725953, 15, 34);
                    lArray[n3 + i2] = Polynomial.barrett(lArray[n3] + (2259451906L - l2), 1129725953, 15, 34);
                    lArray[n3] = Polynomial.barrett(lArray[n3] + l2, 1129725953, 15, 34);
                }
                n4 = n3 + i2;
            }
        }
    }

    private static void inverseNumberTheoreticTransformI(int[] nArray, int[] nArray2) {
        int n2;
        int n3 = 0;
        for (n2 = 1; n2 < 512; n2 *= 2) {
            int n4 = 0;
            int n5 = 0;
            while (n5 < 512) {
                long l2 = nArray2[n3++];
                for (n4 = n5; n4 < n5 + n2; ++n4) {
                    int n6 = nArray[n4];
                    nArray[n4] = n6 + nArray[n4 + n2];
                    nArray[n4 + n2] = Polynomial.montgomery(l2 * (long)(n6 - nArray[n4 + n2]), 4205569, 3098553343L);
                }
                n5 = n4 + n2;
            }
        }
        for (n2 = 0; n2 < 256; ++n2) {
            nArray[n2] = Polynomial.montgomery(1081347L * (long)nArray[n2], 4205569, 3098553343L);
        }
    }

    private static void inverseNumberTheoreticTransform(int[] nArray, int[] nArray2, int n2, int n3, long l2, int n4, int n5, int n6) {
        int n7;
        int n8 = 0;
        for (n7 = 1; n7 < n2; n7 *= 2) {
            int n9 = 0;
            int n10 = 0;
            while (n10 < n2) {
                long l3 = nArray2[n8++];
                for (n9 = n10; n9 < n10 + n7; ++n9) {
                    int n11 = nArray[n9];
                    nArray[n9] = n7 == 16 ? Polynomial.barrett(n11 + nArray[n9 + n7], n3, n5, n6) : n11 + nArray[n9 + n7];
                    nArray[n9 + n7] = Polynomial.montgomery(l3 * (long)(n11 - nArray[n9 + n7]), n3, l2);
                }
                n10 = n9 + n7;
            }
        }
        for (n7 = 0; n7 < n2 / 2; ++n7) {
            nArray[n7] = Polynomial.montgomery((long)n4 * (long)nArray[n7], n3, l2);
        }
    }

    private static void inverseNumberTheoreticTransformIP(long[] lArray, int n2, long[] lArray2, int n3) {
        int n4 = 0;
        for (int i2 = 1; i2 < 1024; i2 *= 2) {
            long l2;
            long l3;
            int n5 = 0;
            int n6 = 0;
            while (n6 < 1024) {
                l3 = lArray2[n3 + n4++];
                for (n5 = n6; n5 < n6 + i2; ++n5) {
                    l2 = lArray[n2 + n5];
                    lArray[n2 + n5] = l2 + lArray[n2 + n5 + i2];
                    lArray[n2 + n5 + i2] = Polynomial.montgomeryP(l3 * (l2 + (971956226L - lArray[n2 + n5 + i2])), 485978113, 3421990911L);
                }
                n6 = n5 + i2;
            }
            i2 *= 2;
            n6 = 0;
            while (n6 < 1024) {
                l3 = lArray2[n3 + n4++];
                for (n5 = n6; n5 < n6 + i2; ++n5) {
                    l2 = lArray[n2 + n5];
                    lArray[n2 + n5] = Polynomial.barrett(l2 + lArray[n2 + n5 + i2], 485978113, 1, 29);
                    lArray[n2 + n5 + i2] = Polynomial.montgomeryP(l3 * (l2 + (971956226L - lArray[n2 + n5 + i2])), 485978113, 3421990911L);
                }
                n6 = n5 + i2;
            }
        }
    }

    private static void inverseNumberTheoreticTransformIIIP(long[] lArray, int n2, long[] lArray2, int n3) {
        int n4 = 0;
        for (int i2 = 1; i2 < 2048; i2 *= 2) {
            int n5 = 0;
            int n6 = 0;
            while (n6 < 2048) {
                long l2 = lArray2[n3 + n4++];
                for (n5 = n6; n5 < n6 + i2; ++n5) {
                    long l3 = lArray[n2 + n5];
                    lArray[n2 + n5] = Polynomial.barrett(l3 + lArray[n2 + n5 + i2], 1129725953, 15, 34);
                    lArray[n2 + n5 + i2] = Polynomial.barrett(Polynomial.montgomeryP(l2 * (l3 + (2259451906L - lArray[n2 + n5 + i2])), 1129725953, 861290495L), 1129725953, 15, 34);
                }
                n6 = n5 + i2;
            }
        }
    }

    private static void componentWisePolynomialMultiplication(int[] nArray, int[] nArray2, int[] nArray3, int n2, int n3, long l2) {
        for (int i2 = 0; i2 < n2; ++i2) {
            nArray[i2] = Polynomial.montgomery((long)nArray2[i2] * (long)nArray3[i2], n3, l2);
        }
    }

    private static void componentWisePolynomialMultiplication(long[] lArray, int n2, long[] lArray2, int n3, long[] lArray3, int n4, int n5, int n6, long l2) {
        for (int i2 = 0; i2 < n5; ++i2) {
            lArray[n2 + i2] = Polynomial.montgomeryP(lArray2[n3 + i2] * lArray3[n4 + i2], n6, l2);
        }
    }

    public static void polynomialNumberTheoreticTransform(long[] lArray, long[] lArray2, int n2) {
        for (int i2 = 0; i2 < n2; ++i2) {
            lArray[i2] = lArray2[i2];
        }
        if (n2 == 1024) {
            Polynomial.numberTheoreticTransformIP(lArray, PolynomialProvablySecure.ZETA_I_P);
        }
        if (n2 == 2048) {
            Polynomial.numberTheoreticTransformIIIP(lArray, PolynomialProvablySecure.ZETA_III_P);
        }
    }

    public static void polynomialMultiplication(int[] nArray, int[] nArray2, int[] nArray3, int n2, int n3, long l2, int[] nArray4) {
        int[] nArray5 = new int[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            nArray5[i2] = nArray3[i2];
        }
        Polynomial.numberTheoreticTransform(nArray5, nArray4, n2, n3, l2);
        Polynomial.componentWisePolynomialMultiplication(nArray, nArray2, nArray5, n2, n3, l2);
        if (n3 == 4205569) {
            Polynomial.inverseNumberTheoreticTransformI(nArray, PolynomialHeuristic.ZETA_INVERSE_I);
        }
        if (n3 == 4206593) {
            Polynomial.inverseNumberTheoreticTransform(nArray, PolynomialHeuristic.ZETA_INVERSE_III_SIZE, 1024, 4206593, 4148178943L, 35843, 1021, 32);
        }
        if (n3 == 8404993) {
            Polynomial.inverseNumberTheoreticTransform(nArray, PolynomialHeuristic.ZETA_INVERSE_III_SPEED, 1024, 8404993, 4034936831L, 15873, 511, 32);
        }
    }

    public static void polynomialMultiplication(long[] lArray, int n2, long[] lArray2, int n3, long[] lArray3, int n4, int n5, int n6, long l2) {
        Polynomial.componentWisePolynomialMultiplication(lArray, n2, lArray2, n3, lArray3, n4, n5, n6, l2);
        if (n6 == 485978113) {
            Polynomial.inverseNumberTheoreticTransformIP(lArray, n2, PolynomialProvablySecure.ZETA_INVERSE_I_P, 0);
        }
        if (n6 == 1129725953) {
            Polynomial.inverseNumberTheoreticTransformIIIP(lArray, n2, PolynomialProvablySecure.ZETA_INVERSE_III_P, 0);
        }
    }

    public static void polynomialAddition(int[] nArray, int[] nArray2, int[] nArray3, int n2) {
        for (int i2 = 0; i2 < n2; ++i2) {
            nArray[i2] = nArray2[i2] + nArray3[i2];
        }
    }

    public static void polynomialAddition(long[] lArray, int n2, long[] lArray2, int n3, long[] lArray3, int n4, int n5) {
        for (int i2 = 0; i2 < n5; ++i2) {
            lArray[n2 + i2] = lArray2[n3 + i2] + lArray3[n4 + i2];
        }
    }

    public static void polynomialAdditionCorrection(int[] nArray, int[] nArray2, int[] nArray3, int n2, int n3) {
        for (int i2 = 0; i2 < n2; ++i2) {
            nArray[i2] = nArray2[i2] + nArray3[i2];
            int n4 = i2;
            nArray[n4] = nArray[n4] + (nArray[i2] >> 31 & n3);
            int n5 = i2;
            nArray[n5] = nArray[n5] - n3;
            int n6 = i2;
            nArray[n6] = nArray[n6] + (nArray[i2] >> 31 & n3);
        }
    }

    public static void polynomialSubtractionCorrection(int[] nArray, int[] nArray2, int[] nArray3, int n2, int n3) {
        for (int i2 = 0; i2 < n2; ++i2) {
            nArray[i2] = nArray2[i2] - nArray3[i2];
            int n4 = i2;
            nArray[n4] = nArray[n4] + (nArray[i2] >> 31 & n3);
        }
    }

    public static void polynomialSubtractionMontgomery(int[] nArray, int[] nArray2, int[] nArray3, int n2, int n3, long l2, int n4) {
        for (int i2 = 0; i2 < n2; ++i2) {
            nArray[i2] = Polynomial.montgomery((long)n4 * (long)(nArray2[i2] - nArray3[i2]), n3, l2);
        }
    }

    public static void polynomialSubtraction(long[] lArray, int n2, long[] lArray2, int n3, long[] lArray3, int n4, int n5, int n6, int n7, int n8) {
        for (int i2 = 0; i2 < n5; ++i2) {
            lArray[n2 + i2] = Polynomial.barrett(lArray2[n3 + i2] - lArray3[n4 + i2], n6, n7, n8);
        }
    }

    public static void polynomialUniform(int[] nArray, byte[] byArray, int n2, int n3, int n4, long l2, int n5, int n6, int n7) {
        int n8 = 0;
        int n9 = 0;
        int n10 = (n5 + 7) / 8;
        int n11 = n6;
        short s2 = 0;
        int n12 = (1 << n5) - 1;
        byte[] byArray2 = new byte[168 * n6];
        short s3 = s2;
        s2 = (short)(s2 + 1);
        HashUtils.customizableSecureHashAlgorithmKECCAK128Simple(byArray2, 0, 168 * n6, s3, byArray, n2, 32);
        while (n9 < n3) {
            if (n8 > 168 * n11 - 4 * n10) {
                n11 = 1;
                short s4 = s2;
                s2 = (short)(s2 + 1);
                HashUtils.customizableSecureHashAlgorithmKECCAK128Simple(byArray2, 0, 168 * n11, s4, byArray, n2, 32);
                n8 = 0;
            }
            int n13 = CommonFunction.load32(byArray2, n8) & n12;
            int n14 = CommonFunction.load32(byArray2, n8 += n10) & n12;
            int n15 = CommonFunction.load32(byArray2, n8 += n10) & n12;
            int n16 = CommonFunction.load32(byArray2, n8 += n10) & n12;
            n8 += n10;
            if (n13 < n4 && n9 < n3) {
                nArray[n9++] = Polynomial.montgomery((long)n13 * (long)n7, n4, l2);
            }
            if (n14 < n4 && n9 < n3) {
                nArray[n9++] = Polynomial.montgomery((long)n14 * (long)n7, n4, l2);
            }
            if (n15 < n4 && n9 < n3) {
                nArray[n9++] = Polynomial.montgomery((long)n15 * (long)n7, n4, l2);
            }
            if (n16 >= n4 || n9 >= n3) continue;
            nArray[n9++] = Polynomial.montgomery((long)n16 * (long)n7, n4, l2);
        }
    }

    public static void polynomialUniform(long[] lArray, byte[] byArray, int n2, int n3, int n4, int n5, long l2, int n6, int n7, int n8) {
        int n9 = 0;
        int n10 = 0;
        int n11 = (n6 + 7) / 8;
        int n12 = n7;
        short s2 = 0;
        int n13 = (1 << n6) - 1;
        byte[] byArray2 = new byte[168 * n12];
        short s3 = s2;
        s2 = (short)(s2 + 1);
        HashUtils.customizableSecureHashAlgorithmKECCAK128Simple(byArray2, 0, 168 * n12, s3, byArray, n2, 32);
        while (n10 < n3 * n4) {
            if (n9 > 168 * n12 - 4 * n11) {
                n12 = 1;
                short s4 = s2;
                s2 = (short)(s2 + 1);
                HashUtils.customizableSecureHashAlgorithmKECCAK128Simple(byArray2, 0, 168 * n12, s4, byArray, n2, 32);
                n9 = 0;
            }
            int n14 = CommonFunction.load32(byArray2, n9) & n13;
            int n15 = CommonFunction.load32(byArray2, n9 += n11) & n13;
            int n16 = CommonFunction.load32(byArray2, n9 += n11) & n13;
            int n17 = CommonFunction.load32(byArray2, n9 += n11) & n13;
            n9 += n11;
            if (n14 < n5 && n10 < n3 * n4) {
                lArray[n10++] = Polynomial.montgomeryP((long)n14 * (long)n8, n5, l2);
            }
            if (n15 < n5 && n10 < n3 * n4) {
                lArray[n10++] = Polynomial.montgomeryP((long)n15 * (long)n8, n5, l2);
            }
            if (n16 < n5 && n10 < n3 * n4) {
                lArray[n10++] = Polynomial.montgomeryP((long)n16 * (long)n8, n5, l2);
            }
            if (n17 >= n5 || n10 >= n3 * n4) continue;
            lArray[n10++] = Polynomial.montgomeryP((long)n17 * (long)n8, n5, l2);
        }
    }

    public static void sparsePolynomialMultiplication16(int[] nArray, short[] sArray, int[] nArray2, short[] sArray2, int n2, int n3) {
        Arrays.fill(nArray, 0);
        for (int i2 = 0; i2 < n3; ++i2) {
            int n4;
            int n5 = nArray2[i2];
            for (n4 = 0; n4 < n5; ++n4) {
                int n6 = n4;
                nArray[n6] = nArray[n6] - sArray2[i2] * sArray[n2 + n4 - n5];
            }
            for (n4 = n5; n4 < n2; ++n4) {
                int n7 = n4;
                nArray[n7] = nArray[n7] + sArray2[i2] * sArray[n4 - n5];
            }
        }
    }

    public static void sparsePolynomialMultiplication8(long[] lArray, int n2, byte[] byArray, int n3, int[] nArray, short[] sArray, int n4, int n5) {
        Arrays.fill(lArray, 0L);
        for (int i2 = 0; i2 < n5; ++i2) {
            int n6;
            int n7 = nArray[i2];
            for (n6 = 0; n6 < n7; ++n6) {
                int n8 = n2 + n6;
                lArray[n8] = lArray[n8] - (long)(sArray[i2] * byArray[n3 + n4 + n6 - n7]);
            }
            for (n6 = n7; n6 < n4; ++n6) {
                int n9 = n2 + n6;
                lArray[n9] = lArray[n9] + (long)(sArray[i2] * byArray[n3 + n6 - n7]);
            }
        }
    }

    public static void sparsePolynomialMultiplication32(int[] nArray, int[] nArray2, int[] nArray3, short[] sArray, int n2, int n3) {
        Arrays.fill(nArray, 0);
        for (int i2 = 0; i2 < n3; ++i2) {
            int n4;
            int n5 = nArray3[i2];
            for (n4 = 0; n4 < n5; ++n4) {
                int n6 = n4;
                nArray[n6] = nArray[n6] - sArray[i2] * nArray2[n2 + n4 - n5];
            }
            for (n4 = n5; n4 < n2; ++n4) {
                int n7 = n4;
                nArray[n7] = nArray[n7] + sArray[i2] * nArray2[n4 - n5];
            }
        }
    }

    public static void sparsePolynomialMultiplication32(long[] lArray, int n2, int[] nArray, int n3, int[] nArray2, short[] sArray, int n4, int n5, int n6, int n7, int n8) {
        int n9;
        Arrays.fill(lArray, 0L);
        for (n9 = 0; n9 < n5; ++n9) {
            int n10;
            int n11 = nArray2[n9];
            for (n10 = 0; n10 < n11; ++n10) {
                int n12 = n2 + n10;
                lArray[n12] = lArray[n12] - (long)(sArray[n9] * nArray[n3 + n4 + n10 - n11]);
            }
            for (n10 = n11; n10 < n4; ++n10) {
                int n13 = n2 + n10;
                lArray[n13] = lArray[n13] + (long)(sArray[n9] * nArray[n3 + n10 - n11]);
            }
        }
        for (n9 = 0; n9 < n4; ++n9) {
            lArray[n2 + n9] = Polynomial.barrett(lArray[n2 + n9], n6, n7, n8);
        }
    }
}

