/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.qteslarnd1;

import org.bouncycastle.crypto.digests.CSHAKEDigest;
import org.bouncycastle.crypto.digests.SHAKEDigest;

class HashUtils {
    public static final int SECURE_HASH_ALGORITHM_KECCAK_128_RATE = 168;
    public static final int SECURE_HASH_ALGORITHM_KECCAK_256_RATE = 136;

    HashUtils() {
    }

    static void secureHashAlgorithmKECCAK128(byte[] byArray, int n2, int n3, byte[] byArray2, int n4, int n5) {
        SHAKEDigest sHAKEDigest = new SHAKEDigest(128);
        sHAKEDigest.update(byArray2, n4, n5);
        sHAKEDigest.doFinal(byArray, n2, n3);
    }

    static void secureHashAlgorithmKECCAK256(byte[] byArray, int n2, int n3, byte[] byArray2, int n4, int n5) {
        SHAKEDigest sHAKEDigest = new SHAKEDigest(256);
        sHAKEDigest.update(byArray2, n4, n5);
        sHAKEDigest.doFinal(byArray, n2, n3);
    }

    static void customizableSecureHashAlgorithmKECCAK128Simple(byte[] byArray, int n2, int n3, short s2, byte[] byArray2, int n4, int n5) {
        CSHAKEDigest cSHAKEDigest = new CSHAKEDigest(128, null, new byte[]{(byte)s2, (byte)(s2 >> 8)});
        cSHAKEDigest.update(byArray2, n4, n5);
        cSHAKEDigest.doFinal(byArray, n2, n3);
    }

    static void customizableSecureHashAlgorithmKECCAK256Simple(byte[] byArray, int n2, int n3, short s2, byte[] byArray2, int n4, int n5) {
        CSHAKEDigest cSHAKEDigest = new CSHAKEDigest(256, null, new byte[]{(byte)s2, (byte)(s2 >> 8)});
        cSHAKEDigest.update(byArray2, n4, n5);
        cSHAKEDigest.doFinal(byArray, n2, n3);
    }
}

