/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.mail.smime.handlers;

import java.awt.datatransfer.DataFlavor;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.ActivationDataFlavor;
import javax.activation.DataContentHandler;
import javax.activation.DataSource;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import org.bouncycastle.mail.smime.SMIMEStreamingProcessor;

public class PKCS7ContentHandler
implements DataContentHandler {
    private final ActivationDataFlavor _adf;
    private final DataFlavor[] _dfs;

    PKCS7ContentHandler(ActivationDataFlavor activationDataFlavor, DataFlavor[] dataFlavorArray) {
        this._adf = activationDataFlavor;
        this._dfs = dataFlavorArray;
    }

    public Object getContent(DataSource dataSource) throws IOException {
        return dataSource.getInputStream();
    }

    public Object getTransferData(DataFlavor dataFlavor, DataSource dataSource) throws IOException {
        if (this._adf.equals(dataFlavor)) {
            return this.getContent(dataSource);
        }
        return null;
    }

    public DataFlavor[] getTransferDataFlavors() {
        return this._dfs;
    }

    public void writeTo(Object object, String string, OutputStream outputStream) throws IOException {
        if (object instanceof MimeBodyPart) {
            try {
                ((MimeBodyPart)object).writeTo(outputStream);
            }
            catch (MessagingException messagingException) {
                throw new IOException(messagingException.getMessage());
            }
        } else if (object instanceof byte[]) {
            outputStream.write((byte[])object);
        } else if (object instanceof InputStream) {
            int n2;
            InputStream inputStream = (InputStream)object;
            if (!(inputStream instanceof BufferedInputStream)) {
                inputStream = new BufferedInputStream(inputStream);
            }
            while ((n2 = inputStream.read()) >= 0) {
                outputStream.write(n2);
            }
            inputStream.close();
        } else if (object instanceof SMIMEStreamingProcessor) {
            SMIMEStreamingProcessor sMIMEStreamingProcessor = (SMIMEStreamingProcessor)object;
            sMIMEStreamingProcessor.write(outputStream);
        } else {
            throw new IOException("unknown object in writeTo " + object);
        }
    }
}

