/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.generators;

import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.Blake2bDigest;
import org.bouncycastle.crypto.params.Argon2Parameters;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Pack;
import org.bouncycastle.util.encoders.Hex;

public class Argon2BytesGenerator {
    private static final int ARGON2_BLOCK_SIZE = 1024;
    private static final int ARGON2_QWORDS_IN_BLOCK = 128;
    private static final int ARGON2_ADDRESSES_IN_BLOCK = 128;
    private static final int ARGON2_PREHASH_DIGEST_LENGTH = 64;
    private static final int ARGON2_PREHASH_SEED_LENGTH = 72;
    private static final int ARGON2_SYNC_POINTS = 4;
    private static final int MIN_PARALLELISM = 1;
    private static final int MAX_PARALLELISM = 0x1000000;
    private static final int MIN_OUTLEN = 4;
    private static final int MIN_ITERATIONS = 1;
    private Block[] memory;
    private int segmentLength;
    private int laneLength;
    private Argon2Parameters parameters;
    private byte[] result;

    public void init(Argon2Parameters argon2Parameters) {
        this.parameters = argon2Parameters;
        if (argon2Parameters.getLanes() < 1) {
            throw new IllegalStateException("lanes must be greater than 1");
        }
        if (argon2Parameters.getLanes() > 0x1000000) {
            throw new IllegalStateException("lanes must be less than 16777216");
        }
        if (argon2Parameters.getMemory() < 2 * argon2Parameters.getLanes()) {
            throw new IllegalStateException("memory is less than: " + 2 * argon2Parameters.getLanes() + " expected " + 2 * argon2Parameters.getLanes());
        }
        if (argon2Parameters.getIterations() < 1) {
            throw new IllegalStateException("iterations is less than: 1");
        }
        this.doInit(argon2Parameters);
    }

    public int generateBytes(char[] cArray, byte[] byArray) {
        return this.generateBytes(this.parameters.getCharToByteConverter().convert(cArray), byArray);
    }

    public int generateBytes(char[] cArray, byte[] byArray, int n2, int n3) {
        return this.generateBytes(this.parameters.getCharToByteConverter().convert(cArray), byArray, n2, n3);
    }

    public int generateBytes(byte[] byArray, byte[] byArray2) {
        return this.generateBytes(byArray, byArray2, 0, byArray2.length);
    }

    public int generateBytes(byte[] byArray, byte[] byArray2, int n2, int n3) {
        if (n3 < 4) {
            throw new IllegalStateException("output length less than 4");
        }
        this.initialize(byArray, n3);
        this.fillMemoryBlocks();
        this.digest(n3);
        System.arraycopy(this.result, 0, byArray2, n2, n3);
        this.reset();
        return n3;
    }

    private void reset() {
        for (int i2 = 0; i2 < this.memory.length; ++i2) {
            Block block = this.memory[i2];
            block.clear();
        }
        this.memory = null;
        Arrays.fill(this.result, (byte)0);
    }

    private void doInit(Argon2Parameters argon2Parameters) {
        int n2 = argon2Parameters.getMemory();
        if (n2 < 8 * argon2Parameters.getLanes()) {
            n2 = 8 * argon2Parameters.getLanes();
        }
        this.segmentLength = n2 / (argon2Parameters.getLanes() * 4);
        this.laneLength = this.segmentLength * 4;
        n2 = this.segmentLength * (argon2Parameters.getLanes() * 4);
        this.initMemory(n2);
    }

    private void initMemory(int n2) {
        this.memory = new Block[n2];
        for (int i2 = 0; i2 < this.memory.length; ++i2) {
            this.memory[i2] = new Block();
        }
    }

    private void fillMemoryBlocks() {
        FillBlock fillBlock = new FillBlock();
        Position position = new Position();
        for (int i2 = 0; i2 < this.parameters.getIterations(); ++i2) {
            for (int i3 = 0; i3 < 4; ++i3) {
                for (int i4 = 0; i4 < this.parameters.getLanes(); ++i4) {
                    position.update(i2, i4, i3, 0);
                    this.fillSegment(fillBlock, position);
                }
            }
        }
    }

    private void fillSegment(FillBlock fillBlock, Position position) {
        Block block = null;
        Block block2 = null;
        Block block3 = null;
        boolean bl = this.isDataIndependentAddressing(position);
        int n2 = Argon2BytesGenerator.getStartingIndex(position);
        int n3 = position.lane * this.laneLength + position.slice * this.segmentLength + n2;
        int n4 = this.getPrevOffset(n3);
        if (bl) {
            block = fillBlock.addressBlock.clear();
            block3 = fillBlock.zeroBlock.clear();
            block2 = fillBlock.inputBlock.clear();
            this.initAddressBlocks(fillBlock, position, block3, block2, block);
        }
        position.index = n2;
        while (position.index < this.segmentLength) {
            long l2;
            int n5 = this.getRefLane(position, l2 = this.getPseudoRandom(fillBlock, position, block, block2, block3, n4 = this.rotatePrevOffset(n3, n4), bl));
            int n6 = this.getRefColumn(position, l2, n5 == position.lane);
            Block block4 = this.memory[n4];
            Block block5 = this.memory[this.laneLength * n5 + n6];
            Block block6 = this.memory[n3];
            if (this.isWithXor(position)) {
                fillBlock.fillBlockWithXor(block4, block5, block6);
            } else {
                fillBlock.fillBlock(block4, block5, block6);
            }
            ++position.index;
            ++n3;
            ++n4;
        }
    }

    private boolean isDataIndependentAddressing(Position position) {
        return this.parameters.getType() == 1 || this.parameters.getType() == 2 && position.pass == 0 && position.slice < 2;
    }

    private void initAddressBlocks(FillBlock fillBlock, Position position, Block block, Block block2, Block block3) {
        ((Block)block2).v[0] = this.intToLong(position.pass);
        ((Block)block2).v[1] = this.intToLong(position.lane);
        ((Block)block2).v[2] = this.intToLong(position.slice);
        ((Block)block2).v[3] = this.intToLong(this.memory.length);
        ((Block)block2).v[4] = this.intToLong(this.parameters.getIterations());
        ((Block)block2).v[5] = this.intToLong(this.parameters.getType());
        if (position.pass == 0 && position.slice == 0) {
            this.nextAddresses(fillBlock, block, block2, block3);
        }
    }

    private boolean isWithXor(Position position) {
        return position.pass != 0 && this.parameters.getVersion() != 16;
    }

    private int getPrevOffset(int n2) {
        if (n2 % this.laneLength == 0) {
            return n2 + this.laneLength - 1;
        }
        return n2 - 1;
    }

    private int rotatePrevOffset(int n2, int n3) {
        if (n2 % this.laneLength == 1) {
            n3 = n2 - 1;
        }
        return n3;
    }

    private static int getStartingIndex(Position position) {
        if (position.pass == 0 && position.slice == 0) {
            return 2;
        }
        return 0;
    }

    private void nextAddresses(FillBlock fillBlock, Block block, Block block2, Block block3) {
        long[] lArray = block2.v;
        lArray[6] = lArray[6] + 1L;
        fillBlock.fillBlock(block, block2, block3);
        fillBlock.fillBlock(block, block3, block3);
    }

    private long getPseudoRandom(FillBlock fillBlock, Position position, Block block, Block block2, Block block3, int n2, boolean bl) {
        if (bl) {
            if (position.index % 128 == 0) {
                this.nextAddresses(fillBlock, block3, block2, block);
            }
            return block.v[position.index % 128];
        }
        return this.memory[n2].v[0];
    }

    private int getRefLane(Position position, long l2) {
        int n2 = (int)((l2 >>> 32) % (long)this.parameters.getLanes());
        if (position.pass == 0 && position.slice == 0) {
            n2 = position.lane;
        }
        return n2;
    }

    private int getRefColumn(Position position, long l2, boolean bl) {
        int n2;
        int n3;
        if (position.pass == 0) {
            n3 = 0;
            n2 = bl ? position.slice * this.segmentLength + position.index - 1 : position.slice * this.segmentLength + (position.index == 0 ? -1 : 0);
        } else {
            n3 = (position.slice + 1) * this.segmentLength % this.laneLength;
            n2 = bl ? this.laneLength - this.segmentLength + position.index - 1 : this.laneLength - this.segmentLength + (position.index == 0 ? -1 : 0);
        }
        long l3 = l2 & 0xFFFFFFFFL;
        l3 = l3 * l3 >>> 32;
        l3 = (long)(n2 - 1) - ((long)n2 * l3 >>> 32);
        return (int)((long)n3 + l3) % this.laneLength;
    }

    private void digest(int n2) {
        Block block = this.memory[this.laneLength - 1];
        for (int i2 = 1; i2 < this.parameters.getLanes(); ++i2) {
            int n3 = i2 * this.laneLength + (this.laneLength - 1);
            block.xorWith(this.memory[n3]);
        }
        byte[] byArray = block.toBytes();
        this.result = this.hash(byArray, n2);
    }

    private byte[] initialHash(Argon2Parameters argon2Parameters, int n2, byte[] byArray) {
        Blake2bDigest blake2bDigest = new Blake2bDigest(512);
        Argon2BytesGenerator.addIntToLittleEndian(blake2bDigest, argon2Parameters.getLanes());
        Argon2BytesGenerator.addIntToLittleEndian(blake2bDigest, n2);
        Argon2BytesGenerator.addIntToLittleEndian(blake2bDigest, argon2Parameters.getMemory());
        Argon2BytesGenerator.addIntToLittleEndian(blake2bDigest, argon2Parameters.getIterations());
        Argon2BytesGenerator.addIntToLittleEndian(blake2bDigest, argon2Parameters.getVersion());
        Argon2BytesGenerator.addIntToLittleEndian(blake2bDigest, argon2Parameters.getType());
        Argon2BytesGenerator.addByteString(blake2bDigest, byArray);
        Argon2BytesGenerator.addByteString(blake2bDigest, argon2Parameters.getSalt());
        Argon2BytesGenerator.addByteString(blake2bDigest, argon2Parameters.getSecret());
        Argon2BytesGenerator.addByteString(blake2bDigest, argon2Parameters.getAdditional());
        byte[] byArray2 = new byte[blake2bDigest.getDigestSize()];
        blake2bDigest.doFinal(byArray2, 0);
        return byArray2;
    }

    private byte[] hash(byte[] byArray, int n2) {
        byte[] byArray2 = new byte[n2];
        byte[] byArray3 = Pack.intToLittleEndian(n2);
        int n3 = 64;
        if (n2 <= n3) {
            Blake2bDigest blake2bDigest = new Blake2bDigest(n2 * 8);
            blake2bDigest.update(byArray3, 0, byArray3.length);
            blake2bDigest.update(byArray, 0, byArray.length);
            blake2bDigest.doFinal(byArray2, 0);
        } else {
            Blake2bDigest blake2bDigest = new Blake2bDigest(n3 * 8);
            byte[] byArray4 = new byte[n3];
            blake2bDigest.update(byArray3, 0, byArray3.length);
            blake2bDigest.update(byArray, 0, byArray.length);
            blake2bDigest.doFinal(byArray4, 0);
            System.arraycopy(byArray4, 0, byArray2, 0, n3 / 2);
            int n4 = (n2 + 31) / 32 - 2;
            int n5 = n3 / 2;
            int n6 = 2;
            while (n6 <= n4) {
                blake2bDigest.update(byArray4, 0, byArray4.length);
                blake2bDigest.doFinal(byArray4, 0);
                System.arraycopy(byArray4, 0, byArray2, n5, n3 / 2);
                ++n6;
                n5 += n3 / 2;
            }
            n6 = n2 - 32 * n4;
            blake2bDigest = new Blake2bDigest(n6 * 8);
            blake2bDigest.update(byArray4, 0, byArray4.length);
            blake2bDigest.doFinal(byArray2, n5);
        }
        return byArray2;
    }

    private static void roundFunction(Block block, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13, int n14, int n15, int n16, int n17) {
        Argon2BytesGenerator.F(block, n2, n6, n10, n14);
        Argon2BytesGenerator.F(block, n3, n7, n11, n15);
        Argon2BytesGenerator.F(block, n4, n8, n12, n16);
        Argon2BytesGenerator.F(block, n5, n9, n13, n17);
        Argon2BytesGenerator.F(block, n2, n7, n12, n17);
        Argon2BytesGenerator.F(block, n3, n8, n13, n14);
        Argon2BytesGenerator.F(block, n4, n9, n10, n15);
        Argon2BytesGenerator.F(block, n5, n6, n11, n16);
    }

    private static void F(Block block, int n2, int n3, int n4, int n5) {
        Argon2BytesGenerator.fBlaMka(block, n2, n3);
        Argon2BytesGenerator.rotr64(block, n5, n2, 32L);
        Argon2BytesGenerator.fBlaMka(block, n4, n5);
        Argon2BytesGenerator.rotr64(block, n3, n4, 24L);
        Argon2BytesGenerator.fBlaMka(block, n2, n3);
        Argon2BytesGenerator.rotr64(block, n5, n2, 16L);
        Argon2BytesGenerator.fBlaMka(block, n4, n5);
        Argon2BytesGenerator.rotr64(block, n3, n4, 63L);
    }

    private static void fBlaMka(Block block, int n2, int n3) {
        long l2 = (block.v[n2] & 0xFFFFFFFFL) * (block.v[n3] & 0xFFFFFFFFL);
        ((Block)block).v[n2] = block.v[n2] + block.v[n3] + 2L * l2;
    }

    private static void rotr64(Block block, int n2, int n3, long l2) {
        long l3 = block.v[n2] ^ block.v[n3];
        ((Block)block).v[n2] = l3 >>> (int)l2 | l3 << (int)(64L - l2);
    }

    private void initialize(byte[] byArray, int n2) {
        byte[] byArray2 = this.initialHash(this.parameters, n2, byArray);
        this.fillFirstBlocks(byArray2);
    }

    private static void addIntToLittleEndian(Digest digest, int n2) {
        digest.update((byte)n2);
        digest.update((byte)(n2 >>> 8));
        digest.update((byte)(n2 >>> 16));
        digest.update((byte)(n2 >>> 24));
    }

    private static void addByteString(Digest digest, byte[] byArray) {
        if (byArray != null) {
            Argon2BytesGenerator.addIntToLittleEndian(digest, byArray.length);
            digest.update(byArray, 0, byArray.length);
        } else {
            Argon2BytesGenerator.addIntToLittleEndian(digest, 0);
        }
    }

    private void fillFirstBlocks(byte[] byArray) {
        byte[] byArray2 = new byte[]{0, 0, 0, 0};
        byte[] byArray3 = new byte[]{1, 0, 0, 0};
        byte[] byArray4 = this.getInitialHashLong(byArray, byArray2);
        byte[] byArray5 = this.getInitialHashLong(byArray, byArray3);
        for (int i2 = 0; i2 < this.parameters.getLanes(); ++i2) {
            Pack.intToLittleEndian(i2, byArray4, 68);
            Pack.intToLittleEndian(i2, byArray5, 68);
            byte[] byArray6 = this.hash(byArray4, 1024);
            this.memory[i2 * this.laneLength + 0].fromBytes(byArray6);
            byArray6 = this.hash(byArray5, 1024);
            this.memory[i2 * this.laneLength + 1].fromBytes(byArray6);
        }
    }

    private byte[] getInitialHashLong(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = new byte[72];
        System.arraycopy(byArray, 0, byArray3, 0, 64);
        System.arraycopy(byArray2, 0, byArray3, 64, 4);
        return byArray3;
    }

    private long intToLong(int n2) {
        return (long)n2 & 0xFFFFFFFFL;
    }

    private static class Block {
        private static final int SIZE = 128;
        private final long[] v = new long[128];

        private Block() {
        }

        void fromBytes(byte[] byArray) {
            if (byArray.length != 1024) {
                throw new IllegalArgumentException("input shorter than blocksize");
            }
            for (int i2 = 0; i2 < 128; ++i2) {
                this.v[i2] = Pack.littleEndianToLong(byArray, i2 * 8);
            }
        }

        byte[] toBytes() {
            byte[] byArray = new byte[1024];
            for (int i2 = 0; i2 < 128; ++i2) {
                Pack.longToLittleEndian(this.v[i2], byArray, i2 * 8);
            }
            return byArray;
        }

        private void copyBlock(Block block) {
            System.arraycopy(block.v, 0, this.v, 0, 128);
        }

        private void xor(Block block, Block block2) {
            for (int i2 = 0; i2 < 128; ++i2) {
                this.v[i2] = block.v[i2] ^ block2.v[i2];
            }
        }

        public void xor(Block block, Block block2, Block block3) {
            for (int i2 = 0; i2 < 128; ++i2) {
                this.v[i2] = block.v[i2] ^ block2.v[i2] ^ block3.v[i2];
            }
        }

        private void xorWith(Block block) {
            for (int i2 = 0; i2 < this.v.length; ++i2) {
                this.v[i2] = this.v[i2] ^ block.v[i2];
            }
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i2 = 0; i2 < 128; ++i2) {
                stringBuffer.append(Hex.toHexString(Pack.longToLittleEndian(this.v[i2])));
            }
            return stringBuffer.toString();
        }

        public Block clear() {
            Arrays.fill(this.v, 0L);
            return this;
        }
    }

    private static class FillBlock {
        Block R = new Block();
        Block Z = new Block();
        Block addressBlock = new Block();
        Block zeroBlock = new Block();
        Block inputBlock = new Block();

        private FillBlock() {
        }

        private void applyBlake() {
            int n2;
            int n3;
            for (n3 = 0; n3 < 8; ++n3) {
                n2 = 16 * n3;
                Argon2BytesGenerator.roundFunction(this.Z, n2, n2 + 1, n2 + 2, n2 + 3, n2 + 4, n2 + 5, n2 + 6, n2 + 7, n2 + 8, n2 + 9, n2 + 10, n2 + 11, n2 + 12, n2 + 13, n2 + 14, n2 + 15);
            }
            for (n3 = 0; n3 < 8; ++n3) {
                n2 = 2 * n3;
                Argon2BytesGenerator.roundFunction(this.Z, n2, n2 + 1, n2 + 16, n2 + 17, n2 + 32, n2 + 33, n2 + 48, n2 + 49, n2 + 64, n2 + 65, n2 + 80, n2 + 81, n2 + 96, n2 + 97, n2 + 112, n2 + 113);
            }
        }

        private void fillBlock(Block block, Block block2, Block block3) {
            if (block == this.zeroBlock) {
                this.R.copyBlock(block2);
            } else {
                this.R.xor(block, block2);
            }
            this.Z.copyBlock(this.R);
            this.applyBlake();
            block3.xor(this.R, this.Z);
        }

        private void fillBlockWithXor(Block block, Block block2, Block block3) {
            this.R.xor(block, block2);
            this.Z.copyBlock(this.R);
            this.applyBlake();
            block3.xor(this.R, this.Z, block3);
        }
    }

    private static class Position {
        int pass;
        int lane;
        int slice;
        int index;

        Position() {
        }

        void update(int n2, int n3, int n4, int n5) {
            this.pass = n2;
            this.lane = n3;
            this.slice = n4;
            this.index = n5;
        }
    }
}

