/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.digests;

import org.bouncycastle.crypto.digests.SHAKEDigest;
import org.bouncycastle.util.Arrays;

public class CSHAKEDigest
extends SHAKEDigest {
    private static final byte[] padding = new byte[100];
    private final byte[] diff;

    public CSHAKEDigest(int n2, byte[] byArray, byte[] byArray2) {
        super(n2);
        if (!(byArray != null && byArray.length != 0 || byArray2 != null && byArray2.length != 0)) {
            this.diff = null;
        } else {
            this.diff = Arrays.concatenate(CSHAKEDigest.leftEncode(this.rate / 8), this.encodeString(byArray), this.encodeString(byArray2));
            this.diffPadAndAbsorb();
        }
    }

    private void diffPadAndAbsorb() {
        int n2;
        int n3 = this.rate / 8;
        this.absorb(this.diff, 0, this.diff.length);
        for (n2 = n3 - this.diff.length % n3; n2 > padding.length; n2 -= padding.length) {
            this.absorb(padding, 0, padding.length);
        }
        this.absorb(padding, 0, n2);
    }

    private byte[] encodeString(byte[] byArray) {
        if (byArray == null || byArray.length == 0) {
            return CSHAKEDigest.leftEncode(0L);
        }
        return Arrays.concatenate(CSHAKEDigest.leftEncode((long)byArray.length * 8L), byArray);
    }

    private static byte[] leftEncode(long l2) {
        int n2 = 1;
        long l3 = l2;
        while ((l3 >>= 8) != 0L) {
            n2 = (byte)(n2 + 1);
        }
        byte[] byArray = new byte[n2 + 1];
        byArray[0] = n2;
        for (int i2 = 1; i2 <= n2; ++i2) {
            byArray[i2] = (byte)(l2 >> 8 * (n2 - i2));
        }
        return byArray;
    }

    public int doOutput(byte[] byArray, int n2, int n3) {
        if (this.diff != null) {
            if (!this.squeezing) {
                this.absorbBits(0, 2);
            }
            this.squeeze(byArray, n2, (long)n3 * 8L);
            return n3;
        }
        return super.doOutput(byArray, n2, n3);
    }

    public void reset() {
        super.reset();
        if (this.diff != null) {
            this.diffPadAndAbsorb();
        }
    }
}

