/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.util.filetypedetector;

import java.util.HashMap;
import java.util.Map;

class ByteTrie<T> {
    private final ByteTrieNode<T> root = new ByteTrieNode();
    private int maxDepth;

    ByteTrie() {
    }

    public T find(byte[] bytes) {
        ByteTrieNode node = this.root;
        T val = node.getValue();
        for (byte b2 : bytes) {
            ByteTrieNode child = (ByteTrieNode)node.children.get(b2);
            if (child == null) break;
            node = child;
            if (node.getValue() == null) continue;
            val = node.getValue();
        }
        return val;
    }

    public void addPath(T value, byte[] ... parts) {
        int depth = 0;
        ByteTrieNode<T> node = this.root;
        byte[][] byArray = parts;
        int n2 = byArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            byte[] part;
            for (byte b2 : part = byArray[i2]) {
                ByteTrieNode<T> child = (ByteTrieNode<T>)((ByteTrieNode)node).children.get(b2);
                if (child == null) {
                    child = new ByteTrieNode<T>();
                    ((ByteTrieNode)node).children.put(b2, child);
                }
                node = child;
                ++depth;
            }
        }
        node.setValue(value);
        this.maxDepth = Math.max(this.maxDepth, depth);
    }

    public void setDefaultValue(T defaultValue) {
        this.root.setValue(defaultValue);
    }

    public int getMaxDepth() {
        return this.maxDepth;
    }

    static class ByteTrieNode<T> {
        private final Map<Byte, ByteTrieNode<T>> children = new HashMap<Byte, ByteTrieNode<T>>();
        private T value = null;

        ByteTrieNode() {
        }

        public void setValue(T value) {
            if (this.value != null) {
                throw new IllegalStateException("Value already set for this trie node");
            }
            this.value = value;
        }

        public T getValue() {
            return this.value;
        }
    }
}

