/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.tools;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.common.PDStream;

public class WriteDecodedDoc {
    private static final String PASSWORD = "-password";
    private static final String SKIPIMAGES = "-skipImages";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doIt(String in, String out, String password, boolean skipImages) throws IOException {
        PDDocument doc = null;
        try {
            doc = PDDocument.load(new File(in), password);
            doc.setAllSecurityToBeRemoved(true);
            for (COSObject cosObject : doc.getDocument().getObjects()) {
                byte[] bytes;
                COSBase base = cosObject.getObject();
                if (!(base instanceof COSStream)) continue;
                COSStream stream = (COSStream)base;
                if (skipImages && COSName.XOBJECT.equals(stream.getItem(COSName.TYPE)) && COSName.IMAGE.equals(stream.getItem(COSName.SUBTYPE))) continue;
                try {
                    bytes = new PDStream(stream).toByteArray();
                }
                catch (IOException ex) {
                    System.err.println("skip " + cosObject.getObjectNumber() + " " + cosObject.getGenerationNumber() + " obj: " + ex.getMessage());
                    continue;
                }
                stream.removeItem(COSName.FILTER);
                OutputStream streamOut = stream.createOutputStream();
                streamOut.write(bytes);
                streamOut.close();
            }
            doc.getDocumentCatalog();
            doc.getDocument().setIsXRefStream(false);
            doc.save(out);
        }
        finally {
            if (doc != null) {
                doc.close();
            }
        }
    }

    public static void main(String[] args) throws IOException {
        System.setProperty("apple.awt.UIElement", "true");
        WriteDecodedDoc app = new WriteDecodedDoc();
        String password = "";
        String pdfFile = null;
        String outputFile = null;
        boolean skipImages = false;
        for (int i2 = 0; i2 < args.length; ++i2) {
            if (args[i2].equals(PASSWORD)) {
                if (++i2 >= args.length) {
                    WriteDecodedDoc.usage();
                }
                password = args[i2];
                continue;
            }
            if (args[i2].equals(SKIPIMAGES)) {
                skipImages = true;
                continue;
            }
            if (pdfFile == null) {
                pdfFile = args[i2];
                continue;
            }
            outputFile = args[i2];
        }
        if (pdfFile == null) {
            WriteDecodedDoc.usage();
        } else {
            if (outputFile == null) {
                outputFile = WriteDecodedDoc.calculateOutputFilename(pdfFile);
            }
            app.doIt(pdfFile, outputFile, password, skipImages);
        }
    }

    private static String calculateOutputFilename(String filename) {
        String outputFilename = filename.toLowerCase().endsWith(".pdf") ? filename.substring(0, filename.length() - 4) : filename;
        outputFilename = outputFilename + "_unc.pdf";
        return outputFilename;
    }

    private static void usage() {
        String message = "Usage: java -jar pdfbox-app-x.y.z.jar WriteDecodedDoc [options] <inputfile> [outputfile]\n\nOptions:\n  -password <password> : Password to decrypt the document\n  -skipImages          : Don't uncompress images\n  <inputfile>          : The PDF document to be decompressed\n  [outputfile]         : The filename for the decompressed pdf\n";
        System.err.println(message);
        System.exit(1);
    }
}

