/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.tools;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;

public final class ImageToPDF {
    private PDRectangle mediaBox = PDRectangle.LETTER;
    private boolean landscape = false;
    private boolean autoOrientation = false;
    private boolean resize = false;

    private ImageToPDF() {
    }

    public static void main(String[] args) throws IOException {
        System.setProperty("apple.awt.UIElement", "true");
        ImageToPDF app = new ImageToPDF();
        if (args.length < 2) {
            app.usage();
        }
        ArrayList<String> imageFilenames = new ArrayList<String>();
        String pdfPath = args[args.length - 1];
        if (!pdfPath.endsWith(".pdf")) {
            System.err.println("Last argument must be the destination .pdf file");
            System.exit(1);
        }
        for (int i2 = 0; i2 < args.length - 1; ++i2) {
            if (args[i2].startsWith("-")) {
                if ("-resize".equals(args[i2])) {
                    app.resize = true;
                    continue;
                }
                if ("-landscape".equals(args[i2])) {
                    app.setLandscape(true);
                    continue;
                }
                if ("-autoOrientation".equals(args[i2])) {
                    app.setAutoOrientation(true);
                    continue;
                }
                if ("-pageSize".equals(args[i2])) {
                    PDRectangle rectangle;
                    if ((rectangle = ImageToPDF.createRectangle(args[++i2])) == null) {
                        throw new IOException("Unknown argument: " + args[i2]);
                    }
                    app.setMediaBox(rectangle);
                    continue;
                }
                throw new IOException("Unknown argument: " + args[i2]);
            }
            imageFilenames.add(args[i2]);
        }
        PDDocument doc = new PDDocument();
        app.createPDFFromImages(doc, imageFilenames);
        doc.save(pdfPath);
        doc.close();
    }

    void createPDFFromImages(PDDocument doc, List<String> imageFilenames) throws IOException {
        for (String imageFileName : imageFilenames) {
            PDImageXObject pdImage = PDImageXObject.createFromFile(imageFileName, doc);
            PDRectangle actualMediaBox = this.mediaBox;
            if (this.autoOrientation && pdImage.getWidth() > pdImage.getHeight() || this.landscape) {
                actualMediaBox = new PDRectangle(this.mediaBox.getHeight(), this.mediaBox.getWidth());
            }
            PDPage page = new PDPage(actualMediaBox);
            doc.addPage(page);
            PDPageContentStream contents = new PDPageContentStream(doc, page);
            if (this.resize) {
                contents.drawImage(pdImage, 0.0f, 0.0f, actualMediaBox.getWidth(), actualMediaBox.getHeight());
            } else {
                contents.drawImage(pdImage, 0.0f, 0.0f, (float)pdImage.getWidth(), (float)pdImage.getHeight());
            }
            contents.close();
        }
    }

    private static PDRectangle createRectangle(String paperSize) {
        if ("letter".equalsIgnoreCase(paperSize)) {
            return PDRectangle.LETTER;
        }
        if ("legal".equalsIgnoreCase(paperSize)) {
            return PDRectangle.LEGAL;
        }
        if ("A0".equalsIgnoreCase(paperSize)) {
            return PDRectangle.A0;
        }
        if ("A1".equalsIgnoreCase(paperSize)) {
            return PDRectangle.A1;
        }
        if ("A2".equalsIgnoreCase(paperSize)) {
            return PDRectangle.A2;
        }
        if ("A3".equalsIgnoreCase(paperSize)) {
            return PDRectangle.A3;
        }
        if ("A4".equalsIgnoreCase(paperSize)) {
            return PDRectangle.A4;
        }
        if ("A5".equalsIgnoreCase(paperSize)) {
            return PDRectangle.A5;
        }
        if ("A6".equalsIgnoreCase(paperSize)) {
            return PDRectangle.A6;
        }
        return null;
    }

    public PDRectangle getMediaBox() {
        return this.mediaBox;
    }

    public void setMediaBox(PDRectangle mediaBox) {
        this.mediaBox = mediaBox;
    }

    public boolean isLandscape() {
        return this.landscape;
    }

    public void setLandscape(boolean landscape) {
        this.landscape = landscape;
    }

    public boolean isAutoOrientation() {
        return this.autoOrientation;
    }

    public void setAutoOrientation(boolean autoOrientation) {
        this.autoOrientation = autoOrientation;
    }

    private void usage() {
        StringBuilder message = new StringBuilder();
        message.append("Usage: jar -jar pdfbox-app-x.y.z.jar ImageToPDF [options] <image-file>..<image-file> <output-file>\n");
        message.append("\nOptions:\n");
        message.append("  -resize              : resize to page size\n");
        message.append("  -pageSize <pageSize> : Letter (default)\n");
        message.append("                         Legal\n");
        message.append("                         A0\n");
        message.append("                         A1\n");
        message.append("                         A2\n");
        message.append("                         A3\n");
        message.append("                         A4\n");
        message.append("                         A5\n");
        message.append("                         A6\n");
        message.append("  -landscape           : sets orientation to landscape\n");
        message.append("  -autoOrientation     : sets orientation depending of image proportion\n");
        System.err.println(message.toString());
        System.exit(1);
    }
}

