/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.graphics.shading;

import java.awt.Paint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.imageio.stream.MemoryCacheImageInputStream;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdmodel.common.PDRange;
import org.apache.pdfbox.pdmodel.graphics.shading.PDTriangleBasedShadingType;
import org.apache.pdfbox.pdmodel.graphics.shading.ShadedTriangle;
import org.apache.pdfbox.pdmodel.graphics.shading.Type5ShadingPaint;
import org.apache.pdfbox.pdmodel.graphics.shading.Vertex;
import org.apache.pdfbox.util.Matrix;

public class PDShadingType5
extends PDTriangleBasedShadingType {
    public PDShadingType5(COSDictionary shadingDictionary) {
        super(shadingDictionary);
    }

    @Override
    public int getShadingType() {
        return 5;
    }

    public int getVerticesPerRow() {
        return this.getCOSObject().getInt(COSName.VERTICES_PER_ROW, -1);
    }

    public void setVerticesPerRow(int verticesPerRow) {
        this.getCOSObject().setInt(COSName.VERTICES_PER_ROW, verticesPerRow);
    }

    @Override
    public Paint toPaint(Matrix matrix) {
        return new Type5ShadingPaint(this, matrix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    List<ShadedTriangle> collectTriangles(AffineTransform xform, Matrix matrix) throws IOException {
        COSDictionary dict = this.getCOSObject();
        if (!(dict instanceof COSStream)) {
            return Collections.emptyList();
        }
        PDRange rangeX = this.getDecodeForParameter(0);
        PDRange rangeY = this.getDecodeForParameter(1);
        if (Float.compare(rangeX.getMin(), rangeX.getMax()) == 0 || Float.compare(rangeY.getMin(), rangeY.getMax()) == 0) {
            return Collections.emptyList();
        }
        int numPerRow = this.getVerticesPerRow();
        PDRange[] colRange = new PDRange[this.getNumberOfColorComponents()];
        for (int i2 = 0; i2 < colRange.length; ++i2) {
            colRange[i2] = this.getDecodeForParameter(2 + i2);
        }
        ArrayList<Vertex> vlist = new ArrayList<Vertex>();
        long maxSrcCoord = (long)Math.pow(2.0, this.getBitsPerCoordinate()) - 1L;
        long maxSrcColor = (long)Math.pow(2.0, this.getBitsPerComponent()) - 1L;
        COSStream cosStream = (COSStream)dict;
        MemoryCacheImageInputStream mciis = new MemoryCacheImageInputStream(cosStream.createInputStream());
        try {
            boolean eof = false;
            while (!eof) {
                try {
                    Vertex p2 = this.readVertex(mciis, maxSrcCoord, maxSrcColor, rangeX, rangeY, colRange, matrix, xform);
                    vlist.add(p2);
                }
                catch (EOFException ex) {
                    eof = true;
                }
            }
        }
        finally {
            mciis.close();
        }
        int rowNum = vlist.size() / numPerRow;
        Vertex[][] latticeArray = new Vertex[rowNum][numPerRow];
        ArrayList<ShadedTriangle> list = new ArrayList<ShadedTriangle>();
        if (rowNum < 2) {
            return list;
        }
        for (int i3 = 0; i3 < rowNum; ++i3) {
            for (int j2 = 0; j2 < numPerRow; ++j2) {
                latticeArray[i3][j2] = (Vertex)vlist.get(i3 * numPerRow + j2);
            }
        }
        Point2D[] ps = new Point2D[3];
        float[][] cs = new float[3][];
        for (int i4 = 0; i4 < rowNum - 1; ++i4) {
            for (int j3 = 0; j3 < numPerRow - 1; ++j3) {
                ps[0] = latticeArray[i4][j3].point;
                ps[1] = latticeArray[i4][j3 + 1].point;
                ps[2] = latticeArray[i4 + 1][j3].point;
                cs[0] = latticeArray[i4][j3].color;
                cs[1] = latticeArray[i4][j3 + 1].color;
                cs[2] = latticeArray[i4 + 1][j3].color;
                list.add(new ShadedTriangle(ps, cs));
                ps[0] = latticeArray[i4][j3 + 1].point;
                ps[1] = latticeArray[i4 + 1][j3].point;
                ps[2] = latticeArray[i4 + 1][j3 + 1].point;
                cs[0] = latticeArray[i4][j3 + 1].color;
                cs[1] = latticeArray[i4 + 1][j3].color;
                cs[2] = latticeArray[i4 + 1][j3 + 1].color;
                list.add(new ShadedTriangle(ps, cs));
            }
        }
        return list;
    }
}

