/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.jbig2.util;

import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;

public class Utils {
    private static final int BIG_ENOUGH_INT = 16384;
    private static final double BIG_ENOUGH_FLOOR = 16384.0;
    private static final double BIG_ENOUGH_ROUND = 16384.5;

    public static Rectangle enlargeRectToGrid(Rectangle2D rectangle2D) {
        int n2 = Utils.floor(rectangle2D.getMinX());
        int n3 = Utils.floor(rectangle2D.getMinY());
        int n4 = Utils.ceil(rectangle2D.getMaxX());
        int n5 = Utils.ceil(rectangle2D.getMaxY());
        return new Rectangle(n2, n3, n4 - n2, n5 - n3);
    }

    public static Rectangle2D dilateRect(Rectangle2D rectangle2D, double d2, double d3) {
        return new Rectangle2D.Double(rectangle2D.getX() - d2, rectangle2D.getY() - d3, rectangle2D.getWidth() + 2.0 * d2, rectangle2D.getHeight() + 2.0 * d3);
    }

    public static double clamp(double d2, double d3, double d4) {
        return Math.min(d4, Math.max(d2, d3));
    }

    public static int floor(double d2) {
        return (int)(d2 + 16384.0) - 16384;
    }

    public static int round(double d2) {
        return (int)(d2 + 16384.5) - 16384;
    }

    public static int ceil(double d2) {
        return 16384 - (int)(16384.0 - d2);
    }
}

