/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.jbig2.io;

import java.io.IOException;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageInputStreamImpl;

public class SubInputStream
extends ImageInputStreamImpl {
    protected final ImageInputStream wrappedStream;
    protected final long offset;
    protected final long length;
    private final byte[] buffer = new byte[4096];
    long bufferBase;
    long bufferTop;

    public SubInputStream(ImageInputStream imageInputStream, long l2, long l3) {
        assert (null != imageInputStream);
        assert (l3 >= 0L);
        assert (l2 >= 0L);
        this.wrappedStream = imageInputStream;
        this.offset = l2;
        this.length = l3;
    }

    @Override
    public int read() throws IOException {
        if (this.streamPos >= this.length) {
            return -1;
        }
        if (!(this.streamPos < this.bufferTop && this.streamPos >= this.bufferBase || this.fillBuffer())) {
            return -1;
        }
        int n2 = 0xFF & this.buffer[(int)(this.streamPos - this.bufferBase)];
        ++this.streamPos;
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        if (this.streamPos >= this.length) {
            return -1;
        }
        ImageInputStream imageInputStream = this.wrappedStream;
        synchronized (imageInputStream) {
            if (this.wrappedStream.getStreamPosition() != this.streamPos + this.offset) {
                this.wrappedStream.seek(this.streamPos + this.offset);
            }
            int n4 = (int)Math.min((long)n3, this.length - this.streamPos);
            int n5 = this.wrappedStream.read(byArray, n2, n4);
            this.streamPos += (long)n5;
            return n5;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean fillBuffer() throws IOException {
        ImageInputStream imageInputStream = this.wrappedStream;
        synchronized (imageInputStream) {
            if (this.wrappedStream.getStreamPosition() != this.streamPos + this.offset) {
                this.wrappedStream.seek(this.streamPos + this.offset);
            }
            this.bufferBase = this.streamPos;
            int n2 = (int)Math.min((long)this.buffer.length, this.length - this.streamPos);
            int n3 = this.wrappedStream.read(this.buffer, 0, n2);
            this.bufferTop = this.bufferBase + (long)n3;
            return n3 > 0;
        }
    }

    @Override
    public long length() {
        return this.length;
    }

    public void skipBits() {
        if (this.bitOffset != 0) {
            this.bitOffset = 0;
            ++this.streamPos;
        }
    }
}

