/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.jbig2.image;

import java.awt.Rectangle;
import java.awt.image.WritableRaster;
import org.apache.pdfbox.jbig2.Bitmap;
import org.apache.pdfbox.jbig2.image.BitmapScanline;
import org.apache.pdfbox.jbig2.image.Filter;
import org.apache.pdfbox.jbig2.image.ParameterizedFilter;
import org.apache.pdfbox.jbig2.image.Scanline;
import org.apache.pdfbox.jbig2.image.Weighttab;
import org.apache.pdfbox.jbig2.util.Utils;

class Resizer {
    private static final double EPSILON = 1.0E-7;
    private int weightBits = 14;
    private int weightOne = 1 << this.weightBits;
    private int[] bitsPerChannel = new int[]{8, 8, 8};
    private static final int[] NO_SHIFT = new int[16];
    private int[] finalShift = new int[]{2 * this.weightBits - this.bitsPerChannel[0], 2 * this.weightBits - this.bitsPerChannel[1], 2 * this.weightBits - this.bitsPerChannel[2]};
    static final boolean debug = false;
    private final boolean coerce = true;
    private final Order order = Order.AUTO;
    private final boolean trimZeros = true;
    private final Mapping mappingX;
    private final Mapping mappingY;

    private static boolean isInteger(double d2) {
        return Math.abs(d2 - Math.floor(d2 + 0.5)) < 1.0E-7;
    }

    public Resizer(double d2) {
        this(d2, d2);
    }

    public Resizer(double d2, double d3) {
        this.mappingX = new Mapping(d2);
        this.mappingY = new Mapping(d3);
    }

    private Weighttab[] createXWeights(Rectangle rectangle, Rectangle rectangle2, ParameterizedFilter parameterizedFilter) {
        int n2 = rectangle.x;
        int n3 = rectangle.x + rectangle.width;
        int n4 = rectangle2.x;
        int n5 = rectangle2.x + rectangle2.width;
        Weighttab[] weighttabArray = new Weighttab[rectangle2.width];
        for (int i2 = n4; i2 < n5; ++i2) {
            double d2 = this.mappingX.mapPixelCenter(i2);
            weighttabArray[i2 - n4] = new Weighttab(parameterizedFilter, this.weightOne, d2, n2, n3 - 1, true);
        }
        return weighttabArray;
    }

    private ParameterizedFilter simplifyFilter(ParameterizedFilter parameterizedFilter, double d2, double d3) {
        if (parameterizedFilter.support <= 0.5 || parameterizedFilter.filter.cardinal && Resizer.isInteger(1.0 / parameterizedFilter.scale) && Resizer.isInteger(1.0 / (d2 * parameterizedFilter.scale)) && Resizer.isInteger((d3 / d2 - 0.5) / parameterizedFilter.scale)) {
            return new ParameterizedFilter(new Filter.Point(), 1.0, 0.5, 1);
        }
        return parameterizedFilter;
    }

    private void resizeXfirst(Object object, Rectangle rectangle, Object object2, Rectangle rectangle2, ParameterizedFilter parameterizedFilter, ParameterizedFilter parameterizedFilter2) {
        int n2;
        Scanline scanline = Resizer.createScanline(object, object2, rectangle.width);
        Scanline scanline2 = Resizer.createScanline(object, object2, rectangle2.width);
        Weighttab[] weighttabArray = this.createXWeights(rectangle, rectangle2, parameterizedFilter);
        int n3 = parameterizedFilter2.width + 2;
        Scanline[] scanlineArray = new Scanline[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            scanlineArray[n2] = Resizer.createScanline(object, object2, rectangle2.width);
            scanlineArray[n2].y = -1;
        }
        n2 = rectangle.y;
        int n4 = rectangle.y + rectangle.height;
        int n5 = rectangle2.y;
        int n6 = rectangle2.y + rectangle2.height;
        int n7 = -1;
        for (int i2 = n5; i2 < n6; ++i2) {
            Weighttab weighttab = new Weighttab(parameterizedFilter2, this.weightOne, this.mappingY.mapPixelCenter(i2), n2, n4 - 1, true);
            scanline2.clear();
            for (int i3 = weighttab.i0; i3 <= weighttab.i1; ++i3) {
                Scanline scanline3 = scanlineArray[i3 % n3];
                if (scanline3.y != i3) {
                    scanline3.y = i3;
                    if (n2 + i3 <= n7) {
                        throw new AssertionError((Object)("Backtracking from line " + n7 + " to " + (n2 + i3)));
                    }
                    scanline.fetch(rectangle.x, n2 + i3);
                    n7 = n2 + i3;
                    scanline.filter(NO_SHIFT, this.bitsPerChannel, weighttabArray, scanline3);
                }
                scanline3.accumulate(weighttab.weights[i3 - weighttab.i0], scanline2);
            }
            scanline2.shift(this.finalShift);
            scanline2.store(rectangle2.x, i2);
        }
    }

    private void resizeYfirst(Object object, Rectangle rectangle, Object object2, Rectangle rectangle2, ParameterizedFilter parameterizedFilter, ParameterizedFilter parameterizedFilter2) {
        int n2;
        Scanline scanline = Resizer.createScanline(object, object2, rectangle2.width);
        Scanline scanline2 = Resizer.createScanline(object, object2, rectangle.width);
        Weighttab[] weighttabArray = this.createXWeights(rectangle, rectangle2, parameterizedFilter);
        int n3 = parameterizedFilter2.width + 2;
        Scanline[] scanlineArray = new Scanline[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            scanlineArray[n2] = Resizer.createScanline(object, object2, rectangle.width);
            scanlineArray[n2].y = -1;
        }
        n2 = rectangle.y;
        int n4 = rectangle.y + rectangle.height;
        int n5 = rectangle2.y;
        int n6 = rectangle2.y + rectangle2.height;
        int n7 = -1;
        for (int i2 = n5; i2 < n6; ++i2) {
            Weighttab weighttab = new Weighttab(parameterizedFilter2, this.weightOne, this.mappingY.mapPixelCenter(i2), n2, n4 - 1, true);
            scanline2.clear();
            for (int i3 = weighttab.i0; i3 <= weighttab.i1; ++i3) {
                Scanline scanline3 = scanlineArray[i3 % n3];
                if (scanline3.y != i3) {
                    scanline3.y = i3;
                    if (n2 + i3 <= n7) {
                        throw new AssertionError((Object)("Backtracking from line " + n7 + " to " + (n2 + i3)));
                    }
                    scanline3.fetch(rectangle.x, n2 + i3);
                    n7 = n2 + i3;
                }
                scanline3.accumulate(weighttab.weights[i3 - weighttab.i0], scanline2);
            }
            scanline2.filter(this.bitsPerChannel, this.finalShift, weighttabArray, scanline);
            scanline.store(rectangle2.x, i2);
        }
    }

    public void resize(Object object, Rectangle rectangle, Object object2, Rectangle rectangle2, Filter filter, Filter filter2) {
        boolean bl;
        ParameterizedFilter parameterizedFilter = new ParameterizedFilter(filter, this.mappingX.scale);
        ParameterizedFilter parameterizedFilter2 = new ParameterizedFilter(filter2, this.mappingY.scale);
        Rectangle rectangle3 = new Rectangle();
        int n2 = Utils.ceil(this.mappingX.srcToDst((double)rectangle.x - parameterizedFilter.support) + 1.0E-7);
        int n3 = Utils.ceil(this.mappingY.srcToDst((double)rectangle.y - parameterizedFilter2.support) + 1.0E-7);
        int n4 = Utils.floor(this.mappingX.srcToDst((double)(rectangle.x + rectangle.width) + parameterizedFilter.support) - 1.0E-7);
        int n5 = Utils.floor(this.mappingY.srcToDst((double)(rectangle.y + rectangle.height) + parameterizedFilter2.support) - 1.0E-7);
        rectangle3.setFrameFromDiagonal(n2, n3, n4, n5);
        if (rectangle2.x < rectangle3.x || rectangle2.getMaxX() > rectangle3.getMaxX() || rectangle2.y < rectangle3.y || rectangle2.getMaxY() > rectangle3.getMaxY()) {
            rectangle2 = rectangle2.intersection(rectangle3);
        }
        if (rectangle.isEmpty() || rectangle2.width <= 0 || rectangle2.height <= 0) {
            return;
        }
        parameterizedFilter = this.simplifyFilter(parameterizedFilter, this.mappingX.scale, this.mappingX.offset);
        parameterizedFilter2 = this.simplifyFilter(parameterizedFilter2, this.mappingY.scale, this.mappingY.offset);
        boolean bl2 = this.order != Order.AUTO ? this.order == Order.XY : (bl = rectangle2.width * (rectangle.height * parameterizedFilter.width + rectangle2.height * parameterizedFilter2.width) < rectangle2.height * (rectangle2.width * parameterizedFilter.width + rectangle.width * parameterizedFilter2.width));
        if (bl) {
            this.resizeXfirst(object, rectangle, object2, rectangle2, parameterizedFilter, parameterizedFilter2);
        } else {
            this.resizeYfirst(object, rectangle, object2, rectangle2, parameterizedFilter, parameterizedFilter2);
        }
    }

    private static Scanline createScanline(Object object, Object object2, int n2) {
        if (object == null) {
            throw new IllegalArgumentException("src must not be null");
        }
        if (!(object instanceof Bitmap)) {
            throw new IllegalArgumentException("src must be from type " + Bitmap.class.getName());
        }
        if (object2 == null) {
            throw new IllegalArgumentException("dst must not be null");
        }
        if (!(object2 instanceof WritableRaster)) {
            throw new IllegalArgumentException("dst must be from type " + WritableRaster.class.getName());
        }
        return new BitmapScanline((Bitmap)object, (WritableRaster)object2, n2);
    }

    private static enum Order {
        AUTO,
        XY,
        YX;

    }

    static final class Mapping {
        final double scale;
        final double offset = 0.5;
        private final double a0;
        private final double b0;

        Mapping(double d2, double d3, double d4, double d5) {
            this.a0 = d2;
            this.b0 = d4;
            this.scale = d5 / d3;
            if (this.scale <= 0.0) {
                throw new IllegalArgumentException("Negative scales are not allowed");
            }
        }

        Mapping(double d2) {
            this.scale = d2;
            this.b0 = 0.0;
            this.a0 = 0.0;
        }

        double mapPixelCenter(int n2) {
            return ((double)n2 + 0.5 - this.b0) / this.scale + this.a0;
        }

        double dstToSrc(double d2) {
            return (d2 - this.b0) / this.scale + this.a0;
        }

        double srcToDst(double d2) {
            return (d2 - this.a0) * this.scale + this.b0;
        }
    }
}

