/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.jbig2.image;

import java.awt.image.WritableRaster;
import org.apache.pdfbox.jbig2.Bitmap;
import org.apache.pdfbox.jbig2.image.Scanline;
import org.apache.pdfbox.jbig2.image.Weighttab;

final class BitmapScanline
extends Scanline {
    private Bitmap bitmap;
    private WritableRaster raster;
    private int[] lineBuffer;

    public BitmapScanline(Bitmap bitmap, WritableRaster writableRaster, int n2) {
        super(n2);
        this.bitmap = bitmap;
        this.raster = writableRaster;
        this.lineBuffer = new int[this.length];
    }

    @Override
    protected void clear() {
        this.lineBuffer = new int[this.length];
    }

    @Override
    protected void fetch(int n2, int n3) {
        this.lineBuffer = new int[this.length];
        int n4 = this.bitmap.getByteIndex(n2, n3);
        while (n2 < this.length) {
            byte by = ~this.bitmap.getByte(n4++);
            int n5 = this.bitmap.getWidth() - n2 > 8 ? 8 : this.bitmap.getWidth() - n2;
            int n6 = n5 - 1;
            while (n6 >= 0) {
                if ((by >> n6 & 1) != 0) {
                    this.lineBuffer[n2] = 255;
                }
                --n6;
                ++n2;
            }
        }
    }

    @Override
    protected void filter(int[] nArray, int[] nArray2, Weighttab[] weighttabArray, Scanline scanline) {
        BitmapScanline bitmapScanline = (BitmapScanline)scanline;
        int n2 = scanline.length;
        int n3 = 1 << nArray2[0] - 1;
        int[] nArray3 = this.lineBuffer;
        int[] nArray4 = bitmapScanline.lineBuffer;
        int n4 = nArray[0];
        int n5 = nArray2[0];
        if (n4 != 0) {
            int n6 = 0;
            for (int i2 = 0; i2 < n2; ++i2) {
                int n7;
                Weighttab weighttab = weighttabArray[i2];
                int n8 = weighttab.weights.length;
                int n9 = n3;
                int n10 = weighttab.i0;
                for (n7 = 0; n7 < n8 && n10 < nArray3.length; ++n7) {
                    n9 += weighttab.weights[n7] * (nArray3[n10++] >> n4);
                }
                n7 = n9 >> n5;
                nArray4[n6++] = n7 < 0 ? 0 : (n7 > 255 ? 255 : n7);
            }
        } else {
            int n11 = 0;
            for (int i3 = 0; i3 < n2; ++i3) {
                Weighttab weighttab = weighttabArray[i3];
                int n12 = weighttab.weights.length;
                int n13 = n3;
                int n14 = weighttab.i0;
                for (int i4 = 0; i4 < n12 && n14 < nArray3.length; ++i4) {
                    n13 += weighttab.weights[i4] * nArray3[n14++];
                }
                nArray4[n11++] = n13 >> n5;
            }
        }
    }

    @Override
    protected void accumulate(int n2, Scanline scanline) {
        BitmapScanline bitmapScanline = (BitmapScanline)scanline;
        int[] nArray = this.lineBuffer;
        int[] nArray2 = bitmapScanline.lineBuffer;
        for (int i2 = 0; i2 < nArray2.length; ++i2) {
            int n3 = i2;
            nArray2[n3] = nArray2[n3] + n2 * nArray[i2];
        }
    }

    @Override
    protected void shift(int[] nArray) {
        int n2 = nArray[0];
        int n3 = 1 << n2 - 1;
        int[] nArray2 = this.lineBuffer;
        for (int i2 = 0; i2 < nArray2.length; ++i2) {
            int n4 = nArray2[i2] + n3 >> n2;
            nArray2[i2] = n4 < 0 ? 0 : (n4 > 255 ? 255 : n4);
        }
    }

    @Override
    protected void store(int n2, int n3) {
        this.raster.setSamples(n2, n3, this.length, 1, 0, this.lineBuffer);
    }
}

