/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.jbig2.decoder.huffman;

import java.io.IOException;
import javax.imageio.stream.ImageInputStream;
import org.apache.pdfbox.jbig2.decoder.huffman.HuffmanTable;
import org.apache.pdfbox.jbig2.decoder.huffman.Node;

class ValueNode
extends Node {
    private int rangeLen;
    private int rangeLow;
    private boolean isLowerRange;

    protected ValueNode(HuffmanTable.Code code) {
        this.rangeLen = code.rangeLength;
        this.rangeLow = code.rangeLow;
        this.isLowerRange = code.isLowerRange;
    }

    @Override
    protected long decode(ImageInputStream imageInputStream) throws IOException {
        if (this.isLowerRange) {
            return (long)this.rangeLow - imageInputStream.readBits(this.rangeLen);
        }
        return (long)this.rangeLow + imageInputStream.readBits(this.rangeLen);
    }

    static String bitPattern(int n2, int n3) {
        char[] cArray = new char[n3];
        for (int i2 = 1; i2 <= n3; ++i2) {
            cArray[i2 - 1] = (n2 >> n3 - i2 & 1) != 0 ? 49 : 48;
        }
        return new String(cArray);
    }
}

