/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.jbig2.decoder.huffman;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.pdfbox.jbig2.decoder.huffman.HuffmanTable;
import org.apache.pdfbox.jbig2.io.SubInputStream;
import org.apache.pdfbox.jbig2.segments.Table;

public class EncodedTable
extends HuffmanTable {
    private Table table;

    public EncodedTable(Table table) throws IOException {
        this.table = table;
        this.parseTable();
    }

    public void parseTable() throws IOException {
        int n2;
        int n3;
        int n4;
        SubInputStream subInputStream = this.table.getSubInputStream();
        ArrayList<HuffmanTable.Code> arrayList = new ArrayList<HuffmanTable.Code>();
        for (int i2 = this.table.getHtLow(); i2 < this.table.getHtHigh(); i2 += 1 << n4) {
            n3 = (int)subInputStream.readBits(this.table.getHtPS());
            n4 = (int)subInputStream.readBits(this.table.getHtRS());
            n2 = i2;
            arrayList.add(new HuffmanTable.Code(n3, n4, n2, false));
        }
        n3 = (int)subInputStream.readBits(this.table.getHtPS());
        n4 = 32;
        n2 = this.table.getHtLow() - 1;
        arrayList.add(new HuffmanTable.Code(n3, n4, n2, true));
        n3 = (int)subInputStream.readBits(this.table.getHtPS());
        n4 = 32;
        n2 = this.table.getHtHigh();
        arrayList.add(new HuffmanTable.Code(n3, n4, n2, false));
        if (this.table.getHtOOB() == 1) {
            n3 = (int)subInputStream.readBits(this.table.getHtPS());
            arrayList.add(new HuffmanTable.Code(n3, -1, -1, false));
        }
        this.initTree(arrayList);
    }
}

