/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.jbig2;

import java.io.IOException;
import java.util.Locale;
import javax.imageio.ImageReader;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;
import org.apache.pdfbox.jbig2.JBIG2ImageReader;

public class JBIG2ImageReaderSpi
extends ImageReaderSpi {
    private static final String VENDOR = "Apache Software Foundation";
    private static final String VERSION = "1.4.1";
    private static final String READER_CLASS_NAME = "org.apache.pdfbox.jbig2.JBIG2ImageReader";
    private static final String[] NAMES = new String[]{"jbig2", "JBIG2"};
    private static final String[] SUFFIXES = new String[]{"jb2", "jbig2", "JB2", "JBIG2"};
    private static final String[] MIME_TYPES = new String[]{"image/x-jbig2", "image/x-jb2"};
    private static final Class<?>[] INPUT_TYPES = new Class[]{ImageInputStream.class};
    private static final int[] FILEHEADER_PREAMBLE = new int[]{151, 74, 66, 50, 13, 10, 26, 10};
    private static final String[] WRITER_SPI_NAMES = new String[0];
    static final boolean SUPPORTS_STANDARD_STREAM_METADATE_FORMAT = false;
    static final String NATIVE_STREAM_METADATA_FORMAT_NAME = "JBIG2 Stream Metadata";
    static final String NATIVE_STREAM_METADATA_FORMAT_CLASSNAME = "JBIG2Metadata";
    static final String[] EXTRA_STREAM_METADATA_FORMAT_NAME = null;
    static final String[] EXTRA_STREAM_METADATA_FORMAT_CLASSNAME = null;
    static final boolean SUPPORTS_STANDARD_IMAGE_METADATA_FORMAT = false;
    static final String NATIVE_IMAGE_METADATA_FORMAT_NAME = "JBIG2 File Metadata";
    static final String NATIVE_IMAGE_METADATA_FORMAT_CLASSNAME = "JBIG2Metadata";
    static final String[] EXTRA_IMAGE_METADATA_FORMAT_NAME = null;
    static final String[] EXTRA_IMAGE_METADATA_FORMAT_CLASSNAME = null;

    public JBIG2ImageReaderSpi() {
        super(VENDOR, VERSION, NAMES, SUFFIXES, MIME_TYPES, READER_CLASS_NAME, INPUT_TYPES, WRITER_SPI_NAMES, false, NATIVE_STREAM_METADATA_FORMAT_NAME, "JBIG2Metadata", EXTRA_STREAM_METADATA_FORMAT_NAME, EXTRA_STREAM_METADATA_FORMAT_CLASSNAME, false, NATIVE_IMAGE_METADATA_FORMAT_NAME, "JBIG2Metadata", EXTRA_IMAGE_METADATA_FORMAT_NAME, EXTRA_IMAGE_METADATA_FORMAT_CLASSNAME);
    }

    @Override
    public boolean canDecodeInput(Object object) throws IOException {
        if (object == null) {
            throw new IllegalArgumentException("source must not be null");
        }
        if (!(object instanceof ImageInputStream)) {
            System.out.println("source is not an ImageInputStream");
            return false;
        }
        ImageInputStream imageInputStream = (ImageInputStream)object;
        imageInputStream.mark();
        for (int i2 = 0; i2 < FILEHEADER_PREAMBLE.length; ++i2) {
            int n2 = imageInputStream.read() & 0xFF;
            if (n2 == FILEHEADER_PREAMBLE[i2]) continue;
            return false;
        }
        imageInputStream.reset();
        return true;
    }

    @Override
    public ImageReader createReaderInstance(Object object) throws IOException {
        return new JBIG2ImageReader(this);
    }

    @Override
    public String getDescription(Locale locale) {
        return "JBIG2 Image Reader";
    }
}

