/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.jbig2;

import java.awt.Rectangle;

public class Bitmap {
    private final int height;
    private final int width;
    private final int rowStride;
    private byte[] bitmap;

    public Bitmap(int n2, int n3) {
        this.height = n3;
        this.width = n2;
        this.rowStride = n2 + 7 >> 3;
        this.bitmap = new byte[this.height * this.rowStride];
    }

    public byte getPixel(int n2, int n3) {
        int n4 = this.getByteIndex(n2, n3);
        int n5 = this.getBitOffset(n2);
        int n6 = 7 - n5;
        return (byte)(this.getByte(n4) >> n6 & 1);
    }

    public void setPixel(int n2, int n3, byte by) {
        byte by2;
        int n4 = this.getByteIndex(n2, n3);
        int n5 = this.getBitOffset(n2);
        int n6 = 7 - n5;
        byte by3 = this.bitmap[n4];
        this.bitmap[n4] = by2 = (byte)(by3 | by << n6);
    }

    public int getByteIndex(int n2, int n3) {
        return n3 * this.rowStride + (n2 >> 3);
    }

    public byte[] getByteArray() {
        return this.bitmap;
    }

    public byte getByte(int n2) {
        return this.bitmap[n2];
    }

    public void setByte(int n2, byte by) {
        this.bitmap[n2] = by;
    }

    public int getByteAsInteger(int n2) {
        return this.bitmap[n2] & 0xFF;
    }

    public int getBitOffset(int n2) {
        return n2 & 7;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public int getRowStride() {
        return this.rowStride;
    }

    public Rectangle getBounds() {
        return new Rectangle(0, 0, this.width, this.height);
    }

    public int getMemorySize() {
        return this.bitmap.length;
    }
}

