/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.filter;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

final class ASCII85InputStream
extends FilterInputStream {
    private int index = 0;
    private int n = 0;
    private boolean eof = false;
    private byte[] ascii = new byte[5];
    private byte[] b = new byte[4];
    private static final char TERMINATOR = '~';
    private static final char OFFSET = '!';
    private static final char NEWLINE = '\n';
    private static final char RETURN = '\r';
    private static final char SPACE = ' ';
    private static final char PADDING_U = 'u';
    private static final char Z = 'z';

    ASCII85InputStream(InputStream is) {
        super(is);
    }

    @Override
    public int read() throws IOException {
        if (this.index >= this.n) {
            byte zz;
            byte z2;
            if (this.eof) {
                return -1;
            }
            this.index = 0;
            do {
                if ((zz = (byte)this.in.read()) != -1) continue;
                this.eof = true;
                return -1;
            } while ((z2 = (byte)zz) == 10 || z2 == 13 || z2 == 32);
            if (z2 == 126) {
                this.eof = true;
                this.b = null;
                this.ascii = null;
                this.n = 0;
                return -1;
            }
            if (z2 == 122) {
                this.b[3] = 0;
                this.b[2] = 0;
                this.b[1] = 0;
                this.b[0] = 0;
                this.n = 4;
            } else {
                int k2;
                this.ascii[0] = z2;
                for (k2 = 1; k2 < 5; ++k2) {
                    do {
                        if ((zz = (byte)this.in.read()) != -1) continue;
                        this.eof = true;
                        return -1;
                    } while ((z2 = (byte)zz) == 10 || z2 == 13 || z2 == 32);
                    this.ascii[k2] = z2;
                    if (z2 != 126) continue;
                    this.ascii[k2] = 117;
                    break;
                }
                this.n = k2 - 1;
                if (this.n == 0) {
                    this.eof = true;
                    this.ascii = null;
                    this.b = null;
                    return -1;
                }
                if (k2 < 5) {
                    ++k2;
                    while (k2 < 5) {
                        this.ascii[k2] = 117;
                        ++k2;
                    }
                    this.eof = true;
                }
                long t2 = 0L;
                for (k2 = 0; k2 < 5; ++k2) {
                    z2 = (byte)(this.ascii[k2] - 33);
                    if (z2 < 0 || z2 > 93) {
                        this.n = 0;
                        this.eof = true;
                        this.ascii = null;
                        this.b = null;
                        throw new IOException("Invalid data in Ascii85 stream");
                    }
                    t2 = t2 * 85L + (long)z2;
                }
                for (k2 = 3; k2 >= 0; --k2) {
                    this.b[k2] = (byte)(t2 & 0xFFL);
                    t2 >>>= 8;
                }
            }
        }
        return this.b[this.index++] & 0xFF;
    }

    @Override
    public int read(byte[] data, int offset, int len) throws IOException {
        if (this.eof && this.index >= this.n) {
            return -1;
        }
        for (int i2 = 0; i2 < len; ++i2) {
            if (this.index < this.n) {
                data[i2 + offset] = this.b[this.index++];
                continue;
            }
            int t2 = this.read();
            if (t2 == -1) {
                return i2;
            }
            data[i2 + offset] = (byte)t2;
        }
        return len;
    }

    @Override
    public void close() throws IOException {
        this.ascii = null;
        this.eof = true;
        this.b = null;
        super.close();
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public long skip(long nValue) {
        return 0L;
    }

    @Override
    public int available() {
        return 0;
    }

    @Override
    public synchronized void mark(int readlimit) {
    }

    @Override
    public synchronized void reset() throws IOException {
        throw new IOException("Reset is not supported");
    }
}

