/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.debugger.stringpane;

import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.JTextPane;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.debugger.hexviewer.HexView;

public class StringPane {
    private static final String TEXT_TAB = "Text View";
    private static final String HEX_TAB = "Hex view";
    private final JTabbedPane tabbedPane = new JTabbedPane();

    public StringPane(COSString cosString) {
        this.tabbedPane.setPreferredSize(new Dimension(300, 500));
        this.tabbedPane.addTab(TEXT_TAB, this.createTextView(cosString));
        this.tabbedPane.addTab(HEX_TAB, this.createHexView(cosString));
    }

    private JTextPane createTextView(COSString cosString) {
        JTextPane textPane = new JTextPane();
        textPane.setText(this.getTextString(cosString));
        textPane.setEditable(false);
        return textPane;
    }

    private JComponent createHexView(COSString cosString) {
        HexView hexView = new HexView(cosString.getBytes());
        return hexView.getPane();
    }

    private String getTextString(COSString cosString) {
        String text = cosString.getString();
        for (char c2 : text.toCharArray()) {
            if (!Character.isISOControl(c2) || c2 == '\n' || c2 == '\r' || c2 == '\t') continue;
            text = "<" + cosString.toHexString() + ">";
            break;
        }
        return "" + text;
    }

    public JTabbedPane getPane() {
        return this.tabbedPane;
    }
}

