/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.nt;

import com.oracle.common.base.Disposable;
import com.oracle.common.internal.net.ipclw.mql.AtomicBuffers;
import com.oracle.common.internal.net.ipclw.mql.Context;
import com.oracle.common.internal.net.ipclw.mql.KeyedBufferSequence;
import com.oracle.common.internal.net.ipclw.mql.KeyedSingleBufferSequence;
import com.oracle.common.internal.net.ipclw.mql.RegistrationKey;
import com.oracle.common.internal.net.ipclw.mql.RemoteQueue;
import com.oracle.common.io.BufferSequence;
import java.io.IOException;
import java.lang.reflect.Executable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.logging.annotations.Log;

public class MQLFlowControl {
    private RemoteQueue remoteQueue;
    private ByteBuffer localFCB;
    private RegistrationKey localFCBKey;
    private ByteBuffer writeBuffer;
    private KeyedBufferSequence writeBufferSeq;
    private RegistrationKey remoteFCBKey;
    private short localBufferPostCount;
    private short availableRcvBuffers;
    private short remoteBufferPostCount;
    private byte localIRCount;
    private byte remoteIRCount;
    private boolean receivedIR = false;
    private BufferSequence interrupt;
    private boolean rdmaPending = false;
    private Disposable cookie = new Disposable(){

        public void dispose() {
            MQLFlowControl.this.rdmaPending = false;
        }
    };
    private short lastCountSent = 0;
    static final int USR_WRITE_WAIT = 5000;
    static final int SYS_WRITE_WAIT = 0;
    static final int USR_PENDING_WAIT = 5000;
    static final int SYS_PENDING_WAIT = 0;
    static final int FCB_SIZE = 8;
    static final int OFFSET_SHORT_BUFFER_COUNT = 0;
    static final int BUFFER_COUNT_SIZE = 2;
    static final int OFFSET_BYTE_INTERRUPT_REQUEST = 2;
    static final int INTERRUPT_REQUEST_SIZE = 1;

    public MQLFlowControl(Context context, Context context2) throws IOException {
        this.initLocalFCB(context);
        this.initWriteBuffer(context2);
    }

    private void initLocalFCB(Context context) throws IOException {
        this.localFCB = ByteBuffer.allocateDirect(8);
        this.localFCB.order(ByteOrder.nativeOrder());
        this.localFCB.clear();
        this.localFCBKey = context.register(this.localFCB);
        this.localFCB.clear();
    }

    private void initWriteBuffer(Context context) throws IOException {
        this.writeBuffer = ByteBuffer.allocateDirect(8).order(ByteOrder.LITTLE_ENDIAN);
        RegistrationKey registrationKey = context.register(this.writeBuffer);
        this.writeBufferSeq = new KeyedSingleBufferSequence(null, this.writeBuffer, context, registrationKey);
    }

    protected RegistrationKey getLocalFCBKey() {
        return this.localFCBKey;
    }

    protected void resetLocalFCB() {
        this.localFCB.clear();
        while (this.localFCB.hasRemaining()) {
            this.localFCB.put((byte)0);
        }
        this.localFCB.clear();
    }

    protected void onFlowControlEnabled(short s2, ByteBuffer byteBuffer, long l2, RemoteQueue remoteQueue, BufferSequence bufferSequence) throws IOException {
        this.remoteQueue = remoteQueue;
        this.interrupt = bufferSequence;
        this.localFCB.putShort(0, s2);
        this.availableRcvBuffers = s2;
        this.remoteBufferPostCount = s2;
        this.remoteFCBKey = new RegistrationKey(byteBuffer, l2, 8L);
        this.writeRemoteFCB(true);
    }

    private short readRemoteBufferPostCount() {
        short s2;
        long l2;
        do {
            l2 = this.localFCB.getLong(0);
            s2 = this.localFCB.getShort(0);
        } while (l2 != AtomicBuffers.getAndAdd((ByteBuffer)this.localFCB, (int)0, (long)0L));
        return s2;
    }

    private boolean isInterruptRequested() {
        byte by;
        long l2;
        do {
            l2 = this.localFCB.getLong(0);
            by = this.localFCB.get(2);
        } while (l2 != AtomicBuffers.getAndAdd((ByteBuffer)this.localFCB, (int)0, (long)0L));
        if ((byte)(by - this.remoteIRCount) > 0) {
            this.remoteIRCount = by;
            return true;
        }
        return false;
    }

    public void sendCounterUpdate() throws IOException {
        while (this.needToUpdate()) {
            this.writeRemoteFCB(true);
        }
    }

    protected void onBufferPosted(int n2) {
        if (n2 <= 0) {
            return;
        }
        this.localBufferPostCount = (short)(this.localBufferPostCount + n2);
        try {
            this.writeRemoteFCB(false, false);
        }
        catch (IOException iOException) {
        }
    }

    private void writeRemoteFCB(boolean bl) throws IOException {
        this.writeRemoteFCB(bl, true);
    }

    private boolean writeRemoteFCB(boolean bl, boolean bl2) throws IOException {
        if (this.rdmaPending) {
            if (bl2) {
                while (this.remoteQueue.isWorkPending()) {
                    this.remoteQueue.getContext().await(5000, 0);
                }
            } else {
                return false;
            }
        }
        this.writeBuffer.putShort(0, this.localBufferPostCount);
        this.writeBuffer.put(2, this.localIRCount);
        short s2 = this.lastCountSent;
        this.lastCountSent = this.localBufferPostCount;
        BufferSequence bufferSequence = null;
        if (this.receivedIR) {
            bufferSequence = this.interrupt;
            this.receivedIR = false;
        }
        this.rdmaPending = true;
        if (bl2) {
            while (!this.remoteQueue.write(this.remoteFCBKey, 0L, this.writeBufferSeq, bufferSequence, (Object)this.cookie, 1)) {
                this.remoteQueue.getContext().await(5000, 0);
            }
            if (bl) {
                while (this.remoteQueue.isWorkPending()) {
                    this.remoteQueue.getContext().await(5000, 0);
                }
            }
        } else if (!this.remoteQueue.write(this.remoteFCBKey, 0L, this.writeBufferSeq, bufferSequence, (Object)this.cookie, 1)) {
            this.receivedIR = bufferSequence != null;
            this.lastCountSent = s2;
            this.rdmaPending = false;
            return false;
        }
        return true;
    }

    public boolean needToUpdate() {
        return this.receivedIR || this.localBufferPostCount > this.lastCountSent || this.rdmaPending;
    }

    protected boolean sendInterruptRequest(boolean bl) throws IOException {
        this.localIRCount = (byte)(this.localIRCount + 1);
        if (this.writeRemoteFCB(true, bl)) {
            return true;
        }
        this.localIRCount = (byte)(this.localIRCount - 1);
        return false;
    }

    public byte getInterruptRequestCount() {
        return this.localIRCount;
    }

    protected int getAvailableBufferCount() {
        short s2 = this.remoteBufferPostCount;
        this.remoteBufferPostCount = this.readRemoteBufferPostCount();
        this.availableRcvBuffers = (short)(this.availableRcvBuffers + (short)(this.remoteBufferPostCount - s2));
        return this.availableRcvBuffers;
    }

    protected void onMessageSent() {
        this.availableRcvBuffers = (short)(this.availableRcvBuffers - 1);
    }

    protected void onMessageReceived() {
        if (this.isInterruptRequested()) {
            this.receivedIR = true;
        }
    }

    protected void onIRMessage(byte by) {
        if ((byte)(by - this.remoteIRCount) > 0) {
            this.remoteIRCount = by;
            this.receivedIR = true;
        }
    }

    protected void setLocalPostCount(short s2) {
        this.localBufferPostCount = s2;
    }

    protected int getLocalPostCount() {
        return this.localBufferPostCount;
    }

    public void onDisconnect(Context context) {
        if (this.localFCB != null) {
            try {
                context.unregister(this.localFCBKey);
            }
            catch (IOException iOException) {
            }
            this.localFCB = null;
        }
        if (this.writeBufferSeq != null) {
            this.writeBufferSeq.dispose();
            this.writeBufferSeq = null;
        }
        if (this.interrupt != null) {
            this.interrupt.dispose();
        }
    }

    public String toString() {
        return "Local Counter = " + this.localBufferPostCount + "Local Counter Last Written = " + this.lastCountSent + " Remote Counter Last Read = " + this.remoteBufferPostCount + " Current Remote Counter = " + this.readRemoteBufferPostCount() + " Remote Available Receive Buffers = " + this.availableRcvBuffers + " Interrupt Requested = " + this.isInterruptRequested();
    }

    @Log
    protected void debug(Logger logger2, Level level, Executable executable, String string) {
        ClioSupport.log(logger2, level, this.getClass(), executable, string);
    }
}

