/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.xa;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Executable;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Log;
import oracle.jdbc.logging.annotations.Supports;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.XA})
public class OracleMultiPhaseArgs {
    int action = 0;
    int nsites = 0;
    Vector dbLinks = null;
    Vector xids = null;
    private static final String _Copyright_2014_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;

    public OracleMultiPhaseArgs() {
    }

    public OracleMultiPhaseArgs(int n2, int n3, Vector vector, Vector vector2) {
        if (n3 <= 1) {
            this.action = 0;
            this.nsites = 0;
            this.dbLinks = null;
            this.xids = null;
        } else if (!vector.isEmpty() && !vector2.isEmpty() && vector2.size() == n3) {
            if (vector.size() != 3 * n3) {
            } else {
                this.action = n2;
                this.nsites = n3;
                this.xids = vector;
                this.dbLinks = vector2;
            }
        }
    }

    public OracleMultiPhaseArgs(byte[] byArray) {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        this.xids = new Vector();
        this.dbLinks = new Vector();
        try {
            this.action = dataInputStream.readInt();
            this.nsites = dataInputStream.readInt();
            int n2 = dataInputStream.readInt();
            int n3 = dataInputStream.readInt();
            byte[] byArray2 = new byte[n3];
            int n4 = dataInputStream.read(byArray2, 0, n3);
            for (int i2 = 0; i2 < this.nsites; ++i2) {
                int n5 = dataInputStream.readInt();
                byte[] byArray3 = new byte[n5];
                int n6 = dataInputStream.read(byArray3, 0, n5);
                this.xids.addElement(n2);
                this.xids.addElement(byArray2);
                this.xids.addElement(byArray3);
                String string = dataInputStream.readUTF();
                this.dbLinks.addElement(string);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public byte[] toByteArray() {
        return this.toByteArrayOS().toByteArray();
    }

    public ByteArrayOutputStream toByteArrayOS() {
        byte[] byArray = null;
        int n2 = 0;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.writeInt(this.action);
            dataOutputStream.writeInt(this.nsites);
            for (int i2 = 0; i2 < this.nsites; ++i2) {
                String string = (String)this.dbLinks.elementAt(i2);
                int n3 = (Integer)this.xids.elementAt(i2 * 3);
                byte[] byArray2 = (byte[])this.xids.elementAt(i2 * 3 + 1);
                byte[] byArray3 = (byte[])this.xids.elementAt(i2 * 3 + 2);
                if (i2 == 0) {
                    n2 = n3;
                    byArray = byArray2;
                    dataOutputStream.writeInt(n3);
                    dataOutputStream.writeInt(byArray2.length);
                    dataOutputStream.write(byArray2, 0, byArray2.length);
                }
                dataOutputStream.writeInt(byArray3.length);
                dataOutputStream.write(byArray3, 0, byArray3.length);
                dataOutputStream.writeUTF(string);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return byteArrayOutputStream;
    }

    public int getAction() {
        return this.action;
    }

    public int getnsite() {
        return this.nsites;
    }

    public Vector getdbLinks() {
        return this.dbLinks;
    }

    public Vector getXids() {
        return this.xids;
    }

    public void printMPArgs() {
        for (int i2 = 0; i2 < this.nsites; ++i2) {
            String string = (String)this.dbLinks.elementAt(i2);
            int n2 = (Integer)this.xids.elementAt(i2 * 3);
            byte[] byArray = (byte[])this.xids.elementAt(i2 * 3 + 1);
            byte[] byArray2 = (byte[])this.xids.elementAt(i2 * 3 + 2);
            this.printByteArray(byArray);
            this.printByteArray(byArray2);
        }
    }

    private void printByteArray(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            stringBuffer.append(byArray[i2] + " ");
        }
    }

    @Log
    protected void debug(Logger logger2, Level level, Executable executable, String string) {
        ClioSupport.log(logger2, level, this.getClass(), executable, string);
    }
}

